#
# ArcLabel.tcl
# ------------------------------------------------------------------------
# This class is a subclass of Label but with editing and attribute dialog
# disabled.
# ------------------------------------------------------------------------
# @(#) $Id: ArcLabel.tcl,v 1.1 1996/10/29 01:04:52 emery Exp $
#
# ------------------------------------------------------------------------
# AUTHOR:
#
# Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
# Systems Analyst                 @           <mailto:emery@cs.utexas.edu>
# Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
# Department of Computer Sciences |             <http://www.cs.utexas.edu>
# University of Texas at Austin   |                <http://www.utexas.edu>
# ========================================================================


class Code::ArcLabel {

    inherit Code::Label

    constructor {args} {
	eval Label::constructor $args
    } {
	# Start out in display mode.

	dispmode
    }

    public method save {out} {
	CodeObj::save $out
	puts $out "\$obj dispmode"
    }

    # Disable editing.

    public method editmode {} {}

    # Disable attribute window.

    public method attributes {} {}
}
