#
# Comment.tcl
# ------------------------------------------------------------------------
# This class is essentially identical to Label, but has a different name
# so we can distinguish Node Labels from Comments (created with the Text
# tool.
# ------------------------------------------------------------------------
# @(#) $Id: Comment.tcl,v 1.4 1996/01/11 21:15:32 emery Exp $
#
# ------------------------------------------------------------------------
# AUTHOR:
#
# Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
# Systems Analyst                 @           <mailto:emery@cs.utexas.edu>
# Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
# Department of Computer Sciences |             <http://www.cs.utexas.edu>
# University of Texas at Austin   |                <http://www.utexas.edu>
# ========================================================================


class Code::Comment {

    inherit Code::Label

    constructor {args} {
	eval Label::constructor $args
    } {
	# Start out in edit mode.

	editmode
    }

    public method save {out} {
	CodeObj::save $out
	puts $out "\$obj dispmode"
    }
    

}
