#
# CreationParameterNode.tcl
# ------------------------------------------------------------------------
# The node which provides a local value to a subgraph, initialized when
# the subgraph is instantiated.
# ------------------------------------------------------------------------
# @(#) $Id: CreationParameterNode.tcl,v 1.6 1996/10/08 17:13:39 emery Exp $
#
# ------------------------------------------------------------------------
# AUTHOR:
#
# Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
# Systems Analyst                 @           <mailto:emery@cs.utexas.edu>
# Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
# Department of Computer Sciences |             <http://www.cs.utexas.edu>
# University of Texas at Austin   |                <http://www.utexas.edu>
# ========================================================================


class Code::CreationParameterNode {

    inherit Code::Node

    constructor {args} { 
	eval Code::Node::constructor $args
    } {}

    public method bitmap {}
    public method translate {ProgramAST GraphAST}
    public method thisimage {}

    common image

    public variable Type ""
    protected variable attributes {Name Type}

    set image(0) [uplevel #0 image create photo -palette 256x256x256 -format GIF -file "$c2_ReleaseDirectory/bitmaps/CreationParameterNode.gif"]
    set image(1) [uplevel #0 image create photo -palette 256x256x256 -format GIF -file "$c2_ReleaseDirectory/bitmaps/CreationParameterNode-Selected.gif"]

}


body Code::CreationParameterNode::constructor {args} {
    itk_initialize
}


body Code::CreationParameterNode::bitmap {} {
    return "@[$canvas info variable ReleaseDirectory -value]/bitmaps/CreationParameterNode.bit"
}


body Code::CreationParameterNode::thisimage {} {
    return $image($selected)
}


body Code::CreationParameterNode::translate {ProgramAST GraphAST} {
    return [c2_CreateCreationParameterNodeAST $ProgramAST $GraphAST $Name $id "$Type"]
}
