#
# InInterfaceNode.tcl
# ------------------------------------------------------------------------
# The node which provides input to a subgraph.
# ------------------------------------------------------------------------
# @(#) $Id: InInterfaceNode.tcl,v 1.6 1996/10/08 17:13:40 emery Exp $
#
# ------------------------------------------------------------------------
# AUTHOR:
#
# Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
# Systems Analyst                 @           <mailto:emery@cs.utexas.edu>
# Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
# Department of Computer Sciences |             <http://www.cs.utexas.edu>
# University of Texas at Austin   |                <http://www.utexas.edu>
# ========================================================================


class Code::InInterfaceNode {

    inherit Code::Node

    constructor {args} {
	eval Code::Node::constructor $args
    } {}

    public method bitmap {}
    public method translate {ProgramAST GraphAST}
    public method thisimage {}

    common image

    public variable Type ""
    protected variable attributes {Name Type}

    set image(0) [uplevel #0 image create photo -palette 256x256x256 -format GIF -file "$c2_ReleaseDirectory/bitmaps/InInterfaceNode.gif"]
    set image(1) [uplevel #0 image create photo -palette 256x256x256 -format GIF -file "$c2_ReleaseDirectory/bitmaps/InInterfaceNode-Selected.gif"]

}

body Code::InInterfaceNode::constructor {args} {
    addport OutputPort bottom 1
    itk_initialize
}

body Code::InInterfaceNode::bitmap {} {
    return "@[$canvas info variable ReleaseDirectory -value]/bitmaps/InInterfaceNode.bit"
}


body Code::InInterfaceNode::thisimage {} {
    return $image($selected)
}


body Code::InInterfaceNode::translate {ProgramAST GraphAST} {
    return [c2_CreateInInterfaceNodeAST $ProgramAST $GraphAST $Name $id "$Type"]
}

