#
# LabeledEntryEdit.tcl
# ------------------------------------------------------------------------
# A thin wrapper around LabeledEntry providing an "Edit" button to allow
# use of the user's habitual text editor.
# ------------------------------------------------------------------------
# @(#) $Id: LabeledEntryEdit.tcl,v 1.3 1996/01/09 18:32:47 emery Exp $
#
# ------------------------------------------------------------------------
# AUTHOR:
#
# Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
# Systems Analyst                 @           <mailto:emery@cs.utexas.edu>
# Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
# Department of Computer Sciences |             <http://www.cs.utexas.edu>
# University of Texas at Austin   |                <http://www.utexas.edu>
# ========================================================================


class LabeledEntryEdit {

    inherit LabeledEntry

    constructor {args} {
	eval LabeledEntry::constructor $args
    } {
	button [childsite].button -text "Edit" -command ""

	if {0} {
	    set oldval \
		"set label \[$this get label\] ; \
		set value \[$this get value\]  ; \
		set out \[open \"/tmp/$label\" w\] ; \
		puts \$out \$value ; close \$out ; \
		c2_EditFile \"/tmp/$label\" ; set in \[open \"/tmp/$label\"\] ; \
		$this configure -value \"\[read \$in\]\""
	}

	#pack forget $this.f.l
	#pack forget $this.f.e

	#pack $this.f.l $this.f.e -pady 2 -padx 2 -fill both -anchor w -expand yes -side left
	pack [childsite].button -side right -padx 2 -anchor e -fill x

	eval itk_initialize $args
    }

}
