#
# NameSharingNode.tcl
# ------------------------------------------------------------------------
# The shared variable node.
# ------------------------------------------------------------------------
# @(#) $Id: NameSharingNode.tcl,v 1.13 1997/06/16 21:14:13 emery Exp $
#
# ------------------------------------------------------------------------
# AUTHOR:
#
# Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
# Systems Analyst                 @           <mailto:emery@cs.utexas.edu>
# Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
# Department of Computer Sciences |             <http://www.cs.utexas.edu>
# University of Texas at Austin   |                <http://www.utexas.edu>
# ========================================================================


class Code::NameSharingNode {

    inherit Code::Node

    constructor {args} {
	eval Code::Node::constructor $args
    } {}

    public method attributes {{update 1}}
    public method bitmap {}
    public method translate {ProgramAST GraphAST}
    public method raise_culprit {line col}
    public method thisimage {}

    protected method draw_node {x y}


    common image
    global c2_ReleaseDirectory
    array set image [list 0 [uplevel #0 ::image create photo -palette 256x256x256 -format GIF -file "$c2_ReleaseDirectory/bitmaps/NameSharingNode.gif"] 1 [uplevel #0 ::image create photo -palette 256x256x256 -format GIF -file "$c2_ReleaseDirectory/bitmaps/NameSharingNode.gif"]]

    public variable SharedVars ""
    public variable LocalVars ""
    public variable InitComp ""
    public variable Docs ""
    
    protected variable attributes {Name Docs SharedVars LocalVars InitComp}
}

body Code::NameSharingNode::constructor {args} {
    addport InputPort top
    addport InputPort left
    addport InputPort right
    addport InputPort bottom
    itk_initialize
}


body Code::NameSharingNode::attributes {{update 1}} {
    Node::attributes $update
}


body Code::NameSharingNode::bitmap {} {
    return "@[$canvas info variable ReleaseDirectory -value]/bitmaps/NameSharingNode.bit"
}


body Code::NameSharingNode::draw_node {x y} {
    set node [$canvas create image $x $y \
	    -image [thisimage] \
	    -parent $this]
}


body Code::NameSharingNode::thisimage {} {
    return $image($selected)
}


# display the dialog and position the cursor
# at the given line and column (for debugging).

body Code::NameSharingNode::raise_culprit {line col} {
    # puts "line = $line, col = $col"
    set stanzas {SharedVars LocalVars InitComp}
    set names {shared_vars vars init_comp}

    for {set i 0} {$i < 3} {incr i} {
	set stanza_name([lindex $stanzas $i]) [lindex $names $i]
    }

    # Find out which stanza we should be in.
    set ln 0
    foreach s $stanzas {

	# puts "current ln = $ln, stanza = $s"

	# Find out how many lines are in this stanza.
	set val [set $s]
	set lines [expr 1+[regsub -all "\n" $val {} newval]]

	# puts "there are $lines in stanza $s."
	# If the culprit line is in this stanza, stop.
	if {$line <= [expr $ln + $lines]} {
	    set mystanza $s
	    if {$line == [expr $ln + 1]} {
		set col [expr $col - [string length $stanza_name($s)] - 2]
	    }
	    break
	}
	incr ln $lines
    }

    # Raise the appropriate notebook page(s) based on the stanza.

    set f ._NameSharingNodeattributes._Options
    switch $mystanza {
	SharedVars {
	    $f view "Shared Variables"
	    set textwin [$f childsite "Shared Variables"]._SharedVariables
	}
	LocalVars {
	    $f view "Local Variables"
	    set textwin [$f childsite "Local Variables"]._LocalVariables
	}
	InitComp {
	    $f view "Initial Computation"
	    set textwin [$f childsite "Initial Computation"]._InitComputation
	}
    }

    # puts "textwin = $textwin"
    set index "[expr $line - $ln].$col"

    # Make sure the text item has been initialized!
    update_attributes

    # Now put the cursor where it belongs and make it visible.
    $textwin mark set insert $index
    $textwin see $index
}


body Code::NameSharingNode::translate {ProgramAST GraphAST} {
    set Spec [format "shared_vars \{%s\}\nvars \{%s\}\ninit_comp \{%s\}" \
	    $SharedVars $LocalVars $InitComp]
    return [c2_CreateNameSharingNodeAST $ProgramAST $GraphAST $Name $id \
	    "$Spec" "$Docs"]
}
