#
# OutInterfaceNode.tcl
# ------------------------------------------------------------------------
# Provides output from a subgraph.
# ------------------------------------------------------------------------
# @(#) $Id: OutInterfaceNode.tcl,v 1.8 1996/10/08 17:13:50 emery Exp $
#
# ------------------------------------------------------------------------
# AUTHOR:
#
# Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
# Systems Analyst                 @           <mailto:emery@cs.utexas.edu>
# Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
# Department of Computer Sciences |             <http://www.cs.utexas.edu>
# University of Texas at Austin   |                <http://www.utexas.edu>
# ========================================================================


class Code::OutInterfaceNode {

    inherit Code::Node

    constructor {args} {
	eval Code::Node::constructor $args
    } {}

    public method bitmap {}
    public method translate {ProgramAST GraphAST}
    public method thisimage {}

    common image

    public variable Type ""
    protected variable attributes {Name Type}

    set image(0) [uplevel #0 image create photo -palette 256x256x256 -format GIF -file "$c2_ReleaseDirectory/bitmaps/OutInterfaceNode.gif"]
    set image(1) [uplevel #0 image create photo -palette 256x256x256 -format GIF -file "$c2_ReleaseDirectory/bitmaps/OutInterfaceNode-Selected.gif"]

}

body Code::OutInterfaceNode::constructor {args} {
    addport InputPort top 1
    itk_initialize
}

body Code::OutInterfaceNode::bitmap {} {
    return "@[$canvas info variable ReleaseDirectory -value]/bitmaps/OutInterfaceNode.bit"
}


body Code::OutInterfaceNode::thisimage {} {
    return $image($selected)
}


body Code::OutInterfaceNode::translate {ProgramAST GraphAST} {
    return [c2_CreateOutInterfaceNodeAST $ProgramAST $GraphAST $Name $id "$Type"]
}

