#
# OutputPort.tcl
# ------------------------------------------------------------------------
# The output port attached to a Node. (An arrow pointing away from the
# node.)
# ------------------------------------------------------------------------
# @(#) $Id: OutputPort.tcl,v 1.5 1996/04/19 00:45:23 emery Exp $
#
# ------------------------------------------------------------------------
# AUTHOR:
#
# Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
# Systems Analyst                 @           <mailto:emery@cs.utexas.edu>
# Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
# Department of Computer Sciences |             <http://www.cs.utexas.edu>
# University of Texas at Austin   |                <http://www.utexas.edu>
# ========================================================================


class Code::OutputPort {

    inherit Code::Port
    
    # WORKAROUND - constructor could have parm list of
    # just {args}, but needed full port version to be
    # able to extract x and y for below draw_port workaround.

    constructor {w dir node x y args} {
	if {!$_initialized} {
	    init
	}
	eval Code::Port::constructor $w $dir $node $x $y $args
    } {
	
	# WORKAROUND - this *should* be in Port.tcl constructor

	eval draw_port $x $y $args

	# bindings

	$canvas bind $this <Button-1> "if \{ \[$canvas tool\] == \"Select\" && \[$this accepts\]\} \{ $this create_arc \}"
	$canvas bind $this <Enter> "if \{ \[$canvas tool\] == \"Select\" && \[$this accepts\]\} \{ $this activate \}"
	$canvas bind $this <Leave> "if \{ \[$canvas tool\] == \"Select\" \} \{ $this deactivate \}"

	eval itk_initialize $args

    }

    public method create_arc {}
    public method draw_port {x y args}
    public method thisimage {}
    public method move {dx dy}

    protected common bitmapfile
    protected common image

    private method init {}
    private variable _initialized 0
}



body Code::OutputPort::create_arc {} {
    Code::CodeCanvas::set_tool Arc
    set arc [attach-arc [$canvas create Arc $this]]
    $canvas configure -currentDrawingArcItem $arc
    $this deactivate
    bind [info namespace tail $canvas] <Any-Motion> "$arc any_motion %x %y"
    return $arc
}


body Code::OutputPort::draw_port {x y args} {
    set port [eval $canvas create image $x $y\
	    -image [thisimage] \
	    -parent $this $args]
    $canvas addtag OutputPort withtag $port
    $canvas addtag $this withtag $port
    $this scale
}


body Code::OutputPort::init {} {
   
    global ::c2_ReleaseDirectory
    set rdir $c2_ReleaseDirectory

    set bitmapfile(0) "BottomOutputPort.gif"
    set bitmapfile(1) "BottomOutputPort-Selected.gif"
    
    set image(0) [uplevel #0 image create photo -palette 256x256x256 -format GIF -file $rdir/bitmaps/$bitmapfile(0)]

    set image(1) [uplevel #0 image create photo -palette 256x256x256 -format GIF -file $rdir/bitmaps/$bitmapfile(1)]

    set _initialized 1
}

body Code::OutputPort::move {dx dy} {
    Code::Port::move $dx $dy
    foreach arc $attached_arcs {
	$arc arc_move_startpoints_by $dx $dy
    }
}


body Code::OutputPort::thisimage {} {
    return $image($active)
}
