#
# Undo.tcl
# ------------------------------------------------------------------------
# A base class, inherited by CodeCanvas, providing one-level Undo. Every
# operation writes into a string the Tcl code to implement its "reverse".
# ------------------------------------------------------------------------
# @(#) $Id: Undo.tcl,v 1.3 1996/01/09 18:33:05 emery Exp $
#
# ------------------------------------------------------------------------
# AUTHOR:
#
# Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
# Systems Analyst                 @           <mailto:emery@cs.utexas.edu>
# Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
# Department of Computer Sciences |             <http://www.cs.utexas.edu>
# University of Texas at Austin   |                <http://www.utexas.edu>
# ========================================================================


class Code::Undo {

    constructor {} {}
    destructor {}

    public method undoable {} {}
    public method undo {} {}

    protected method paste {pasted} {}
    protected method cut {} {}
    protected method zoom_in {} {}
    protected method zoom_out {} {}
    protected method move_selected_by {dx dy} {}
    protected method delete_selected {} {}
    protected method ungroup {} {}
    protected method group {} {}
    protected method lock {} {}
    protected method unlock {} {}
    protected method not_undoable {} {}

    protected variable undo ""
}


body Code::Undo::undoable {} {
    return [string compare $undo ""]
}

body Code::Undo::undo {} {
    set undo_command $undo
    set undo ""
    eval $undo_command
}

body Code::Undo::paste {pasted} {
    set undo "map {delete object} $pasted"
}

body Code::Undo::cut {} {
    global ::c2_CutBuffer
    set undo "[source $c2_CutBuffer] ; c2_restore"
}

body Code::Undo::zoom_in {} {
    set undo "zoom_out"
}

body Code::Undo::zoom_out {} {
    set undo "zoom_in"
}

body Code::Undo::move_selected_by {dx dy} {
    set undo "move_selected_by [expr -($dx)] [expr -($dy)]"
}

body Code::Undo::delete_selected {} {
    global ::c2_UndoBuffer
    set undo "[source $c2_UndoBuffer] ; c2_restore"
}

body Code::Undo::ungroup {} {
    set undo "group_selected"
}

body Code::Undo::group {} {
    set undo "ungroup"
}

body Code::Undo::lock {} {
    set undo "unlock"
}

body Code::Undo::unlock {} {
    set undo "lock"
}


body Code::Undo::not_undoable {} {
    set undo ""
}

