#
# createDialogs.tcl
# ------------------------------------------------------------------------
# When "sourced", creates all of the dialog windows used by CODE.
# ------------------------------------------------------------------------
# @(#) $Id: createDialogs.tcl,v 1.36 1998/11/25 06:17:31 emery Exp $
#
# ------------------------------------------------------------------------
# AUTHOR:
#
# Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
# Systems Analyst                 @           <mailto:emery@cs.utexas.edu>
# Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
# Department of Computer Sciences |             <http://www.cs.utexas.edu>
# University of Texas at Austin   |                <http://www.utexas.edu>
# ========================================================================


global c2_tmp c2_MonoFont c2_FileDialog

set c2_FileDialog [iwidgets::Fileselectiondialog .filedialog -modality application]

# these variables MUST be initialized to some value before
# they are used as a -variable argument (since that invokes
# a trace) in Scrolledtext.

set c2_tmp(Name) ""
set c2_tmp(Type) ""
set c2_tmp(text) ""
set c2_tmp(TraceCall) ""
set c2_tmp(GraphFunctionSignatures) ""
set c2_tmp(GraphFunctionDefinitions) ""
set c2_tmp(GraphDocumentation) ""
set c2_tmp(c2_PrintToPrinter) 0
set c2_tmp(c2_PVMHosts) ""
set c2_tmp(c2_GlobalTypes) ""
set c2_tmp(c2_GlobalFunctionSignatures) ""
set c2_tmp(c2_GlobalFunctionDefinitions) ""
set c2_tmp(c2_GlobalDocumentation) ""
set c2_tmp(c2_FilesToLink) ""
set c2_tmp(annotation) ""
set c2_tmp(Documentation) ""
set c2_tmp(Specification) ""
set c2_tmp(InitComputation) ""
set c2_tmp(Computation) ""
set c2_tmp(LocalVariables) ""
set c2_tmp(StaticVariables) ""
set c2_tmp(SharedVariables) ""
set c2_tmp(FiringRules) ""
set c2_tmp(InputPorts) ""
set c2_tmp(RoutingRules) ""
set c2_tmp(OutputPorts) ""
set c2_tmp(Docs) ""
set c2_tmp(SharedVars) ""
set c2_tmp(LocalVars) ""
set c2_tmp(InitComp) ""


# CallNode Annotations

Code::Dialog ._CallNodeattributes -title "CODE: Call Node Annotations"
._CallNodeattributes addbutton _OK "OK" "._CallNodeattributes okcmd"
._CallNodeattributes addbutton _Cancel "Cancel" "._CallNodeattributes cancelcmd"
._CallNodeattributes defaultbutton _OK


set attrframe ._CallNodeattributes

set f [frame $attrframe._NameFrame]
pack $f -side top -fill both -expand yes
LabeledEntry $f._Name -label "Name:" -text c2_tmp(Name) -validate "c_identifier {%P}"
pack $f._Name -side top

set c2_tmp(IsAliasToGraph) 0
set c2_tmp(AliasGraphName) ""
set c2_tmp(AliasGraph) ""

trace variable c2_tmp(IsAliasToGraph) w c2_update_callnode_dlog

proc c2_update_callnode_dlog {n e op} {
    global c2_tmp

    if {$c2_tmp(IsAliasToGraph)} {
	if [string compare $c2_tmp(AliasGraph) ""] {
	    set c2_tmp(AliasGraphName) [$c2_tmp(AliasGraph) info variable Name -value]
	} else {
	    set c2_tmp(AliasGraphName) ""
	}
    } else {
	set c2_tmp(AliasGraphName) ""
    }

}

checkbutton $attrframe.isalias -relief flat -text "Alias to another container" -variable c2_tmp(IsAliasToGraph) \
    -command {
	if {$c2_tmp(IsAliasToGraph)} {
	    if [c2_HierarchySelect alias .hierarchy c2_tmp(AliasGraph)] {
		set c2_tmp(AliasGraphName) [$c2_tmp(AliasGraph) info variable Name -value]
	    }
	}
    }


label $attrframe.aliasname -textvariable c2_tmp(AliasGraphName)

# checkbutton $attrframe.trace -relief flat -text "Trace this node" -variable c2_tmp(TraceCall)

# Code::Myscrolledtext $attrframe._GraphDocumentation -labeltext "Documentation:" -variable "c2_tmp(GraphDocumentation)" -visibleitems 40x4 -textfont $c2_MonoFont

# $attrframe._NameFrame {top frame center expand fill}

pack append $attrframe \
    $attrframe.isalias {top frame center expand} \
    $attrframe.aliasname {top frame center expand}

#    $attrframe._GraphDocumentation {top frame center expand fill}

#     $attrframe.trace {top frame center expand}

#############################
#                           #
# set up all dialog windows #
#                           #


# about CODE

Code::Dialog .aboutdialog -title "CODE: About CODE"
.aboutdialog addbutton _OK "OK" ".aboutdialog okcmd"
.aboutdialog defaultbutton _OK

set f [.aboutdialog subwidget frame]

set splash [image create photo -palette 256x256x256 -format GIF -file "$c2_ReleaseDirectory/bitmaps/code-screen-logo.gif"]

label $f.splash -image $splash -borderwidth 0
pack $f.splash -expand yes -fill both -anchor n

set version "2.2b1"
message $f.subtitle -width 10c -justify center \
    -font {-adobe-new century schoolbook-bold-i-normal-*-14-140-75-75-p-88-iso8859-1} \
    -text "version $version"
pack $f.subtitle -side top -anchor center

message $f.msg -width 10c -text "by Emery Berger, Peter Newton, and Brian West.
Concept: Professor J.C. Browne" \
    -font {-adobe-new century schoolbook-medium-r-normal-*-14-140-75-75-p-82-iso8859-1}

message $f.http -width 10c -text "http://www.cs.utexas.edu/users/code" \
    -font -adobe-courier-medium-r-normal-*-14-140-75-75-m-90-iso8859-1 \
    -justify center

message $f.copyright -width 10c -text "Copyright \251 1998 The University of Texas at Austin" \
    -font -adobe-times-medium-i-normal-*-14-140-75-75-p-73-iso8859-1 \
    -justify center

message $f.disclaimer -width 10c -text "See LICENSE for licensing information." \
    -font 6x10 -justify center

pack $f.copyright -pady 10 -anchor center
pack $f.msg -anchor center
pack $f.http -pady 5 -anchor center
pack $f.disclaimer -pady 2 -anchor center

# FAQ dialog

global env

Code::Dialog .faqdialog -title "CODE: Frequently Asked Questions"
.faqdialog addbutton _OK "OK" ".faqdialog okcmd"
.faqdialog defaultbutton _OK

proc follow {link} {
    set htmlwindow [.faqdialog subwidget frame].html
    if [regexp {.*:.*} $link dummy] {
	return
    }
    if ![regexp {(.*)#(.*)} $link dummy filepart anchorpart] {
	set filepart $link
	set anchorpart {}
    }
    if {$filepart != "" && [file pathtype $filepart] == "relative"} {
	set filepart [file join [$htmlwindow pwd] $filepart]
	$htmlwindow import -link $filepart#$anchorpart
    } else {
	if {$filepart == ""} {
	    $htmlwindow import -link #$anchorpart
	}
    }
}

set f [.faqdialog subwidget frame]
iwidgets::scrolledhtml $f.html -linkcommand follow
pack $f.html
set txtfile [open [file join $env(CODE_LIBRARY) ui FAQ.html]]
set txt [read $txtfile]
$f.html render $txt err


# error

Code::Dialog .error -title "CODE: Error"
.error addbutton _OK "OK" ".error okcmd"
.error defaultbutton _OK
label .error.label -text "error message" -height 3
pack .error.label -anchor c -expand yes -fill both


# new file


Code::Dialog .newdialog -title "CODE: New File"
.newdialog addbutton _OK "OK" ".newdialog okcmd"
.newdialog addbutton _Cancel "Cancel" ".newdialog cancelcmd"
.newdialog defaultbutton _Cancel

label .newdialog.image -bitmap question
label .newdialog.label -text "Are you sure? (This will erase any unsaved work.)" -height 3

pack .newdialog.image -side left -anchor w -expand yes -fill both -padx 10
pack .newdialog.label -anchor c -expand yes -fill both



# quit

Code::Dialog .quitdialog -title "CODE: Quit Code"
.quitdialog addbutton _OK "OK" ".quitdialog okcmd"
.quitdialog addbutton _Cancel "Cancel" ".quitdialog cancelcmd"
.quitdialog defaultbutton _Cancel
label [.quitdialog subwidget frame].image -bitmap question
label [.quitdialog subwidget frame].label -text "Are you sure you want to quit?" -height 3

pack [.quitdialog subwidget frame].image -side left -anchor w -expand yes -fill both -padx 10
pack [.quitdialog subwidget frame].label -anchor c -expand yes -fill both

# successful save.

Code::Dialog .savedfiledialog -title "CODE: File Saved"
.savedfiledialog addbutton _OK "OK" ".savedfiledialog okcmd"
.savedfiledialog defaultbutton _OK

label .savedfiledialog.image -bitmap info
label .savedfiledialog.label -text "File saved." -height 3

pack .savedfiledialog.image -side left -anchor w -expand yes -fill both -padx 10
pack .savedfiledialog.label -anchor c -expand yes -fill both


# failed compilation.

Code::Dialog .badcompiledialog -title "CODE: Compilation Error"
.badcompiledialog addbutton _OK "OK" ".badcompiledialog okcmd"
.badcompiledialog defaultbutton _OK

label .badcompiledialog.image -bitmap error
label .badcompiledialog.label -text "Compilation unsuccessful." -height 3

pack .badcompiledialog.image -side left -anchor w -expand yes -fill both -padx 10
pack .badcompiledialog.label -anchor c -expand yes -fill both


# successful compilation.

Code::Dialog .goodcompiledialog -title "CODE: Compilation Successful"
.goodcompiledialog addbutton _OK "OK" ".goodcompiledialog okcmd"
.goodcompiledialog defaultbutton _OK

label .goodcompiledialog.image -bitmap info
label .goodcompiledialog.label -text "Compilation successful." -height 3

pack .goodcompiledialog.image -side left -anchor w -expand yes -fill both -padx 10
pack .goodcompiledialog.label -anchor c -expand yes -fill both


# not-implemented-yet

Code::Dialog .not_implemented_yet -title "CODE: Unimplemented Feature"
.not_implemented_yet addbutton _OK "OK" ".not_implemented_yet okcmd"
.not_implemented_yet addbutton _Cancel "Cancel" ".not_implemented_yet cancelcmd"
.not_implemented_yet defaultbutton _OK

pack [label .not_implemented_yet.label -text "Sorry, this feature is not yet available."] -expand yes -fill both


# print

Code::Dialog .printdialog -title "CODE: Printer Setup"
.printdialog addbutton _OK "OK" ".printdialog okcmd"
.printdialog addbutton _Cancel "Cancel" ".printdialog cancelcmd"
.printdialog defaultbutton _OK

set printframe .printdialog

if 0 {
    optionmenu $printframe.printer \
	-labeltext "Choose printer:" -command "set c2_tmp(c2_PrinterName)" \
	-labelpos w -width 5
    
    pack $printframe.printer -side top -fill x -anchor w
    
    foreach printer [printers] {
	$printframe.printer insert end $printer $printer
    }
    
    global c2_PrinterName
    if { ![string compare $c2_PrinterName ""] } {
	set c2_PrinterName [lindex $printers 0]
    }
    
    $printframe.printer select "$c2_PrinterName"
}


frame $printframe.printto
pack $printframe.printto -side top -fill x

label $printframe.printto.dest -text "Print To:" -width 15

radiobutton $printframe.printto.printer -text "Printer" -variable c2_tmp(c2_PrintToPrinter) -value 1 -width 15
radiobutton $printframe.printto.file -text "File" -variable c2_tmp(c2_PrintToPrinter) -value 0 -width 15

trace variable c2_tmp(c2_PrintToPrinter) rw c2_update_print_dlog

proc c2_update_print_dlog {n e op} {
    global c2_tmp
    
    .printdialog.command configure -state [lindex {{disabled} {normal}} $c2_tmp(c2_PrintToPrinter)]
    .printdialog.filename configure -state [lindex {{disabled} {normal}} [expr !($c2_tmp(c2_PrintToPrinter))]]
}

pack $printframe.printto.dest $printframe.printto.printer $printframe.printto.file -in $printframe.printto -side left -fill x -expand yes

LabeledEntry $printframe.command -label "Print Command:" -text c2_tmp(c2_PrintCommand)
pack $printframe.command -side top -fill x -expand yes

LabeledEntry $printframe.filename -label "File Name:" -text c2_tmp(c2_PrintFilename)
pack $printframe.filename -side top -fill x -expand yes

iwidgets::labeledwidget $printframe._PageOptions -labeltext ""
pack $printframe._PageOptions -side top -anchor w -expand yes -fill x
set f [$printframe._PageOptions childsite]

if 0 {

frame $f._PrintOrder
pack $f._PrintOrder -side top -fill x

label $f._PrintOrder._Label -text "Print Order:" -width 15
radiobutton $f._PrintOrder._First -text "First Page First" -variable c2_tmp(c2_PrintFirstPageFirst) -value 1 -width 15
radiobutton $f._PrintOrder._Last  -text "Last Page First" -variable c2_tmp(c2_PrintFirstPageFirst) -value 0 -width 15

pack $f._PrintOrder._Label $f._PrintOrder._First $f._PrintOrder._Last -side left -fill x -expand yes
}

frame $f._PrintOrientation
pack $f._PrintOrientation -side top -fill x

label $f._PrintOrientation._Label -text "Orientation:" -width 15
radiobutton $f._PrintOrientation._Portrait -text "Portrait" -variable c2_tmp(c2_PrintPortraitMode) -value 1 -width 15
radiobutton $f._PrintOrientation._Landscape  -text "Landscape" -variable c2_tmp(c2_PrintPortraitMode) -value 0 -width 15

pack $f._PrintOrientation._Label $f._PrintOrientation._Portrait $f._PrintOrientation._Landscape -side left -fill x -expand yes


frame $f._PrintColor
pack $f._PrintColor -side top -fill both

label $f._PrintColor._Label -text "Print:" -width 15
radiobutton $f._PrintColor._Greyscale -text "Greyscale" -variable c2_tmp(c2_PrintGreyscale) -value 1 -width 15
radiobutton $f._PrintColor._Color  -text "Color" -variable c2_tmp(c2_PrintGreyscale) -value 0 -width 15

pack $f._PrintColor._Label $f._PrintColor._Greyscale $f._PrintColor._Color -side left -fill x -expand yes -anchor w

if 0 {

frame $f._PrintSize1
pack $f._PrintSize1 -side top -fill both
frame $f._PrintSize2
pack $f._PrintSize2 -side top -fill both
frame $f._PrintSize3
pack $f._PrintSize3 -side top -fill both

label $f._PrintSize1._Label -text "Paper Size:" -width 15
radiobutton $f._PrintSize1._Letter -text "Letter" -variable c2_tmp(c2_PrintPaperSize) -value 0 -width 15
radiobutton $f._PrintSize1._Legal  -text "Legal" -variable c2_tmp(c2_PrintPaperSize) -value 1 -width 15

pack $f._PrintSize1._Label $f._PrintSize1._Letter $f._PrintSize1._Legal -side left -fill x -expand yes -anchor w

label $f._PrintSize2._Empty -text "" -width 15
radiobutton $f._PrintSize2._Executive -text "Executive" -variable c2_tmp(c2_PrintPaperSize) -value 2 -width 15
radiobutton $f._PrintSize2._A4  -text "A4" -variable c2_tmp(c2_PrintPaperSize) -value 3 -width 15

pack $f._PrintSize2._Empty $f._PrintSize2._Executive $f._PrintSize2._A4 -side left -fill x -expand yes -anchor w
}


# machine setup

Code::Dialog ._MachineSetup -title "CODE: Execution Setup"
._MachineSetup addbutton _OK "OK" "._MachineSetup okcmd"
._MachineSetup addbutton _Cancel "Cancel" "._MachineSetup cancelcmd"
._MachineSetup defaultbutton _OK

set attrframe ._MachineSetup

set f [frame $attrframe._NPFrame]
pack $f -side top -fill x

iwidgets::labeledwidget $f._CompilerOptions -labeltext "Compiler Options"
pack $f._CompilerOptions -padx 5 -side left -anchor center -fill y -expand yes
set g [$f._CompilerOptions childsite]

checkbutton $g._OptimizeProgram -text "Optimize Program" -variable c2_tmp(c2_OptimizeProgram) -command { if $c2_tmp(c2_OptimizeProgram) { set c2_tmp(c2_DebuggerOn) 0 } }
checkbutton $g._DebuggerOn -text "Use Debugger" -variable c2_tmp(c2_DebuggerOn) -command { if $c2_tmp(c2_DebuggerOn) { set c2_tmp(c2_OptimizeProgram) 0 }}

pack $g._OptimizeProgram $g._DebuggerOn -side top -fill both -padx 5 -anchor w -expand yes


iwidgets::labeledwidget $f._TranslationTarget -labeltext "Target architecture"
pack $f._TranslationTarget -padx 5 -side right -anchor center -fill y -expand yes

set g [$f._TranslationTarget childsite]
radiobutton $g._Cray -text "Cray" -value {Cray} -variable c2_tmp(c2_TranslationTarget)
radiobutton $g._PVM -text "PVM" -value {PVM} -variable c2_tmp(c2_TranslationTarget)
radiobutton $g._Sequent -text "Sequent" -value {Sequent} -variable c2_tmp(c2_TranslationTarget)
radiobutton $g._Sparc -text "Sparc MP" -value {Sparc} -variable c2_tmp(c2_TranslationTarget)
radiobutton $g._Serial -text "Serial" -value {Serial} -variable c2_tmp(c2_TranslationTarget)

pack  $g._Cray $g._PVM $g._Sequent $g._Sparc $g._Serial -side top -fill both -anchor w -padx 5 -expand yes


# global Annotations

Code::Dialog ._Globalattributes -title "CODE: Program Annotations"
._Globalattributes addbutton _OK "OK" "._Globalattributes okcmd"
._Globalattributes addbutton _Cancel "Cancel" "._Globalattributes cancelcmd"
._Globalattributes defaultbutton _OK

set attrframe ._Globalattributes
iwidgets::tabnotebook $attrframe._Options -width 400 -height 300 -equaltabs n -tabpos n
$attrframe._Options add -label "Types"
$attrframe._Options add -label "Signatures"
$attrframe._Options add -label "Definitions"
# $attrframe._Options add -label "Documentation"
$attrframe._Options add -label "Link"
$attrframe._Options select 0

pack $attrframe._Options -side top -expand yes -fill both -padx 10 -pady 10

if 0 {
Code::Myscrolledtext $attrframe._GlobalTypes -labeltext "Types:" -height 4 -width 40
}

set f [$attrframe._Options childsite "Signatures"]
Code::Myscrolledtext $f._GlobalFunctionSignatures \
	-labeltext "Function signatures:" \
	-variable "c2_tmp(c2_GlobalFunctionSignatures)" \
	-visibleitems 40x8 -textfont $c2_MonoFont
pack append $f \
	$f._GlobalFunctionSignatures {top frame center expand fill}

set f [$attrframe._Options childsite "Definitions"]
Code::Myscrolledtext $f._GlobalFunctionDefinitions \
	-labeltext "Function definitions:" \
	-variable "c2_tmp(c2_GlobalFunctionDefinitions)" \
	-visibleitems 40x8 -textfont $c2_MonoFont
pack append $f \
	$f._GlobalFunctionDefinitions {top frame center expand fill}

set f [$attrframe._Options childsite "Types"]
Code::Myscrolledtext $f._GlobalTypes \
	 -labeltext "Types:" \
         -visibleitems 40x8  -textfont $c2_MonoFont \
	 -variable "c2_tmp(c2_GlobalTypes)"
pack append $f \
	$f._GlobalTypes {top frame center expand fill}

if 0 {
set f [$attrframe._Options childsite "Documentation"]
Code::Myscrolledtext $f._GlobalDocumentation \
	-labeltext "Documentation:" \
	-variable "c2_tmp(c2_GlobalDocumentation)" \
	-visibleitems 40x8 -textfont $c2_MonoFont
pack append $f \
	$f._GlobalDocumentation {top frame center expand fill}
}

set f [$attrframe._Options childsite "Link"]
Code::Myscrolledtext $f._FilesToLink \
	-labeltext "Object files to link:" \
	-variable "c2_tmp(c2_FilesToLink)" \
	-visibleitems 40x8 -textfont $c2_MonoFont
pack append $f \
	$f._FilesToLink {top frame center expand fill}


####################


# arc Annotations (this one is huge)

Code::Dialog ._Arcattributes -title "CODE: Arc Annotations"
._Arcattributes addbutton _OK "OK" "._Arcattributes okcmd"
._Arcattributes addbutton _Cancel "Cancel" "._Arcattributes cancelcmd"
._Arcattributes defaultbutton _OK

set attrframe ._Arcattributes
frame $attrframe.topframe
frame $attrframe.bottomframe
pack $attrframe.topframe -side top -fill both -expand yes
pack $attrframe.bottomframe -side top -expand yes -pady 5 -padx 5

frame $attrframe.topframe.left
pack $attrframe.topframe.left -side left -fill x -expand yes

frame $attrframe.topframe.right
pack $attrframe.topframe.right -side right -fill x -expand yes

foreach i {left right} {
    frame $attrframe.topframe.$i.top
    frame $attrframe.topframe.$i.middle
    frame $attrframe.topframe.$i.bottom
    
    pack $attrframe.topframe.$i.top $attrframe.topframe.$i.middle $attrframe.topframe.$i.bottom -side top -fill x -expand yes

    #
    #  Display the appropriate message above the pane.
    #
    
    label $attrframe.topframe.$i.top.title -text "" -font "-adobe-times-medium-i-normal--18-*-*"
    pack $attrframe.topframe.$i.top.title -side top -anchor w -fill x -expand yes -padx 10

    #
    #  Display the icon and name of the node.
    #

    frame $attrframe.topframe.$i.top.node
    pack $attrframe.topframe.$i.top.node -side top -pady 10 -padx 10 -fill both -expand yes
    
    label $attrframe.topframe.$i.top.node.icon
    label $attrframe.topframe.$i.top.node.label
    pack $attrframe.topframe.$i.top.node.icon $attrframe.topframe.$i.top.node.label -side left -anchor w


    #
    #  Set up the list of ports.
    #

    iwidgets::scrolledlistbox $attrframe.topframe.$i.middle.ports -hscrollmode dynamic
    #[$attrframe.topframe.$i.middle.ports subwidget hlist] configure -selectmode browse
    pack $attrframe.topframe.$i.middle.ports -expand yes -fill both -padx 10 -pady 10
    

    #
    #  Create the index entry forms.
    #

    LabeledEntry $attrframe.topframe.$i.bottom.callindex -label "Call index:" -text c2_tmp(${i}callindex) ;# -validate "index_expression \[massage \{%P\}]"

    LabeledEntry $attrframe.topframe.$i.bottom.nodeindex -label "Node index:" -text c2_tmp(${i}nodeindex) ;# -validate "index_expression \[massage \{%P\}]"

    LabeledEntry $attrframe.topframe.$i.bottom.portindex -label "Port index:" -text c2_tmp(${i}portindex) ;# -validate "index_expression \[massage \{%P\}]"

    pack $attrframe.topframe.$i.bottom.callindex $attrframe.topframe.$i.bottom.nodeindex $attrframe.topframe.$i.bottom.portindex  -side top -anchor w -padx 5 -expand yes -fill x

}


#
#  The updated arc annotation text
#

label $attrframe.bottomframe.arc_anno_title -text "Current Arc Annotation Expression" \
    -font "-adobe-helvetica-bold-o-normal--14-*-*"
pack $attrframe.bottomframe.arc_anno_title -side top -expand yes -pady 10 -padx 5

frame $attrframe.bottomframe.annoframe -borderwidth 2 -relief ridge
pack $attrframe.bottomframe.annoframe

label $attrframe.bottomframe.annoframe.arc_annotation -textvariable {c2_tmp(annotation)} \
    -font "-adobe-helvetica-bold-o-normal--14-*-*"
pack $attrframe.bottomframe.annoframe.arc_annotation -side top -expand yes -pady 5 -padx 10


#######################


# Comment Annotations

Code::Dialog ._Commentattributes -title "CODE: Text"
._Commentattributes addbutton _OK "OK" "._Commentattributes okcmd"
._Commentattributes addbutton _Cancel "Cancel" "._Commentattributes cancelcmd"
._Commentattributes defaultbutton _OK

set attrframe ._Commentattributes
LabeledEntry $attrframe.name -label "Text:" -text c2_tmp(text)
pack append $attrframe \
	$attrframe.name {top frame center expand fill}

# Label Annotations

Code::Dialog ._Labelattributes -title "CODE: Text"
._Labelattributes addbutton _OK "OK" "._Labelattributes okcmd"
._Labelattributes addbutton _Cancel "Cancel" "._Labelattributes cancelcmd"
._Labelattributes defaultbutton _OK

set attrframe ._Labelattributes
LabeledEntry $attrframe.name -label "Text:" -text c2_tmp(text)
pack append $attrframe \
	$attrframe.name {top frame center expand fill}


# InInterfaceNode Annotations

Code::Dialog ._InInterfaceNodeattributes -title "CODE: In Interface Node Annotations"
._InInterfaceNodeattributes addbutton _OK "OK" "._InInterfaceNodeattributes okcmd"
._InInterfaceNodeattributes addbutton _Cancel "Cancel" "._InInterfaceNodeattributes cancelcmd"
._InInterfaceNodeattributes defaultbutton _OK

set attrframe ._InInterfaceNodeattributes
LabeledEntry $attrframe.name -label "Name:" -text c2_tmp(Name) -validate "c_identifier {%P}"
LabeledEntry $attrframe.type -label "Type:" -text c2_tmp(Type) -validate "c_identifier {%P}"
pack append $attrframe \
	$attrframe.name {top frame center expand fill} \
	$attrframe.type {top frame center expand fill}

# OutInterfaceNode Annotations

Code::Dialog ._OutInterfaceNodeattributes -title "CODE: Out Interface Node Annotations"
._OutInterfaceNodeattributes addbutton _OK "OK" "._OutInterfaceNodeattributes okcmd"
._OutInterfaceNodeattributes addbutton _Cancel "Cancel" "._OutInterfaceNodeattributes cancelcmd"
._OutInterfaceNodeattributes defaultbutton _OK

set attrframe ._OutInterfaceNodeattributes
LabeledEntry $attrframe.name -label "Name:" -text c2_tmp(Name) -validate "c_identifier {%P}"
LabeledEntry $attrframe.type -label "Type:" -text c2_tmp(Type) -validate "c_identifier {%P}"
pack append $attrframe \
	$attrframe.name {top frame center expand fill} \
	$attrframe.type {top frame center expand fill}

# CreationParameterNode Annotations

Code::Dialog ._CreationParameterNodeattributes \
	-title "CODE: Creation Parameter Node Annotations"
._CreationParameterNodeattributes addbutton _OK "OK" "._CreationParameterNodeattributes okcmd"
._CreationParameterNodeattributes addbutton _Cancel "Cancel" "._CreationParameterNodeattributes cancelcmd"
._CreationParameterNodeattributes defaultbutton _OK

set attrframe ._CreationParameterNodeattributes
LabeledEntry $attrframe.name -label "Name:" -text c2_tmp(Name) -validate "c_identifier {%P}"
LabeledEntry $attrframe.type -label "Type:" -text c2_tmp(Type) -validate "c_identifier {%P}"
pack append $attrframe \
	$attrframe.name {top frame center expand fill} \
	$attrframe.type {top frame center expand fill}

# CompNode Annotations

Code::Dialog ._CompNodeattributes -title "CODE: Computation Node Annotations"
._CompNodeattributes addbutton _OK "OK" "._CompNodeattributes okcmd"
._CompNodeattributes addbutton _Cancel "Cancel" "._CompNodeattributes cancelcmd"
._CompNodeattributes defaultbutton _OK

set attrframe ._CompNodeattributes

set f [frame $attrframe._NameFrame]
pack $f -side top -fill x -expand no
LabeledEntry $f._Name -label "Name:" -text c2_tmp(Name) -validate "c_identifier {%P}"
pack $f._Name -side top -expand no

set f [frame $attrframe._NodeStatus]
pack $f -side top -fill x -expand no -pady 5

# Start node => not Stop node and not Static
# Stop node  => not Start node and not Static

set c2_tmp(IsStartNode) 0
set c2_tmp(IsTerminationNode) 0
# set c2_tmp(IsStatic) 0

checkbutton $f._IsStartNode -text "Start Node" -variable c2_tmp(IsStartNode) -command {if $c2_tmp(IsStartNode) { set c2_tmp(IsTerminationNode) 0 }}
checkbutton $f._IsTerminationNode -text "Stop Node" -variable c2_tmp(IsTerminationNode) -command {if $c2_tmp(IsTerminationNode) { set c2_tmp(IsStartNode) 0 }}
pack $f._IsStartNode -side left -padx 5 -expand yes
pack $f._IsTerminationNode -side right -padx 5 -expand yes

# IsStatic can only be activated if not IsStartNode and not IsStopNode.
# checkbutton $f._IsStatic -text "Preserve Node State" -variable c2_tmp(IsStatic) -command {if {$c2_tmp(IsStartNode) || $c2_tmp(IsTerminationNode)} { set c2_tmp(IsStatic) 0 }}
# pack $f._IsStatic -side bottom -pady 5 -expand yes

# pack $f._IsStartNode $f._IsTerminationNode -side top -padx 5 -expand yes

iwidgets::tabnotebook $attrframe._Computation -width 400 -height 300 -equaltabs n -tabpos n
$attrframe._Computation add -label "Computation"
$attrframe._Computation add -label "Variables"
$attrframe._Computation add -label "I/O"
# $attrframe._Computation add -label "Documentation"
# $attrframe._Computation add -label "Tracing"
$attrframe._Computation select 0

# $attrframe._Computation subwidget nbframe configure -backpagecolor gray
pack $attrframe._Computation -side top -expand yes -fill both -padx 10 -pady 10

#set f [$attrframe._Computation childsite 0]
set f [$attrframe._Computation childsite "Computation"]

Code::Myscrolledtext $f._InitComputation -labeltext "Initial Computation:" \
    -variable "c2_tmp(InitComputation)" -visibleitems 40x4  -textfont $c2_MonoFont
Code::Myscrolledtext $f._Computation -labeltext "Every Computation:" \
    -variable "c2_tmp(Computation)" -visibleitems 40x4  -textfont $c2_MonoFont

pack append $f \
    $f._InitComputation {top frame center expand fill} \
    $f._Computation {top frame center expand fill}

set f [$attrframe._Computation childsite "Variables"]

Code::Myscrolledtext $f._LocalVariables -labeltext "Automatic Variables:" \
    -variable "c2_tmp(LocalVariables)" -visibleitems 40x3  -textfont $c2_MonoFont
Code::Myscrolledtext $f._StaticVariables -labeltext "Static Variables:" \
    -variable "c2_tmp(StaticVariables)" -visibleitems 40x3  -textfont $c2_MonoFont
Code::Myscrolledtext $f._SharedVariables -labeltext "Shared Variables:" \
    -variable "c2_tmp(SharedVariables)" -visibleitems 40x2  -textfont $c2_MonoFont

pack append $f \
    $f._LocalVariables {top frame center expand fill} \
    $f._StaticVariables {top frame center expand fill} \
    $f._SharedVariables {top frame center expand fill}


set f [$attrframe._Computation childsite "I/O"]

iwidgets::tabnotebook $f._IO -equaltabs n -tabpos n
$f._IO add -label "Input"
$f._IO add -label "Output"
$f._IO select 0

pack $f._IO -side top -padx 10 -pady 10 -expand yes -fill both


set g [$f._IO childsite "Input"]

Code::Myscrolledtext $g._FiringRules -labeltext "Firing Rules:" \
    -variable "c2_tmp(FiringRules)" -visibleitems 40x4  -textfont $c2_MonoFont

Code::Myscrolledtext $g._InputPorts -labeltext "Input Ports:" \
    -variable "c2_tmp(InputPorts)" -visibleitems 40x4  -textfont $c2_MonoFont
pack $g._InputPorts $g._FiringRules -side top -fill both -expand yes


set g [$f._IO childsite "Output"]

Code::Myscrolledtext $g._RoutingRules -labeltext "Routing Rules:" \
    -variable "c2_tmp(RoutingRules)" -visibleitems 40x4  -textfont $c2_MonoFont

Code::Myscrolledtext $g._OutputPorts -labeltext "Output Ports:" \
    -variable "c2_tmp(OutputPorts)" -visibleitems 40x4  -textfont $c2_MonoFont
pack $g._OutputPorts $g._RoutingRules -side top -fill both -expand yes


if 0 {
set f [$attrframe._Computation childsite "Documentation"]
Code::Myscrolledtext $f._Documentation -labeltext "Documentation:" \
    -variable "c2_tmp(Documentation)" -visibleitems 40x8 -textfont $c2_MonoFont
pack append $f \
    $f._Documentation {top frame center expand fill}
}


# disable tracing options for now.

if 0 {

    set f [$attrframe._Computation subwidget _Tracing]

iwidgets::labeledwidget $f._MainOptions -labeltext ""
pack $f._MainOptions -padx 5 -side top
set g [$f._MainOptions childsite]

checkbutton $g._TraceEnable -text "Enable tracing" -variable c2_tmp(TraceEnable)
checkbutton $g._IsBreakPoint -text "Make this a breakpoint" -variable c2_tmp(IsBreakPoint)
checkbutton $g._TracePointBeforeNode -text "Trace point before node" -variable c2_tmp(TracePointBeforeNode)
pack $g._TraceEnable $g._IsBreakPoint $g._TracePointBeforeNode -side top -anchor w -padx 5


iwidgets::labeledwidget $f._OtherOptions -labeltext ""
pack $f._OtherOptions -padx 5 -side top -anchor center
set g [$f._OtherOptions childsite]
LabeledEntry $g._TraceWhen -label "Trace when?" -text c2_tmp(TraceWhen)
LabeledEntry $g._TraceFrequency -label "Trace frequency:" -text c2_tmp(TraceFrequency)
LabeledEntry $g._VariablesToTrace -label "Variables to trace:" -text c2_tmp(VariablesToTrace) -width 20
pack $g._TraceWhen $g._TraceFrequency $g._VariablesToTrace -side top -fill x -padx 5

}


############### NameSharingNode

Code::Dialog ._NameSharingNodeattributes -title "CODE: Name Sharing Node Annotations"
._NameSharingNodeattributes addbutton _OK "OK" "._NameSharingNodeattributes okcmd"
._NameSharingNodeattributes addbutton _Cancel "Cancel" "._NameSharingNodeattributes cancelcmd"
._NameSharingNodeattributes defaultbutton _OK

set attrframe ._NameSharingNodeattributes

set f [frame $attrframe._NameFrame]
pack $f -side top -fill x -expand no
LabeledEntry $f._Name -label "Name:" -text c2_tmp(Name) -validate "c_identifier {%P}"
pack $f._Name -side top

iwidgets::tabnotebook $attrframe._Options -width 500 -height 300 -equaltabs n -tabpos n
# $attrframe._Options add -label "Documentation"
$attrframe._Options add -label "Shared Variables"
$attrframe._Options add -label "Local Variables"
$attrframe._Options add -label "Initial Computation"
$attrframe._Options select 0

pack append $attrframe \
    $attrframe._NameFrame {top frame center fillx}

pack $attrframe._Options -side top -anchor center -expand yes -fill both -padx 10 -pady 10


if 0 {
set f [$attrframe._Options childsite "Documentation"]
Code::Myscrolledtext $f._Documentation -labeltext "Documentation:" \
    -variable "c2_tmp(Docs)" \
    -visibleitems 40x4  -textfont $c2_MonoFont
pack append $f \
	$f._Documentation {top frame center expand fill}
}

set f [$attrframe._Options childsite "Shared Variables"]
Code::Myscrolledtext $f._SharedVariables -labeltext "Shared Variables:" \
    -variable "c2_tmp(SharedVars)" \
    -visibleitems 40x4 -textfont $c2_MonoFont
pack append $f \
	$f._SharedVariables {top frame center expand fill}

set f [$attrframe._Options childsite "Local Variables"]
Code::Myscrolledtext $f._LocalVariables -labeltext "Local Variables:" \
    -variable "c2_tmp(LocalVars)" \
    -visibleitems 40x4 -textfont $c2_MonoFont
pack append $f \
	$f._LocalVariables {top frame center expand fill}

set f [$attrframe._Options childsite "Initial Computation"]
Code::Myscrolledtext $f._InitComputation -labeltext "Initial Computation:" \
    -variable "c2_tmp(InitComp)" \
    -visibleitems 40x4 -textfont $c2_MonoFont
pack append $f \
	$f._InitComputation {top frame center expand fill}


if 0 {

    # Debugger Window "dialog"

    Code::Dialog ._DebuggerWindow -title "CODE: Debugger"
    set attrframe ._DebuggerWindow

    # build widget $attrframe.frame
    frame $attrframe.frame \
	-relief {ridge} \
	-borderwidth 2

    # build widget $attrframe.frame.horizscrollbar
    scrollbar $attrframe.frame.horizscrollbar \
	-command "$attrframe.frame.canvas xview" \
	-orient {horizontal} \
	-relief {raised}

    # build widget $attrframe.frame.vertscrollbar
    scrollbar $attrframe.frame.vertscrollbar \
	-command "$attrframe.frame.canvas yview" \
	-relief {raised}

    # build widget $attrframe.frame.canvas
    global ::c2_DebuggerCanvas
    set c2_DebuggerCanvas \
	[Code::DebuggerCodeCanvas $attrframe.frame.canvas \
	     -closeenough {0.2} \
	     -height {200} \
	     -insertofftime {600} \
	     -relief {sunken} \
	     -scrollregion {0 0 1000 1000} \
	     -width {360} \
	     -xscrollcommand "$attrframe.frame.horizscrollbar set" \
	     -yscrollcommand "$attrframe.frame.vertscrollbar set"]


    # pack widget $attrframe.frame
    pack append $attrframe.frame \
	$attrframe.frame.vertscrollbar {right frame center filly} \
	$attrframe.frame.canvas {top frame center expand fill} \
	$attrframe.frame.horizscrollbar {bottom frame center fillx}

    pack $attrframe.frame -expand yes -fill both


    ._DebuggerWindow default Apply
    ._DebuggerWindow buttonconfigure OK -text "Close"
    ._DebuggerWindow buttonconfigure Apply -text "Run"
    ._DebuggerWindow buttonconfigure Cancel -text "Step"
    ._DebuggerWindow buttonconfigure Help -text "Options"
}

# hierarchy selector

Code::CodeHierarchy .hierarchy $c2_MainCanvas

# error log

Code::Dialog ._Errorlog -title "CODE: Compiler Messages"
._Errorlog addbutton _OK "OK" {[._Errorlog subwidget frame]._Text delete 1.0 end ; ._Errorlog okcmd}
._Errorlog defaultbutton _OK

set attrframe [._Errorlog subwidget frame]

# make an uneditable text box with word-wrapping.

set f [text $attrframe._Text -height 10 -width 40 -wrap word -takefocus 0]
pack $f -side top -fill both -expand yes


#####

# the focus will have shifted to the debugger canvas;
# set it back to where it should be (the main canvas).

if 0 {
    Code::CodeCanvas::SetCurrentWindow $c2_MainCanvas
    $c2_MainCanvas Canvas_Enter
}
