if { [catch { set c2_CodeDirectory "$env(CODEDIR)" }] } {
    #
    # if there is no CODEDIR, exit
    #
    error "Please set the environment variable CODEDIR to CODE's main directory and try again."
    exit
}

namespace ::Code {}
import add Code

source "$env(IWIDGETS_LIBRARY)/init.iwidgets"
lappend auto_path $c2_CodeDirectory/ui/wigwam/lib
lappend auto_path $c2_CodeDirectory/ui

wigwam init

code2 nodisplay




proc parse {fileid} {
    gets $fileid line1
    gets $fileid line2
    gets $fileid line3
    regexp {(/[^\:\[]*)(\[.*\])*:([0-9]*)} $line1 dummy path indices instance
    regsub "FP:" $line2 "" line2
    set paths $line2
    puts "new path = $path, indices = $indices, instance = $instance, paths = $paths"

    global c_instances c_events

    $c_instances graph_update $path $indices $instance $paths
    $c_events    graph_update $path $indices $instance $paths

    $c_instances relayout
    $c_events    relayout

    # Force a screen update.

    update
}




proc parse_run {} {
    global f running
    set running 1
    ._DebuggerWindow buttonconfigure Apply -text "Stop" -command {parse_stop}
    ._DebuggerWindow buttonconfigure Cancel -state disabled
    while {![eof $f] && $running} {
	parse_one
    }
    if [eof $f] {
	parse_done
    }
}

proc parse_stop {} {
    global f running
    ._DebuggerWindow buttonconfigure Apply -text "Run" -command {parse_run}
    ._DebuggerWindow buttonconfigure Cancel -state active
    set running 0
}

proc parse_one {} {
    global f
    if ![eof $f] {
	parse $f
    } else {
	parse_done
    }
}

proc parse_done {} {
    ._DebuggerWindow buttonconfigure Apply -text "Run" -command {} -state disabled
    ._DebuggerWindow buttonconfigure Cancel -command {} -state disabled
}



iwidgets::Dialog ._DebuggerWindow -title "Code: Debugger" -modality none
._DebuggerWindow default Apply
._DebuggerWindow buttonconfigure OK -text "Close"
._DebuggerWindow buttonconfigure Apply -text "Run" -command {parse_run}

._DebuggerWindow buttonconfigure Cancel -text "Step"  -command {parse_one}
._DebuggerWindow buttonconfigure Help -text "Options"

set attrframe [info namespace tail [._DebuggerWindow childsite]]

# build widget $attrframe.frame
frame $attrframe.frame \
	-relief {ridge} \
	-borderwidth 2

frame $attrframe.frame.f1 -relief raised
DebuggerCodeCanvas $attrframe.frame.f1.c -width 200 -height 200 -scrollregion {0 0 1000 1000}  -xscrollcommand "$attrframe.frame.f1.sbx set" -yscrollcommand "$attrframe.frame.f1.sby set" -closeenough 0.2
scrollbar $attrframe.frame.f1.sbx -command "$attrframe.frame.f1.c xview" -orient horizontal -relief raised
scrollbar $attrframe.frame.f1.sby -command "$attrframe.frame.f1.c yview" -relief raised
pack append $attrframe.frame.f1 \
	$attrframe.frame.f1.sby {right frame center filly} \
	$attrframe.frame.f1.c   {top frame center expand fill} \
	$attrframe.frame.f1.sbx {bottom frame center fillx}

frame $attrframe.frame.f2 -relief raised
DebuggerCodeCanvas $attrframe.frame.f2.c -width 200 -height 200 -scrollregion {0 0 1000 1000} -xscrollcommand "$attrframe.frame.f2.sbx set" -yscrollcommand "$attrframe.frame.f2.sby set" -closeenough 0.2
scrollbar $attrframe.frame.f2.sbx -command "$attrframe.frame.f2.c xview" -orient horizontal -relief raised
scrollbar $attrframe.frame.f2.sby -command "$attrframe.frame.f2.c yview" -relief raised
pack append $attrframe.frame.f2 \
	$attrframe.frame.f2.sby {right frame center filly} \
	$attrframe.frame.f2.c   {top frame center expand fill} \
	$attrframe.frame.f2.sbx {bottom frame center fillx}



pack append $attrframe.frame \
	$attrframe.frame.f1 {top frame center expand fill} \
	$attrframe.frame.f2 {bottom frame center expand fill}


pack $attrframe.frame -expand yes -fill both


# the two canvases

set c_instances $attrframe.frame.f1.c
set c_events    $attrframe.frame.f2.c


# the not-to-be-packed canvas for dot stuff

set dot_canvas   [canvas .dotcanvas]

$c_instances configure -dot_canvas $dot_canvas -canvas_type instances
$c_events    configure -dot_canvas $dot_canvas -canvas_type events

set f [open "testdebugger" r]

._DebuggerWindow activate
