class Code::Dialog {

    inherit wigwam::itcl_toplevel

    itk_option define -title title Title "Code Dialog"

    constructor {args} { eval wigwam::itcl_toplevel::constructor $args } {}
    destructor {}

    public method addbutton {name text cmd}
    public method defaultbutton {name}
    public method activate {}
    public method cancelcmd {}
    public method okcmd {}
    public method popup {}
    public method popdown {}
    public method subwidget {widget}

    protected method center {}  ;# center the window wrt its parent
    private variable oldthis

}


configbody Code::Dialog::title {
    wm title [info namespace tail $this] $itk_option(-title)
}


body Code::Dialog::constructor {args} {
    set oldthis [info namespace tail $this]
    frame $oldthis.frame
    iwidgets::buttonbox $oldthis.buttonbox
    # Code::Buttonbox $oldthis.buttonbox -orient horizontal
    pack $oldthis.frame -side top -anchor n -fill both -expand y
    pack $oldthis.buttonbox -side bottom -anchor s -fill both -expand n
    popdown
    eval itk_initialize $args
    # wm protocol $oldthis WM_DELETE_WINDOW "$oldthis.buttonbox invoke"
}


body Code::Dialog::addbutton {name text cmd} {
    [$this subwidget buttonbox] add $name -text $text -command $cmd
}


body Code::Dialog::defaultbutton {name} {
    # [$this subwidget buttonbox] default $name
}


body Code::Dialog::activate {} {
    global ::dialog_status
    popup
    set dialog_status($this) 0
    tkwait variable dialog_status($this)
    return $dialog_status($this)
}


body Code::Dialog::cancelcmd {} {
    global ::dialog_status

    popdown
    set dialog_status($this) 0
}

body Code::Dialog::center {} {
    wm sizefrom $oldthis user
    wm positionfrom $oldthis user

    set parent "."
    if {$parent != ""} {
	set pargeo [split [wm geometry $parent] "+x"]
	set parentW [lindex $pargeo 0]
	set parentH [lindex $pargeo 1]
	set parx [lindex $pargeo 2]
	set pary [lindex $pargeo 3]

	wm transient $oldthis $parent
    } else {
	set parentW [winfo screenwidth $oldthis]
	set parentH [winfo screenheight $oldthis]
	set parx 0
	set pary 0
	set parent [winfo parent $oldthis]
    }

    # What are is the offset of the virtual window
    set vrootx [winfo vrootx $parent]
    set vrooty [winfo vrooty $parent]

    # What are my dimensions ?
    set dialogW [winfo reqwidth $oldthis]
    set dialogH [winfo reqheight $oldthis]

    if {$dialogW < [expr $parentW-30] || $dialogW < [expr $parentH-30]} {
	set dialogx [expr $parx+($parentW-$dialogW)/2+$vrootx]
	set dialogy [expr $pary+($parentH-$dialogH)/2+$vrooty]
    } else {
	# This dialog is too big. Place it at (parentx, parenty) + (20,20)
	#
	set dialogx [expr $parx+20+$vrootx]
	set dialogy [expr $pary+20+$vrooty]
    }

    set maxx [expr "[winfo screenwidth  $parent] - $dialogW"]
    set maxy [expr "[winfo screenheight $parent] - $dialogH"]

    # Make sure it doesn't go off screen
    #
    if {$dialogx < 0} {
	set dialogx 0
    } else {
	if {$dialogx > $maxx} {
	    set dialogx $maxx
	}
    }
    if {$dialogy < 0} {
	set dialogy 0
    } else {
	if {$dialogy > $maxy} {
	    set dialogy $maxy
	}
    }

    # set my new position (and dimensions)
    #

    wm geometry $oldthis $dialogW\x$dialogH\+$dialogx\+$dialogy

}


body Code::Dialog::okcmd {} {
    global ::dialog_status

    popdown
    set dialog_status($this) 1
}


body Code::Dialog::popup {} {
    update idletasks
    center
    wm deiconify $oldthis
    raise $oldthis
}


body Code::Dialog::popdown {} {
    # Hide it.
    wm withdraw $oldthis
}


body Code::Dialog::subwidget {widget} {
    switch $widget {
	frame {
	    return [info namespace tail $this.frame]
	}
	buttonbox {
	    return [info namespace tail $this.buttonbox]
	}
    }
}
