proc build_iconbar {w statusbar} {

    # Set up a variable and a trace procedure
    # for updating the statusbar label.

    global ${w}_statusbar

    set ${w}_statusbar ""

    proc update_statusbar {statusbar statusbarvar name e op} {
	global $statusbarvar
	$statusbar configure -text [set $statusbarvar]
    }

    trace variable ${w}_statusbar w "update_statusbar $statusbar ${w}_statusbar"

    # Set up the toolbar.

    global c2_MenuFont c2_ReleaseDirectory


    iwidgets::toolbar $w.tb -helpvariable ${w}_statusbar

    $w.tb add button select \
	-balloonstr "Arrow tool" \
	-helpstr "Arrow tool: Use to select, move, or draw arcs between nodes" \
	-bitmap "@$c2_ReleaseDirectory/bitmaps/left_ptr" \
	-command {Code::CodeCanvas::set_tool Select} \
	-font {9x15} \
	-text {button0} \
	-height {32} \
	-width {32}

    $w.tb add button text \
	-balloonstr "Text tool" \
	-helpstr "Text tool: Click on the canvas to edit labels or write comments" \
	-bitmap "@$c2_ReleaseDirectory/bitmaps/CommentMode.bit" \
	-command {Code::CodeCanvas::set_tool Comment} \
	-font {9x15} \
	-text {button0} \
	-height {32} \
	-width {32}

    $w.tb add button info \
	-balloonstr "Info tool" \
	-helpstr "Info tool: Click on an item to view its annotations" \
	-bitmap "@$c2_ReleaseDirectory/bitmaps/info" \
	-command {Code::CodeCanvas::set_tool Query} \
	-font {9x15} \
	-text {button0} \
	-height {32} \
	-width {32}

    $w.tb add button drag \
	-balloonstr "Drag tool" \
	-helpstr "Drag tool: Click and drag on the canvas to scroll" \
	-bitmap "@$c2_ReleaseDirectory/bitmaps/HandDrag.bit" \
	-command {Code::CodeCanvas::set_tool Drag} \
	-font {9x15} \
	-text {button0} \
	-height {32} \
	-width {32}

    $w.tb add frame filler1 \
	-borderwidth 1 \
	-width 10 \
	-height 10

    $w.tb add button computation \
	-balloonstr "Computation node" \
	-image [uplevel #0 image create photo -palette 256x256x256 -format GIF -file "$c2_ReleaseDirectory/bitmaps/CompNode.gif"] \
        -command {Code::CodeCanvas::set_tool CompNode} \
	-helpstr "Computation: Performs sequential computations" \
	-font {9x15} \
	-text {button0} \
	-height {32} \
	-width {32}

    $w.tb add button container \
	-balloonstr "Container node" \
	-image [uplevel #0 image create photo -palette 256x256x256 -format GIF -file "$c2_ReleaseDirectory/bitmaps/CallNode.gif"] \
        -command {Code::CodeCanvas::set_tool CallNode} \
	-helpstr "Container: Contains a subgraph (double-click to enter)" \
	-font {9x15} \
	-text {button0} \
	-height {32} \
	-width {32}


    $w.tb add button crep \
	-balloonstr "Creation Parameter node" \
	-image [uplevel #0 image create photo -palette 256x256x256 -format GIF -file "$c2_ReleaseDirectory/bitmaps/CreationParameterNode.gif"] \
        -command {Code::CodeCanvas::set_tool CreationParameterNode} \
	-helpstr "Creation Parameter: A one-input read-only input global to the subgraph" \
	-font {9x15} \
	-text {button0} \
	-height {32} \
	-width {32}


    $w.tb add button input \
	-balloonstr "Input node" \
	-image [uplevel #0 image create photo -palette 256x256x256 -format GIF -file "$c2_ReleaseDirectory/bitmaps/InInterfaceNode.gif"] \
        -command {Code::CodeCanvas::set_tool InInterfaceNode} \
	-helpstr "Input: Defines the input to a subgraph" \
	-font {9x15} \
	-text {button0} \
	-height {32} \
	-width {32}

    $w.tb add button output \
	-balloonstr "Output node" \
	-image [uplevel #0 image create photo -palette 256x256x256 -format GIF -file "$c2_ReleaseDirectory/bitmaps/OutInterfaceNode.gif"] \
        -command {Code::CodeCanvas::set_tool OutInterfaceNode} \
	-helpstr "Output: Defines the output from a subgraph" \
	-font {9x15} \
	-text {button0} \
	-height {32} \
	-width {32}

    $w.tb add button sharedvar \
	-balloonstr "Shared Variable node" \
	-image [uplevel #0 image create photo -palette 256x256x256 -format GIF -file "$c2_ReleaseDirectory/bitmaps/NameSharingNode.gif"] \
        -command {Code::CodeCanvas::set_tool NameSharingNode} \
	-helpstr "Shared Variable: Many-readers, one-writer shared variable" \
	-font {9x15} \
	-text {button0} \
	-height {32} \
	-width {32}

    if (0) {
    $w.tb add frame filler2 \
	-borderwidth 1 \
	-width 10 \
	-height 10

    $w.tb add button magnify \
	-balloonstr "Magnify tool" \
        -bitmap "@$c2_ReleaseDirectory/bitmaps/ZoomIn.bit" \
        -command {Code::CodeCanvas::set_tool ZoomIn} \
	-helpstr "Magnify tool: Click on the canvas to zoom in" \
	-font {9x15} \
	-text {button0} \
	-height {32} \
	-width {32}

    $w.tb add button shrink \
	-balloonstr "Shrink tool" \
        -bitmap "@$c2_ReleaseDirectory/bitmaps/ZoomOut.bit" \
        -command {Code::CodeCanvas::set_tool ZoomOut} \
	-helpstr "Shrink tool: Click on the canvas to zoom out" \
	-font {9x15} \
	-text {button0} \
	-height {32} \
	-width {32}
    }

    $w.tb add frame filler3 \
	-borderwidth 1 \
	-width 10 \
	-height 10

    $w.tb add button mpi \
	-balloonstr "Compile for MPI" \
	-image [uplevel #0 image create photo -palette 256x256x256 -format GIF -file "$c2_ReleaseDirectory/bitmaps/mpi-button.gif"] \
	-command {c2_RunProgram MPI} \
	-helpstr "Compile an MPI program" \
	-font {9x15} \
	-text {button0}

    $w.tb add button pvm \
	-balloonstr "Compile for PVM" \
	-image [uplevel #0 image create photo -palette 256x256x256 -format GIF -file "$c2_ReleaseDirectory/bitmaps/pvm-button.gif"] \
	-command {c2_RunProgram PVM} \
	-helpstr "Compile a PVM program" \
	-font {9x15} \
	-text {button0}

    $w.tb add button smp \
        -background {White} \
	-balloonstr "Compile for an SMP" \
	-helpstr "Compile for an SMP" \
	-bitmap "@$c2_ReleaseDirectory/bitmaps/SMP.bit" \
	-command {c2_RunProgram SMP} \
	-font {9x15} \
	-text {button0} \
	-height {32} \
	-width {32}

    $w.tb add button serial \
	-balloonstr "Compile for a uniprocessor" \
	-image [uplevel #0 image create photo -palette 256x256x256 -format GIF -file "$c2_ReleaseDirectory/bitmaps/serial.gif"] \
	-command {c2_RunProgram Serial} \
	-helpstr "Compile for a uniprocessor (serial)" \
	-font {9x15} \
	-text {button0}

    $w.tb add frame filler4 \
	-borderwidth 1 \
	-width 10 \
	-height 10

    $w.tb add button progannos \
	-balloonstr "Program Annotations" \
	-image [uplevel #0 image create photo -palette 256x256x256 -format GIF -file "$c2_ReleaseDirectory/bitmaps/mini-code-icon.gif"] \
	-command {c2_GlobalAnnotations} \
	-helpstr "Program Annotations: Define global functions, types and object files to link" \
	-font {9x15} \
	-text {button0}


    pack $w.tb -side top -anchor nw

}
