#
# mainscreen.tcl
# ------------------------------------------------------------------------
# Contains exactly one procedure, ShowWindow., which brings up the main
# CODE screen.
# ------------------------------------------------------------------------
# @(#) $Id: mainscreen.tcl,v 1.22 1998/11/25 05:30:52 emery Exp $
# ------------------------------------------------------------------------
# AUTHOR:
#
# Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
# Systems Analyst                 @           <mailto:emery@cs.utexas.edu>
# Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
# Department of Computer Sciences |             <http://www.cs.utexas.edu>
# University of Texas at Austin   |                <http://www.utexas.edu>
# ========================================================================


# procedure to show window .
proc ShowWindow {args} {

    global \
	    c2_ReleaseDirectory \
	    c2_tmp \
	    c2_MenuFont \
	    c2_SummaryStatistics \
	    c2_OptimizeProgram \
	    c2_DebuggerOn \
	    c2_BufferTraceEvents \
	    c2_TranslationTarget \
	    c2_ReshapeArcs
    
    tk appname CODE


    # Window manager configurations

    wm title . "CODE"
    wm withdraw .


    # Put up a splash screen.
    
    if 0 {
	toplevel .splash
	wm title .splash {CODE - Now Loading...}
	bind .splash <Visibility> "update"
	
	set splash [image create photo -palette 256x256x256 -format GIF -file "$c2_ReleaseDirectory/bitmaps/code-screen-logo.gif"]
	
	label .splash.label -image $splash -borderwidth 0
	pack .splash.label -expand yes -fill both -anchor c
	
	# Put the watch cursor up while the screen loads.
	
	lookbusy .splash on
	# update idletasks
	
    }

    # Create the icon for CODE (for when it's iconifed).

    set icon ".__Icon"
    toplevel $icon

    # Put a fancy border around it.
    frame $icon.f   -bd 2 -relief raised
    frame $icon.f.f -bd 2 -relief groove
    label $icon.f.f.l \
	-image [image create photo -palette 256x256x256 -format GIF -file "$c2_ReleaseDirectory/bitmaps/code-icon.gif"] \
	-anchor center

    pack $icon.f     -side top -fill both -expand y
    pack $icon.f.f   -side top -fill both -expand y
    pack $icon.f.f.l -side top -fill both -expand y

    wm iconwindow . $icon
    wm iconname   . CODE

    # wm iconbitmap . "@$c2_ReleaseDirectory/bitmaps/code-icon.xbm"

    lookbusy . on

    #####################
    #                   #
    # build main window #
    #                   #
    
    
    # build widget .frame0
    frame .frame0 \
	    -borderwidth {2} \
	    -relief {raised}

    # build widget .framesix
    frame .framesix \
	    -borderwidth {2} \
	    -relief {raised}
    
    # build widget .framesix.framezero
    frame .framesix.framezero \
	    -relief {raised}
    
    # build widget .framesix.framezero.scrollbar3
    scrollbar .framesix.framezero.scrollbar3 \
	    -command {.framesix.framezero.canvastwo xview} \
	    -orient {horizontal} \
	    -relief {raised}

    # build widget .framesix.framezero.scrollbar1
    scrollbar .framesix.framezero.scrollbar1 \
	    -command {.framesix.framezero.canvastwo yview} \
	    -relief {raised}

    # build widget .framesix.framezero.canvastwo
    set c2_MainCanvas \
	    [Code::CodeCanvas .framesix.framezero.canvastwo \
	    -closeenough {0.2} \
	    -scrollregion {0 0 1000 1000} \
	    -xscrollcommand {.framesix.framezero.scrollbar3 set} \
	    -yscrollcommand {.framesix.framezero.scrollbar1 set}]

    #   -relief {sunken} -height {200} -width {360}

    build_menubar .frame0 $c2_MainCanvas

    # pack widget .framesix.framezero
    pack append .framesix.framezero \
	    .framesix.framezero.scrollbar1 {right frame center filly} \
	    .framesix.framezero.canvastwo {top frame center expand fill} \
	    .framesix.framezero.scrollbar3 {bottom frame center fillx}

    global c2_MenuFont
    label .framesix.statusbar -text "" -height 1 -relief sunken -borderwidth 2 -font $c2_MenuFont

    # pack widget .framesix
    pack append .framesix \
	    .framesix.framezero {top frame center expand fill} \
	    .framesix.statusbar {bottom frame s fillx}

    # build widget .frame1
    frame .frame1 \
	    -borderwidth {2} \
	    -relief {raised}

    build_iconbar .frame1 .framesix.statusbar

    # wait for the splash screen to come up

    # update idletasks

    global c2_ReleaseDirectory
    source $c2_ReleaseDirectory/createDialogs.tcl

    # destroy .splash

    # wm minsize . [Code::CodeCanvas::window_width] [Code::CodeCanvas::window_height]
    wm geometry . [Code::CodeCanvas::window_width]x[Code::CodeCanvas::window_height]

    wm title . "CODE - Untitled"
    wm protocol . WM_DELETE_WINDOW {c2_QuitProgram}
    wm deiconify .

    # clean up and draw the main window

    pack append . \
	.frame0 {top frame nw fillx} \
	.frame1 {top frame nw fillx} \
	.framesix {right frame ne expand fill}

    # display the splash inside the canvas, and
    # make it so that any click in the canvas both
    # removes the image and sets up the real bindings.

    set canvas_splash [$c2_MainCanvas create image 365 198 -image $splash -anchor c]

    # ugly hack follows...

    ::bind $c2_MainCanvas <Button-1> "[::bind $c2_MainCanvas <Button-1>] ; $c2_MainCanvas delete $canvas_splash ; $c2_MainCanvas perform_canvas_bindings"

    # update idletasks
    # after 3000 ;# let the splash stay on for three seconds.

    lookbusy . off
}
