proc build_menubar {w canvas} {

    global c2_MenuFont c2_MainCanvas

    if 0 {

	proc filemenu_post {menu} {
	    global c2_MainCanvas

	    #
	    #  these should only be enabled when we
	    #  have something in the main canvas:
	    #    save, save as..., translate, run, print canvases
	    #
	    
	    set enabled [string compare [winfo children $c2_MainCanvas] ""]
	    
	    foreach i {save saveas compile printgraphs printannos} {
		$menu menuconfigure "file:$i" \
		    -state [lindex {{disabled} {normal}} $enabled]
	    }
	    
	}
	
	set bar [iwidgets::Menubar "$w.#auto"]
	
	$bar configure -menubuttons {
	    menubutton file -text File -menu {
		options -tearoff false

		command new -label {New} \
		    -accelerator {Alt+N} \
		    -helpstr "Start a new program" \
		    -command {c2_NewFile}

		command open -label {Open} \
		    -accelerator {Alt+O} \
		    -helpstr "Open an existing program" \
		    -command "$c2_MainCanvas open"

		cascade insert -label {Insert} -menu {
		    command insertdirectly -label {Insert Directly...} \
			-command "$canvas insert_file_dlog"

		    command insertnode -label {Insert into a New Container...} \
			-command "$canvas insert_file_callnode_dlog"

		}

		command close -label {Close} \
		    -command "$canvas collapse"

		# -state [lindex {{normal} {disabled}} [string compare $canvas $c2_MainCanvas]]

		separator sepfile1
		
		command save -label {Save} \
		    -accelerator {Alt+S} \
		    -command "$c2_MainCanvas save_file"
		
		command saveas -label {Save As...} \
		    -command "$c2_MainCanvas save_as"

		separator sepfile2
		
		command programannos -label {Program Annotations...} \
		    -command {c2_GlobalAnnotations}
		
		cascade compile -label {Compile} -menu {

		    command mpi -label {MPI} \
			-command {c2_RunProgram MPI}
		    
		    command pvm2 -label {PVM2} \
			-command {c2_RunProgram PVM2}

		    command serial -label {Serial (sequential)} \
			-command {c2_RunProgram Serial}
		}

		separator sepfile3

		command printsetup -label {Printer Setup...} \
		    -command {c2_PrintSetup}

		command printgraphs -label {Print Graphs...} \
		    -command {c2_PrintCanvases}

		command printannos -label {Print Annotations...} \
		    -command {c2_PrintAnnotations}

		separator sepfile4

		command quit -label {Quit} \
		    -accelerator {Alt+Q} \
		    -command {c2_QuitProgram}

	    }

	    menubutton edit -text Edit -menu {

		command undo -label {Undo} \
		    -accelerator {Alt+Z} \
		    -command "$canvas undo"

		separator sepedit1

		command cut -label {Cut} \
		    -accelerator {Alt+X} \
		    -command "$canvas cut"

		command copy -label {Copy} \
		    -accelerator {Alt+C} \
		    -command "$canvas copy"

		command paste -label {Paste} \
		    -accelerator {Alt+V} \
		    -command "$canvas paste"

		command clear -label {Clear} \
		    -accelerator {Del} \
		    -command "$canvas delete_selected"

		separator sepedit2

		command selectall -label {Select All} \
		    -accelerator {Alt+A} \
		    -command "$canvas select_all"

		command duplicate -label {Duplicate} \
		    -accelerator {Alt+D} \
		    -command "$canvas duplicate"

	    }

	    menubutton arrange -text Arrange -menu {
		command group -label {Group} \
		    -accelerator {Alt+G} \
		    -command "$canvas group_selected" \
		    -state {disabled}

		command ungroup -label {Ungroup} \
		    -command "$canvas ungroup_selected" \
		    -state {disabled}

		command lock -label {Lock} \
		    -command "$canvas lock" \
		    -state {disabled}

		command unlock -label {Unlock} \
		    -command "$canvas unlock" \
		    -state {disabled}

		separator separrange1

		cascade verticalalignment -label {Vertical Alignment} -menu {
		    command top -label {Top} \
			-command "$canvas align top"

		    command vcenter -label {Center} \
			-command "$canvas align vcenter"

		    command bottom -label {Bottom} \
			-command "$canvas align bottom"

		}

		cascade horizontalalignment -label {Horizontal Alignment} -menu {
		    command left -label {Left} \
			-command "$canvas align left"

		    command hcenter -label {Center} \
			-command "$canvas align hcenter"

		    command right -label {Right} \
			-command "$canvas align right"
		}

	    }

	    menubutton special -text Special -menu {
		checkbutton showarcpoints -label {Show Arc Points} \
		    -variable c2_ReshapeArcs

		checkbutton displayarclabels -label {Display Arc Labels} \
		    -variable c2_DisplayArcLabels

		separator sepspecial1

		command browse -label {Browse the Hierarchy...} \
		    -command {c2_GotoCallNode}

		command findnode -label {Find a Node...} \
		    -command {c2_FindNode}

	    }

	    menubutton windows -text Windows -menu {
		command nowindows -label {no windows} \
		    -state {disabled} \
		    -command {}
	    }

	    menubutton help -text Help -menu {
		command aboutcode -label {About CODE...} \
		    -command {.aboutdialog popup}
	    }


	}

	# $bar menuconfigure "file" -postcommand "filemenu_post $bar"

	pack append $w \
	    $bar {left frame center expand padx 5 fillx}

	return

    }

    # build widget $w.menubutton2
    menubutton $w.menubutton2 \
	-menu "$w.menubutton2.m" \
	-font "$c2_MenuFont" \
	-text {File}
    
    # build widget $w.menubutton2.m
    menu $w.menubutton2.m \
	-font "$c2_MenuFont" \
	-tearoff 0
    
    $w.menubutton2.m add command -label {New} \
	-accelerator {Alt+N} \
	-underline 0 \
	-command {c2_NewFile}
    $w.menubutton2.m add command -label {Open...} \
	-accelerator {Alt+O} \
	-underline 0 \
	-command "$c2_MainCanvas open"
    $w.menubutton2.m add cascade -label {Insert File} \
	-menu $w.menubutton2.m.insert

    menu $w.menubutton2.m.insert \
	-font "$c2_MenuFont" \
	-tearoff 0

    $w.menubutton2.m.insert add command -label {Insert Directly...} \
	-command "$canvas insert_file_dlog"

    $w.menubutton2.m.insert add command -label {Insert into a New Container...} \
	-command "$canvas insert_file_callnode_dlog"


    $w.menubutton2.m add command -label {Close} \
	-command "$canvas collapse"

    # Disable "Close" command if we are the main canvas.

    if {![string compare $canvas $c2_MainCanvas]} {
	$w.menubutton2.m entryconfigure 3 -state disabled
    }

    $w.menubutton2.m add separator

    $w.menubutton2.m add command -label {Save} \
	-accelerator {Alt+S} \
	-underline 0 \
	-command "$c2_MainCanvas save_file"
    $w.menubutton2.m add command -label {Save As...} \
	-command "$c2_MainCanvas save_as"
    $w.menubutton2.m add separator

    $w.menubutton2.m add command -label {Program Annotations...} \
	-command {c2_GlobalAnnotations}

    if 0 {
	$w.menubutton2.m add command -label {Execution Preferences} \
	    -command {c2_ExecutionSetup}
    }

    $w.menubutton2.m add cascade -label {Compile} \
	-menu "$w.menubutton2.m.m"

    menu $w.menubutton2.m.m -font "$c2_MenuFont" -tearoff 0

    $w.menubutton2.m.m add command -label {MPI} -command {c2_RunProgram MPI}
    $w.menubutton2.m.m add command -label {PVM} -command {c2_RunProgram PVM}
    $w.menubutton2.m.m add command -label {SMP} -command {c2_RunProgram SMP}
    $w.menubutton2.m.m add command -label {Serial} -command {c2_RunProgram Serial}


    $w.menubutton2.m add separator

    $w.menubutton2.m add command -label {Printer Setup...} \
	-command {c2_PrintSetup}
    $w.menubutton2.m add command -label {Print Graphs...} \
	-command {c2_PrintCanvases}
    $w.menubutton2.m add command -label {Print Annotations...} -command {c2_PrintAnnotations}

    $w.menubutton2.m add separator

    $w.menubutton2.m add command -label {Quit} \
	-accelerator {Alt+Q} \
	-underline 0 \
	-command {c2_QuitProgram}

    
    proc filemenu_post {w canvas} {
	global c2_MainCanvas

	#
	#  these should only be enabled when we
	#  have something in the main canvas:
	#    save, save as..., translate, run, print canvases
	#
	
	set enabled [string compare [winfo children $c2_MainCanvas] ""]
	
	foreach i {5 6 9 11 12} {
	    $w.menubutton2.m entryconfigure $i \
		-state [lindex {{disabled} {normal}} $enabled]
	}
	
    }

    $w.menubutton2.m configure -postcommand "filemenu_post $w $canvas"


    # build widget $w.menubutton3
    menubutton $w.menubutton3 \
	-font "$c2_MenuFont" \
	-menu "$w.menubutton3.m" \
	-text {Edit}
    
    # build widget $w.menubutton3.m
    menu $w.menubutton3.m \
	-font "$c2_MenuFont" \
	-tearoff 0
    
    # enable or disable menu items

    proc editmenu_post {w canvas} {

	set currentwin $canvas

	#
	#  cut, copy, clear, and duplicate
	#  should be enabled only when we have
	#  selected something
	#

	set enabled [string compare \
			 [$currentwin selected_items] ""]

	foreach i {2 3 5 8} {
	    $w.menubutton3.m entryconfigure $i \
		-state [lindex {{disabled} {normal}} $enabled]
	}


	#
	#  select-all should only be enabled when we
	#  have something in the current canvas
	#

	set enabled [string compare [winfo children $currentwin] ""]

	$w.menubutton3.m entryconfigure 7 \
	    -state [lindex {{disabled} {normal}} $enabled]


	#
	#  undo is enabled only when the last action is undoable
	#

	$w.menubutton3.m entryconfigure 0 \
	    -state [lindex {{disabled} {normal}} [$currentwin undoable]]

	#
	#  paste is enabled only when there is something in the
	#  cut buffer
	#

	$w.menubutton3.m entryconfigure 4 \
	    -state [lindex {{disabled} {normal}} [$currentwin can_paste]]
    }

    $w.menubutton3.m configure -postcommand "editmenu_post $w $canvas"
    
    $w.menubutton3.m add command \
	-accelerator {Alt+Z} \
	-command "$canvas undo" \
	-label {Undo}
    $w.menubutton3.m add separator
    $w.menubutton3.m add command \
	-accelerator {Alt+X} \
	-command "$canvas cut" \
	-label {Cut}
    $w.menubutton3.m add command \
	-accelerator {Alt+C} \
	-underline 0 \
	-command "$canvas copy" \
	-label {Copy}
    $w.menubutton3.m add command \
	-accelerator {Alt+V} \
	-command "$canvas paste" \
	-label {Paste}
    $w.menubutton3.m add command \
	-accelerator {Del} \
	-command "$canvas delete_selected" \
	-label {Clear}
    $w.menubutton3.m add separator
    $w.menubutton3.m add command \
	-accelerator {Alt+A} \
	-command "$canvas select_all" \
	-label {Select All} \
	-underline 7 \
	-state {normal}
    $w.menubutton3.m add command \
	-accelerator {Alt+D} \
	-underline 0 \
	-command "$canvas duplicate" \
	-label {Duplicate}

    
    
    # build widget $w.menubutton4
    menubutton $w.menubutton4 \
	-font "$c2_MenuFont" \
	-menu "$w.menubutton4.m" \
	-text {Arrange}
    
    # build widget $w.menubutton4.m
    menu $w.menubutton4.m \
	-font "$c2_MenuFont" \
	-tearoff 0
    
    # enable or disable menu items based on whether we have selected anything

    proc arrangemenu_post {w canvas} {
	set enabled [string compare [$canvas selected_items] ""]
	foreach i {0 1 2 3 5 6} {
	    $w.menubutton4.m entryconfigure $i \
		-state [lindex {{disabled} {normal}} $enabled]
	}
    }
    
    $w.menubutton4.m configure -postcommand "arrangemenu_post $w $canvas"
    
    $w.menubutton4.m add command \
	-accelerator {Alt+G} \
	-command "$canvas group_selected" \
	-label {Group} \
	-underline 0 \
	-state {disabled}
    $w.menubutton4.m add command \
	-command "$canvas ungroup_selected" \
	-label {Ungroup} \
	-state {disabled}
    $w.menubutton4.m add command \
	-command "$canvas lock" \
	-label {Lock} \
	-state {disabled}

    $w.menubutton4.m add command \
	-command "$canvas unlock" \
	-label {Unlock} \
	-state {disabled}
    $w.menubutton4.m add separator
    $w.menubutton4.m add cascade \
	-label {Vertical Alignment} \
	-menu "$w.menubutton4.m.m" \
	-state {disabled}
    $w.menubutton4.m add cascade \
	-label {Horizontal Alignment} \
	-menu "$w.menubutton4.m.m2" \
	-state {disabled}

    # build widget $w.menubutton4.m.m
    menu $w.menubutton4.m.m \
	-font "$c2_MenuFont" \
	-tearoff 0
    $w.menubutton4.m.m add command \
	-command "$canvas align top" \
	-label {Top}
    $w.menubutton4.m.m add command \
	-command "$canvas align vcenter" \
	-label {Center}
    $w.menubutton4.m.m add command \
	-command "$canvas align bottom" \
	-label {Bottom}
    
    # build widget $w.menubutton4.m.m2
    menu $w.menubutton4.m.m2 \
	-font "$c2_MenuFont" \
	-tearoff 0
    $w.menubutton4.m.m2 add command \
	-command "$canvas align left" \
	-label {Left}
    $w.menubutton4.m.m2 add command \
	-command "$canvas align hcenter" \
	-label {Center}
    $w.menubutton4.m.m2 add command \
	-command "$canvas align right" \
	-label {Right}
    



    # build widget $w.menubutton5
    menubutton $w.menubutton5 \
	-font "$c2_MenuFont" \
	-menu $w.menubutton5.m \
	-text {Windows}
    
    
    proc windowsmenu_post {w canvas} {

	global c2_MainCanvas

	# put up a list of all call node subgraph windows
	# (with the main canvas on the top)

	$w.menubutton5.m delete 0 last

	$w.menubutton5.m add command \
	    -command "raise ." \
	    -label {Main Program}

	foreach dlog [winfo children .] {
	    if {[string match "*_CallNode*" $dlog]} {
		if {[winfo ismapped $dlog]} {
		    $w.menubutton5.m add command \
			-command "raise $dlog" \
			-label "[string range [wm title $dlog] 7 end]"
		}
	    }
	}
    }


    # build widget $w.menubutton5.m
    menu $w.menubutton5.m \
	-font "$c2_MenuFont" \
	-tearoff 0 \
	-postcommand "windowsmenu_post $w $canvas"
    
    $w.menubutton5.m add command \
	-command {} \
	-label {no windows} \
	-state {disabled}
    

    # build widget $w.menubutton6
    menubutton $w.menubutton6 \
	-font "$c2_MenuFont" \
	-menu "$w.menubutton6.m" \
	-text {Special}
    
    # build widget $w.menubutton6.m
    menu $w.menubutton6.m \
	-font "$c2_MenuFont" \
	-tearoff 0

    $w.menubutton6.m add checkbutton \
	-variable c2_ReshapeArcs \
	-label {Show Arc Points}

    $w.menubutton6.m add checkbutton \
	-variable c2_DisplayArcLabels \
	-label {Display Arc Labels}

    $w.menubutton6.m add separator
    
    if 1 {    $w.menubutton6.m add command \
	-command {c2_GotoCallNode} \
	-label "Browse the Hierarchy..."

    $w.menubutton6.m add command \
	-command {c2_FindNode} \
	-label "Find a Node..."
    }

    if 0 {
	$w.menubutton6.m add command \
	    -command {c2_Debugger} \
	    -label "Debugger..."
    }


    # build widget $w.menubutton8
    menubutton $w.menubutton8 \
	-font "$c2_MenuFont" \
	-menu "$w.menubutton8.m" \
	-text {Help}
    
    # build widget $w.menubutton8.m
    menu $w.menubutton8.m \
	-font "$c2_MenuFont" \
	-tearoff 0

    $w.menubutton8.m add command \
	-command {.aboutdialog popup} \
	-label {About CODE...}

    $w.menubutton8.m add command \
	-command {.faqdialog popup} \
	-label {CODE FAQ}

    # pack widget $w
    pack append $w \
	$w.menubutton2 {left frame center padx 5 fillx} \
	$w.menubutton3 {left frame center padx 5} \
	$w.menubutton4 {left frame center padx 5} \
	$w.menubutton6 {left frame center padx 5} \
	$w.menubutton8 {right frame center padx 5} \
	$w.menubutton5 {right frame center padx 5 fillx}

}

