#include <tcl.h>

#include "utils.h"


/* Utility functions for generating new UID's in the GUI. */

static int prime(unsigned x)
{
     unsigned i;

     for (i = (unsigned) 3; i * i <= x; i += (unsigned) 2) {
	 if ((x % i) == (unsigned) 0) {
	       return 0;
	 }
     }

     return 1;
}


/* Assume that x is at least 3. */
static unsigned next_prime(unsigned x)
{
    x += (unsigned) 2;
    while (!prime(x))
	x += (unsigned) 2;
    return x;
}


int
C2_next_prime(
   ClientData dummy,
   Tcl_Interp *interp,
   int argc,
   char *argv[])
{
  unsigned result, n;
  dummy = dummy; argc = argc;  /* silly code : eliminates compiler warning */

  /*
    argv[0]  next_prime
    argv[1]  unsigned integer
    */  

  sscanf(argv[1], "%d", &n);
  result = next_prime(n);

  sprintf(interp->result, "%d", result);
  return TCL_OK;
}
