#include <config.h>
#include "estring.h"

struct EStringThing 
{
 public:
   MString M;
   struct EStringThing *next;
   EStringThing( const MString& MO );
};

EStringThing::EStringThing( const MString& MO ) : M(MO) { next = 0; };

void EString::Append( EStringThing *EST )
{
   if (Head == 0) {
      Head = Tail = EST;
   } else {
      Tail->next = EST;
      Tail = EST;
   }
}

EString::EString() 
{
   Head = Tail = 0;
}

EString::EString( EString& E ) 
{
   Head = E.Head;
   Tail = E.Tail;
   E.Head = E.Tail = 0;
}

EString::EString( const EString& E ) 
{
   Head = E.Head;
   Tail = E.Tail;
   // E.Head = E.Tail = 0;
}

EString::EString( const MString& M ) 
{
   Head = Tail = 0;
   EStringThing *EST = new EStringThing(M);
   Append(EST);
} 

EString::EString( const char *s ) 
{
   Head = Tail = 0;
   EStringThing *EST = new EStringThing(MString(s));
   Append(EST);
} 

EString::EString( const char c ) 
{
   Head = Tail = 0;
   EStringThing *EST = new EStringThing(MString(c));
   Append(EST);
}

EString::EString( const int i) 
{
   Head = Tail = 0;
   EStringThing *EST = new EStringThing(MString(i));
   Append(EST);
}

void DeepFree( EString& E )
{
   EStringThing *ThisEST, *NextEST;

   ThisEST = E.Head;
   while (ThisEST != 0) {
      NextEST = ThisEST->next;
      delete ThisEST;
      ThisEST = NextEST;
   }; 
   E.Head = E.Tail = 0;  
}

EString::~EString()
{
   DeepFree(*this);
}

ostream& operator<< ( ostream& os, EString& es )
{
   EStringThing *ThisEST;

   for (ThisEST = es.Head; ThisEST != 0; ThisEST = ThisEST->next)
      os << ThisEST->M ;

   return os;
}


EString& 
EString::operator= ( EString& E )
{
   DeepFree(*this);

   Head = E.Head;
   Tail = E.Tail;
   E.Head = E.Tail = 0;

   return *this;
}

EString& 
EString::operator<< ( EString E )
{
   EString *BigDog;

   BigDog = ((EString *)&E);
   if (BigDog != ((EString *)0)) {  // CC compiler problem : E can be nil (but E.* refs works?)
      if (E.Head != 0) {
         if (Head == 0) {
            Head = E.Head;
            Tail = E.Tail;
         } else {
            Tail->next = E.Head;
            Tail = E.Tail;
         }
         E.Head = E.Tail = 0;
      }
   }

   return *this;
}


EString& 
EString::operator<< ( const MString& M )
{
   EStringThing *EST = new EStringThing(M);
   Append(EST);
   return *this;
}

EString& 
EString::operator<< ( const char *s )
{
   EStringThing *EST = new EStringThing(MString(s));
   Append(EST);
   return *this;
}

EString& 
EString::operator<< ( const char c )
{
   EStringThing *EST = new EStringThing(MString(c));
   Append(EST);
   return *this;
}

EString& 
EString::operator<< ( const int i )
{
   EStringThing *EST = new EStringThing(MString(i));
   Append(EST);
   return *this;
}
