#ifndef _estring_x
#define _estring_x

#include <string.h>
#include <stream.h>
#include "mstring.h"

struct EStringThing;

class EString
{
 private:
   struct EStringThing *Head, *Tail;
   void Append( EStringThing *EST);
   friend void DeepFree( EString& E );

 public:
   EString();
   EString( EString& E );               // destructive!!!
   EString( const EString& E );               // destructive!!!
   EString( const MString& M ); 
   EString( const char *s );
   EString( const char c );
   EString( const int i );
   ~EString();

   friend ostream& operator<< ( ostream& os, EString& es );

   EString& operator=  ( EString& E );  // destructive!!!
   EString& operator<< ( EString E );  // destructive!!!
   EString& operator<< ( const MString& M );
   EString& operator<< ( const char *s );
   EString& operator<< ( const char c );
   EString& operator<< ( const int i );  // convert int to string
};

// Expected Use
//   create one :                     
//     EString S;
//
//   add a a string to the end of it : 
//     S << '*' 
//       << " random string stuff" 
//       << Mstring(" more random stuff ") 
//       << EString(" even more useless stuff");
//
//   convert to (char *) string or defined a << operator for output :
//     cout << S;

// EString is a "temporary" string management class that is used during the 
// translation process.  I rationalize that this"temporary"-ness allows the self 
// concatenation to be destructive. 

#endif
