// fileutil.h

//   Misc. routines for file and directory manipulation.

#ifndef _fileutil_x
#define _fileutil_x

  // MakeSrcDir Creates a directory called dirname that has read, write,
  // and search permissions.  Returns 1 for success, 0 otherwise.  Does
  // nothing if directory is already there.

extern char  *TestDirectory;
int MakeSrcDir (char *dirname);

  // The following functions allow string key and value pairs to be
  // read from a configuration file in the user's home directory.
  // Configuration files must consist of lines of the form
  //    KEY = VALUE
  // where key is a string of letters and digits and VALUE is a string
  // of "graphic" characters, characters that are visible.  Each key-
  // value pair must be on a single line.  White space is allowed.
  // The config file has a fixed name, a #define in fileutil.C.

  // Call OpenConfigFile before trying to read key-value pairs. It returns
  // 1 upon success and 0 if the file cannot be opened.  It that case,
  // assume it is not there.

int OpenConfigFile();

  // Call CloseConfigFile when you are through readinf key-value pairs.

void CloseConfigFile();

  // GetKeyAndValue returns 1 if there is a key and value returned in its
  // arguments and a 0 if there is not.  Lines with syntax errors are
  // skipped.  A warning is written to stderr.  GetKeyAndValue overwrites
  // values of key and value from a previous call.

int GetKeyAndValue(char **Key, char **Value);

extern char codedir[];   // Path to code install directory
extern char pvmdir[];    // Path to pvm install directory

extern char sequentcc[];  // Path to sequent's cc
extern char sequentld[];  // Path to sequent's ld

extern char pvmcc[];  // Path to pvm's cc

extern char serialcc[];  // Path to serial's cc

extern char sparccc[];  // Path to sparc's cc
extern char sparcld[];  // Path to sparc's cc

extern char craycc[];  // Path to cray's cc
extern char crayld[];  // Path to cray's cc

#endif
