#include <config.h>
// Simple class for strings.  They never share storage.

#include <stdio.h>
#include <stdlib.h>

#include "mstring.h"

MString::MString ( void )
{
   len = 1;
   str = new char[1];
   str[0] = 0;
}

MString::MString ( const int i )
{
   char buf[32];

   sprintf(buf, "%d", i);
   len = strlen(buf);
   str = new char[len+1];
   strcpy(str, buf);
}


MString::MString ( const char c )
{
   str = new char[2];
   str[0] = c;
   str[1] = '\0';
}


MString::MString ( const char *s )
{
   len = strlen(s);
   str = new char[len+1];
   strcpy(str, s);
}

MString::MString ( const MString& s )
{
   len = s.len;
   str = new char[len+1];
   strcpy(str, s.str);
}


MString::~MString ( void )
{
   delete str;
}


MString MString::operator+ ( const int i )
{
   static MString t;
   static char NumBuf [24];

   sprintf(NumBuf, "%d", i);
   t.len = len + strlen(NumBuf);
   t.str = new char[t.len+1];
   strcpy(t.str, str);
   strcat(t.str, NumBuf);
   
   return t;
}


MString MString::operator+ ( const char c )
{
   static MString t;

   t.str = new char[len+2];
   strcpy(t.str, str);
   t.str[len] = c;
   t.str[len+1] = '\0';
   t.len = len + 1;
   
   return t;
}


MString MString::operator+ ( const char *s )
{
   static MString t;

   t.len = len + strlen(s);
   t.str = new char[t.len+1];
   strcpy(t.str, str);
   strcat(t.str, s);
   
   return t;
}


MString MString::operator+ ( const MString& s )
{
   static MString t;

   t.len = len + s.len;
   t.str = new char[t.len+1];
   strcpy(t.str, str);
   strcat(t.str, s.str);
   
   return t;
}


char MString::operator[] ( int i )
{
   if (i >= len) {
      cerr << "**** MString bounds error, index = " << i
           << ", len = " << len << "\n";
      exit(-1);
   }

   return str[i];
}


MString operator+ ( char *s1,  MString& s2)
{
   static MString t;

   t.len = strlen(s1) + s2.len;
   t.str = new char[t.len+1];
   strcpy(t.str, s1);
   strcat(t.str, s2.str);
   
   return t;
}



// Assignment ops

MString& MString::operator= ( const MString& s )
{

   if (&s != this) {
      len = s.len;
      delete str;
      str = new char[len+1];
      strcpy(str, s.str);
   }
   return *this;

}

MString& MString::operator= ( const char *s )
{
   len = strlen(s);
   delete str;  // delete the old one
   str = new char[len+1];
   strcpy(str, s);
   return *this;
}

// Relational ops

int MString::operator== ( const MString& s )
{
   return ( strcmp(str, s.str) == 0 );
}

int MString::operator!= ( const MString& s )
{
   return ( strcmp(str, s.str) != 0 );
}

int MString::operator< ( const MString& s )
{
   return ( strcmp(str, s.str) < 0 );
}

int MString::operator<= ( const MString& s )
{
   return ( strcmp(str, s.str) <= 0 );
}

int MString::operator> ( const MString& s )
{
   return ( strcmp(str, s.str) > 0 );
}

int MString::operator>= ( const MString& s )
{
   return ( strcmp(str, s.str) >=  0 );
}

#if 0
int MString::operator== ( const char *s )
{
   return ( strcmp(str, s) == 0 );
}
#endif

#if 0
int MString::operator!= ( const char *s )
{
   return ( strcmp(str, s) != 0 );
}
#endif

int MString::operator< ( const char *s )
{
   return ( strcmp(str, s) < 0 );
}

int MString::operator<= ( const char *s )
{
   return ( strcmp(str, s) <= 0 );
}

int MString::operator> ( const char *s )
{
   return ( strcmp(str, s) > 0 );
}

int MString::operator>= ( const char *s )
{
   return ( strcmp(str, s) >=  0 );
}

// I/O ops

istream& operator>> ( istream& is, MString& s )
{
   char inBuf[128];    // Watch out for this.

   is >> inBuf;
   s = inBuf;

   return is;
}


// Misc ops

int MString::length ( void )
{
   return strlen(str);
}


// Generate unique strings.

static int GenSymCounter = 0;


MString &GenSym()
{
   static char buf[32];

   sprintf(buf, "_c2_g%d", GenSymCounter);
   GenSymCounter += 1;

   return *(new MString((char *) buf));
}


  // Initialize GenSyms' counter.

void GenSymInit(int c)
{
   GenSymCounter = c;
}


ostream& operator<< ( ostream& os, const MString& s )
{
   return (os << s.str);
}


 int operator== ( char *s1, MString& s2 )
 {
    return (strcmp(s1, s2.str) == 0);
 }


int operator!= ( char *s1, MString& s2 )
{
   return (strcmp(s1, s2.str) != 0);
}

