// Simple class for dealing with strings.

// Assumes you have a _new_handler for errors.

#ifndef _mstring_x
#define _mstring_x

#include <stream.h>
#include <string.h>

class MString {
   friend ostream& operator<< ( ostream& os, const MString& s );
   friend istream& operator>> ( istream& is, MString& s );
   friend MString operator+ ( char *s1, MString& s2);
   friend int operator== ( char *s1, MString& s2 );
   friend int operator!= ( char *s1, MString& s2 );
 public:
   MString ( void );
   MString ( const int i );
   MString ( const char c );
   MString ( const char *s );
   MString ( const MString& s );
   ~MString ( void );
   operator char* () { return str; }
   int length ( void );
   MString& operator= ( const MString& s);
   MString& operator= ( const char *s);
   MString operator+ (  const int i );
   MString operator+ (  const char c );
   MString operator+ (  const char *s);
   MString operator+ (  const MString& s);
   char operator[] ( int i );
   int operator== ( const MString& s);
   int operator!= ( const MString& s);
   int operator<= ( const MString& s);
   int operator< ( const MString& s);
   int operator>= ( const MString& s);
   int operator> ( const MString& s);
   int operator!= ( const char *s);
   int operator<= ( const char *s);
   int operator< ( const char *s);
   int operator>= ( const char *s);
   int operator> ( const char *s);
 private:
   int len;
   char *str;
};


  // Return a unique MString.

MString &GenSym();

  // Initialize GenSyms' counter.  Need to call this before using GenSym.

void GenSymInit(int c);


#endif
