#include <config.h>
#include "sfile.h"
#include "general.h"


static int BlockLessThan(void *v1, void *v2)
{
   if ( ((cBlock *) v1)->ID < ((cBlock *) v2)->ID )
     return 1;
   else
     return 0;
}


cBlock::cBlock(cBlock *InitParent, int InitID)
{
   Parent = InitParent;
   ID = InitID;
   UseIndex = 0;
}


cBlock::cBlock(cBlock *InitParent, int InitID, int InitIndex)
{
   Parent = InitParent;
   ID = InitID;
   Index = InitIndex;
   UseIndex = 1;
}


cBlock::~cBlock()
{
   cBlock *b;

   while (!SubBlocks.Empty()) {
      b = (cBlock *) SubBlocks.PopFirst();
      delete b;
   }

}


void cBlock::Output(ofstream &os)
{
   cBlock *b;
   void *v;
   VLIterator i;

   os << Text;

   for (v = i.Init(SubBlocks); i.MoreLeft(); v = i.Next()) {
      b = (cBlock *) v;
      b->Output(os);
   }
}


void cBlock::DumpID()
{
   cBlock *b;
   void *v;
   VLIterator i;

   cout << " " << ID << ":(";

   for (v = i.Init(SubBlocks); i.MoreLeft(); v = i.Next()) {
      b = (cBlock *) v;
      b->DumpID();
   }
   cout << " )";
}


void cBlock::PrintPath()
{
   if (Parent == 0) {
      cout << ID;
      if (UseIndex)
	cout << "[" << Index << "]\n";
      else
	cout << "\n";
   } else {
      cout << ID;
      if (UseIndex)
	cout << "[" << Index << "] -> ";
      else
	cout << " -> ";
      Parent->PrintPath();
   }
}     
   

void InitCursor(int ID)
{
  cCursor::Root = new cBlock(0,ID);
}


cCursor::cCursor()
{
   Current = Root;
}


void cCursor::cd()
{
   Current = Root;
}


void cCursor::cd(int ID)
{
   cBlock *b;
   void *v;
   VLIterator i;

   // Search for child with correct ID.

   for (v = i.Init(Current->SubBlocks); i.MoreLeft(); v = i.Next()) {
      b = (cBlock *) v;
      if (b->ID == ID && b->UseIndex == 0) {  // cd to this one!
	 Current = b;
	 return;
      }
   }

   // Did not find it, so we create it.

   b = new cBlock(Current, ID);
   Current->SubBlocks.SortInsert(b, BlockLessThan);
   Current = b;

   return;
   
}


void cCursor::cd(int ID, int Index)
{
   cBlock *b;
   void *v;
   VLIterator i;

   // Search for child with correct ID and Index.

   for (v = i.Init(Current->SubBlocks); i.MoreLeft(); v = i.Next()) {
      b = (cBlock *) v;
      if (b->ID == ID && b->Index == Index && b->UseIndex == 1) {
	 Current = b;
	 return;
      }
   }

   // Did not find it, so we create it.

   b = new cBlock(Current, ID, Index);
   Current->SubBlocks.SortInsert(b, BlockLessThan);
   Current = b;

   return;
   
}


void cCursor::up()
{
   if (Current->Parent != 0)
     Current = Current->Parent;

   return;
}


void cCursor::pwd()
{
   Current->PrintPath();
}


cBlock *cCursor::RootBlock()
{
   return Root;
}
