#include <config.h>
#include "voidlist.h"
#include "general.h"

// Basic list manipulation classes

VoidList::~VoidList()
{
   this->Destroy();
}

void *VoidList::First()
{
   if (this->Empty())
     Die("\nError: attempt to access first elmt of empty list\n");

   return Start->Val;
}


void *VoidList::Last()
{
   if (this->Empty())
      Die("\nError: attempt to access last elmt of empty list\n");

   return End->Val;
}


void *VoidList::Nth(int n)
{
   int i;
   VLLink *pt;

   if (n >= Count)
      Die("\nError: attempt to access Nth elmt out of range\n");

   pt = Start;
   for (i=0; i<n; i++) pt = pt->Next;
   return pt->Val;
}


// add item to the front of the list

void VoidList::Insert (void *Val)
{
   VLLink *pt = new VLLink(Val);

   if (Start == 0) End = pt;
   pt->Next = Start;
   Start = pt;
   Count += 1;
}


// add item to end of the list

void VoidList::Append(void *Val)
{
   VLLink *pt = new VLLink(Val);

   pt->Next = 0;
   if (Start == 0)
      Start = pt;
   else
      End->Next = pt;
   End = pt;
   Count += 1;
}


void VoidList::SortInsert(void *Val, int (lt) (void *v1, void* v2))
{
   VLLink *newone = new VLLink(Val);
   VLLink *cur, *prev;

   // Find link that new one must come before

   cur = Start;
   while (cur != 0) {
      if (lt(newone->Val, cur->Val)) break;
      prev = cur;
      cur = cur->Next;
   }

   if (Start == 0) {  // New is only in List
      Start = newone;
      End = newone;  
      newone->Next = 0;
   } else if (cur == Start) {  // New first in non-empty list
      newone->Next = cur;
      Start = newone;
   } else if (cur == 0) {  // New last in non-empty list
      newone->Next = cur;
      prev->Next = newone;
      End = newone;
   } else {  // New in middle someplace
      newone->Next = cur;
      prev->Next = newone;
   }

   Count += 1;
}



// Remove items that are eq in the Lisp sense to the argument.  eq
// means "points to the same object". Return NumDeleted.

int VoidList::RemEq(void *Val)
{
   int NumDeleted = 0, Len, i;
   VLLink *pt, *pt_prev, *tmp;

   Len = Count;
   pt = Start;
   pt_prev = 0;
   for (i=0; i< Len; i++)
     if (pt->Val == Val) {     // delete this one
	if (pt == Start) Start = pt->Next;
	if (pt == End) End = pt_prev;
	if (pt_prev != 0) pt_prev->Next = pt->Next;
	tmp = pt;
	pt = pt->Next;
	NumDeleted += 1;
        Count -= 1;
	delete tmp;
     }
     else {
	pt_prev = pt;
        pt = pt->Next;
     }
   
   return NumDeleted;
}


void *VoidList::PopFirst()
{
   VLLink *tmp;
   void *Val;

   if (Start == 0)
      Die("\nError: attempt to PopFirst from empty list\n");

   tmp = Start;
   if (End == Start) End = 0;
   Start = Start->Next;
   Val = tmp->Val;
   delete tmp;
   Count -= 1;

   return Val;
}
   
void *VoidList::PopLast()
{
   VLLink *NextToLast, *tmp;
   void *Val;

   if (Start == 0)
      Die("\nError: attempt to PopLast from empty list\n");

   tmp = Start;
   NextToLast = 0;
   while (tmp->Next != 0) {
      NextToLast = tmp;
      tmp = tmp->Next;
   }

   tmp = End;
   if (Start == End)
     Start = 0;
   else
     NextToLast->Next = 0;
   End = NextToLast;
   Val = tmp->Val;
   delete tmp;
   Count -= 1;

   return Val;
}


void VoidList::Destroy()
{
   VLLink *pt, *tmp;

   pt = Start;
   while (pt != 0) {
      tmp = pt;
      pt = pt->Next;
      delete tmp;
   }
   Start = 0;
   End = 0;
   Count = 0;
}


void VoidList::ConCat(VoidList &L)
{
   // Add L's members to list
   if (Start == 0) {
      Start =  L.Start;
      End = L.End;
      Count = L.Count;
   } else {
      End->Next = L.Start;
      End = L.End;
      Count += L.Count;
   }

   // Make L the empty List
   L.Start = 0;
   L.End = 0;
   L.Count = 0;

}


void *VLIterator::Init(VoidList &x)
{
   if (x.Start == 0) {
      Current = 0;
      return 0;
   }
   Current = x.Start;
   return Current->Val;
}


void *VLIterator::Next()
{

   Current = Current->Next;
   if (Current == 0) {
      return 0;
   }
   return Current->Val;
}
