#ifndef _voidlist_x
#define _voidlist_x


// void Insert (void *Val)
//   Insert node at front of list.

// void Append (void *val)
//   Append node at tail of list.

// void SortInsert(void *Val, int (lt) (void *v1, void* v2));

// int Length()
//   Return length of list.

// void *First();
//   Return first element in list.

// void *Last();
//   Return last element in list.

// void *Nth(int n);
//   Return Nth element in list (starting count at 0).

// int Empty()
//   Return non-zero Iff list is empty.

// int RemEq(void *Val)
//   Remove items that are eq in the Lisp sense (point to same object)
//   to Val.

// void *PopFirst()
//   Reomve and return first element in list.

// void *PopLast()
//   Reomve and return last element in list.

// void Destroy()
//   Delete all storage allocated by the list.  This does NOT delete
//   the Object nodes in the list.  Result is an empty list.

// void ConCat(cObList &L)
//   Adds L's list members to the end of the list.  L becomes the empty list.

// See file testtree.C for usage examples.

// ************************************************************************


class VoidList;
class VLIterator;

class VLLink {
   friend class VoidList;
   friend class VLIterator;
 private:
   VLLink (void *v=0) { Val = v; Next = 0; }
   VLLink *Next;
   void *Val;
};

class VoidList {
   friend class VLIterator;
 private:
   int Count;
   VLLink *Start;
   VLLink *End;
 public:
   VoidList () { Start = 0; End = 0; Count = 0; }
   ~VoidList();    // Frees links but not objects in list.
   void Insert (void *Val);
   void Append (void *val);
   void SortInsert(void *Val, int (lt) (void *v1, void* v2));
   int Length() { return Count; }
   void *First();
   void *Last();
   void *Nth(int n);
   int Empty() { return Start == 0; }
   int RemEq(void *Val);
   void *PopFirst();
   void *PopLast();
   void Destroy();
   void ConCat(VoidList &L);
};

class VLIterator {
  public:
   VLIterator() { Current = 0; }
   void *Init(VoidList &x);
   int MoreLeft() { return Current != 0; }
   void *Next();
   VLLink *Current;
};


#endif
