#include <stdio.h>
# define U(x) x
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# define YYLMAX BUFSIZ
#ifndef __cplusplus
# define output(c) (void)putc(c,yyout)
#else
# define lex_output(c) (void)putc(c,yyout)
#endif

#if defined(__cplusplus) || defined(__STDC__)

#if defined(__cplusplus) && defined(__EXTERN_C__)
extern "C" {
#endif
	int yyback(int *, int);
	int yyinput(void);
	int yylook(void);
	void yyoutput(int);
	int yyracc(int);
	int yyreject(void);
	void yyunput(int);
	int yylex(void);
#ifdef YYLEX_E
	void yywoutput(wchar_t);
	wchar_t yywinput(void);
#endif
#ifndef yyless
	int yyless(int);
#endif
#ifndef yywrap
	int yywrap(void);
#endif
#ifdef LEXDEBUG
	void allprint(char);
	void sprint(char *);
#endif
#if defined(__cplusplus) && defined(__EXTERN_C__)
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
	void exit(int);
#ifdef __cplusplus
}
#endif

#endif
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
#ifndef __cplusplus
# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
#else
# define lex_input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
#endif
#define ECHO fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng;
char yytext[YYLMAX];
int yymorfg;
extern char *yysptr, yysbuf[];
int yytchar;
FILE *yyin = {stdin}, *yyout = {stdout};
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;

# line 2 "scan.l"
/* scanner for CODE */

#include <stdio.h>
#include <stdlib.h>
#include "y.tab.h"
#include "../misc/general.h"
#include "../exmodel/abstree.h"
#include "../exmodel/exmodel.h"
#include "parser.h"
#include "scan.h"
#include <string.h>

extern cAbsTree *yylval;     /* Value of token for yacc++ */

static char *cpstr(char *s);
static void count();
#ifndef yyerror
        void yyerror(const char *s);
#endif

#undef lex_input
#undef unput

# define YYNEWLINE 10
yylex(){
int nstr; extern int yyprevious;
#ifdef __cplusplus
/* to avoid CC and lint complaining yyfussy not being used ...*/
static int __lex_hack = 0;
if (__lex_hack) goto yyfussy;
#endif
while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:

# line 34 "scan.l"
		{ count(); return '%'; }
break;
case 2:

# line 35 "scan.l"
		{ count(); return '!'; }
break;
case 3:

# line 36 "scan.l"
		{ count(); return '-'; }
break;
case 4:

# line 37 "scan.l"
		{ count(); return '['; }
break;
case 5:

# line 38 "scan.l"
		{ count(); return ']'; }
break;
case 6:

# line 39 "scan.l"
		{ count(); return '<'; }
break;
case 7:

# line 40 "scan.l"
		{ count(); return '>'; }
break;
case 8:

# line 41 "scan.l"
		{ count(); return '.'; }
break;
case 9:

# line 42 "scan.l"
		{ count(); return ','; }
break;
case 10:

# line 44 "scan.l"
		{ count(); return '{'; }
break;
case 11:

# line 45 "scan.l"
		{ count(); return '}'; }
break;
case 12:

# line 46 "scan.l"
		{ count(); return ';'; }
break;
case 13:

# line 47 "scan.l"
		{ count(); return '('; }
break;
case 14:

# line 48 "scan.l"
		{ count(); return ')'; }
break;
case 15:

# line 49 "scan.l"
		{ count(); return '*'; }
break;
case 16:

# line 50 "scan.l"
		{ count(); return '+'; }
break;
case 17:

# line 51 "scan.l"
		{ count(); return '='; }
break;
case 18:

# line 52 "scan.l"
		{ count(); return ':'; }
break;
case 19:

# line 53 "scan.l"
		{ count(); return '/'; }
break;
case 20:

# line 55 "scan.l"
		{ count(); return(CONS); }
break;
case 21:

# line 56 "scan.l"
		{ count(); return(PROD); }
break;
case 22:

# line 57 "scan.l"
		{ count(); return(LE_OP); }
break;
case 23:

# line 58 "scan.l"
		{ count(); return(GE_OP); }
break;
case 24:

# line 59 "scan.l"
		{ count(); return(EQ_OP); }
break;
case 25:

# line 60 "scan.l"
		{ count(); return(NE_OP); }
break;
case 26:

# line 61 "scan.l"
		{ count(); return(AND_OP); }
break;
case 27:

# line 62 "scan.l"
		{ count(); return(OR_OP); }
break;
case 28:

# line 64 "scan.l"
		{ count(); return(NEW); }
break;
case 29:

# line 65 "scan.l"
		{ count(); return(VOID); }
break;
case 30:

# line 66 "scan.l"
		{ count(); return(IF); }
break;
case 31:

# line 67 "scan.l"
		{ count(); return(ELSE); }
break;
case 32:

# line 68 "scan.l"
		{ count(); return(WHILE); }
break;
case 33:

# line 69 "scan.l"
		{ count(); return(IS); }
break;
case 34:

# line 70 "scan.l"
		{ count(); return(OF); }
break;
case 35:

# line 71 "scan.l"
	{ count(); return(SHARED_VAR); }
break;
case 36:

# line 72 "scan.l"
		{ count(); return(VAR); }
break;
case 37:

# line 73 "scan.l"
		{ count(); return(TYPE); }
break;
case 38:

# line 74 "scan.l"
		{ count(); return(ARRAY); }
break;
case 39:

# line 75 "scan.l"
		{ count(); return(COMP); }
break;
case 40:

# line 76 "scan.l"
	{ count(); return(INITCOMP); }
break;
case 41:

# line 77 "scan.l"
	{ count(); return(INPUTRULES); }
break;
case 42:

# line 78 "scan.l"
	{ count(); return(OUTPUTRULES); }
break;
case 43:

# line 79 "scan.l"
	{ count(); return(INPUTPORTS); }
break;
case 44:

# line 80 "scan.l"
	{ count(); return(OUTPUTPORTS); }
break;
case 45:

# line 81 "scan.l"
	{ count(); return(READER); }
break;
case 46:

# line 82 "scan.l"
	{ count(); return WRITER; }
break;
case 47:

# line 83 "scan.l"
	{ count(); return(STRUCT); }
break;
case 48:

# line 84 "scan.l"
	{ count(); return(QQFUNCSIG); }
break;
case 49:

# line 85 "scan.l"
	{ count(); return(QQARCTOPO); }
break;
case 50:

# line 86 "scan.l"
		{ count(); return(QQUC); }
break;
case 51:

# line 87 "scan.l"
	{ count(); return(QQNSICOMP); }
break;
case 52:

# line 88 "scan.l"
	{ count(); return(QQTYPEDEF); }
break;
case 53:

# line 89 "scan.l"
	{ count(); return(QQEXPR); }
break;
case 54:

# line 90 "scan.l"
	{ count(); return(PARTITION); }
break;
case 55:

# line 91 "scan.l"
	        { count(); return(MERGE); }
break;
case 56:

# line 92 "scan.l"
	{ count(); return(EXPAND); }
break;
case 57:

# line 93 "scan.l"
	{ count(); return(CONTRACT); }
break;
case 58:

# line 94 "scan.l"
	{ count(); return(STRIP_UPDATE); }
break;
case 59:

# line 95 "scan.l"
 		{ count(); return(ALIGN); }
break;
case 60:

# line 96 "scan.l"
         	{ count(); return(BLOCK); }
break;
case 61:

# line 97 "scan.l"
	{ count(); return(CYCLIC); }
break;
case 62:

# line 98 "scan.l"
	{ count(); return(BLOCK-CYCLIC); }
break;
case 63:

# line 99 "scan.l"
	{ count(); return(OVERLAP); }
break;
case 64:

# line 100 "scan.l"
	{ count(); return(SUMMARY); }
break;
case 65:

# line 102 "scan.l"
	{ count(); 
			  yylval = new cRealConst(atof(yytext));
			  return(REALCONST); }
break;
case 66:

# line 106 "scan.l"
		{ count();
			  yylval = new cIntConst(atoi(yytext));
			  return(INTCONST); }
break;
case 67:

# line 110 "scan.l"
{ count();
			  yylval = (cAbsTree *) cpstr(yytext);
			  return(IDENT); }
break;
case 68:

# line 114 "scan.l"
		{ count();  /* ignore comments */ }
break;
case 69:

# line 115 "scan.l"
	{ count(); }
break;
case 70:

# line 117 "scan.l"
		{ count(); return(WRONG); }
break;
case -1:
break;
default:
(void)fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */

static int yyecho = 1;    /* if true produce listing to stdout */
int yycolumn;
int yylinenum;


static void count()
{
   int i;

   for (i = 0; yytext[i] != '\0'; i++)
     if (yytext[i] == '\n') {
       yylinenum += 1;
       yycolumn = 0;
    }
     else if (yytext[i] == '\t')
       yycolumn += 8 - (yycolumn % 8);
     else
       yycolumn++;

   if (yyecho) ECHO;

}


#ifndef yyerror
void yyerror (const char *s)
{
   if (yyecho) {
      printf("\n ** At line %d, col %d... %s\n", yylinenum, yycolumn, s);
      fflush(stdout);
   }
}
#endif

yywrap()
{
        return(1);
}

#include <strings.h>

static char *bp;
static char *bufstart;
static char *codebp;
static char *codebufstart;
static int InCodeString;
static char yyCode[32];

// Functions below are to allow the parser to read from this "string"
// consisting of the code string followed by the data.  Weird stuff.

void yyset_input(char *code, char *buf, int DoListing)
{
   extern int yyprevious;

   yycolumn = 0;
   yylinenum = 0;
   yyecho = DoListing;
   InCodeString = 1;

   codebp = strcpy(yyCode, code);
   codebp = strcat(yyCode, "\n");
   codebufstart = yyCode;

   bp = buf;
   bufstart = buf;
#if 0
   NLSTATE;         /* Tell parser it is at beginning of line */
#endif
}

int lex_input()
{
   char ch;

   if (InCodeString) {
      ch = *codebp;
      ++codebp;
      if (*codebp == '\0') {
	 InCodeString = 0;
	 --codebp;
      }
   } else
     if (ch = *bp) ++bp;

   return ch;
}


unput(int ch)
{

   if (ch == '\0') return 0;

   if (InCodeString) {
      --codebp;
      if (*codebp != ch) Die("unput the wrong char in code!\n");
      if (codebp < codebufstart) Die("unput past starting point in code!\n");
   } else {
      if (bp > bufstart) {
	 --bp;
	 if (*bp != ch) Die("unput the wrong char!\n");
      } else
	InCodeString = 1;
   }

   return 1; /* Silence the "no return value" warning */
}



  // Copy string out of yytext into static storage.  This is yet another
  // memory leak since these are just copied into an MString, but there
  // is no easy way to fix it.

static char *cpstr(char *s)
{
   char* strbuf;

   strbuf = new char[strlen(s)+1];

   strcpy(strbuf, s);
   return strbuf;
}
int yyvstop[] = {
0,

70,
0,

69,
70,
0,

69,
0,

2,
70,
0,

1,
70,
0,

70,
0,

13,
70,
0,

14,
70,
0,

15,
70,
0,

16,
70,
0,

9,
70,
0,

3,
70,
0,

8,
65,
70,
0,

19,
70,
0,

66,
70,
0,

18,
70,
0,

12,
70,
0,

6,
70,
0,

17,
70,
0,

7,
70,
0,

67,
70,
0,

67,
70,
0,

67,
70,
0,

67,
70,
0,

67,
70,
0,

67,
70,
0,

67,
70,
0,

67,
70,
0,

67,
70,
0,

4,
70,
0,

5,
70,
0,

67,
70,
0,

67,
70,
0,

67,
70,
0,

67,
70,
0,

67,
70,
0,

67,
70,
0,

67,
70,
0,

67,
70,
0,

67,
70,
0,

67,
70,
0,

67,
70,
0,

67,
70,
0,

67,
70,
0,

10,
70,
0,

70,
0,

11,
70,
0,

25,
0,

26,
0,

20,
0,

65,
0,

68,
0,

66,
0,

21,
0,

22,
0,

24,
0,

23,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

30,
67,
0,

67,
0,

33,
67,
0,

67,
0,

34,
67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

27,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

28,
67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

39,
67,
0,

31,
67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

50,
67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

37,
67,
0,

36,
67,
0,

29,
67,
0,

67,
0,

67,
0,

59,
67,
0,

60,
67,
0,

67,
0,

67,
0,

67,
0,

55,
67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

38,
67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

32,
67,
0,

67,
0,

67,
0,

61,
67,
0,

67,
0,

56,
67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

53,
67,
0,

67,
0,

67,
0,

67,
0,

45,
67,
0,

67,
0,

67,
0,

47,
67,
0,

46,
67,
0,

67,
0,

67,
0,

63,
67,
0,

67,
0,

64,
67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

57,
67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

54,
67,
0,

67,
0,

40,
67,
0,

67,
0,

67,
0,

49,
67,
0,

48,
67,
0,

51,
67,
0,

52,
67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

67,
0,

43,
67,
0,

67,
0,

67,
0,

35,
67,
0,

62,
67,
0,

58,
0,

41,
67,
0,

44,
67,
0,

67,
0,

42,
67,
0,
0};
# define YYTYPE int
struct yywork { YYTYPE verify, advance; } yycrank[] = {
0,0,	0,0,	1,3,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	1,4,	1,5,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	1,6,	0,0,	
0,0,	0,0,	1,7,	1,8,	
8,51,	1,9,	1,10,	1,11,	
1,12,	1,13,	1,14,	1,15,	
1,16,	1,17,	16,54,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	1,18,	
1,19,	1,20,	1,21,	1,22,	
6,50,	14,52,	1,23,	1,24,	
1,25,	1,26,	1,27,	1,26,	
1,26,	1,26,	1,26,	1,26,	
1,26,	1,26,	1,28,	1,26,	
1,29,	1,30,	1,26,	1,26,	
1,31,	1,26,	1,26,	1,26,	
1,26,	1,26,	1,26,	1,26,	
1,32,	21,58,	1,33,	22,59,	
1,26,	0,0,	1,34,	1,26,	
1,35,	1,26,	1,36,	1,37,	
1,26,	1,26,	1,38,	1,26,	
1,26,	1,26,	1,26,	1,39,	
1,40,	1,26,	1,41,	1,42,	
1,43,	1,44,	1,26,	1,45,	
1,46,	1,26,	1,26,	1,26,	
1,47,	1,48,	1,49,	2,6,	
0,0,	0,0,	0,0,	2,7,	
2,8,	0,0,	2,9,	2,10,	
2,11,	2,12,	2,13,	2,14,	
2,15,	2,16,	15,53,	15,53,	
15,53,	15,53,	15,53,	15,53,	
15,53,	15,53,	15,53,	15,53,	
2,18,	2,19,	2,20,	2,21,	
2,22,	24,62,	26,60,	36,73,	
2,24,	2,25,	2,26,	2,27,	
2,26,	2,26,	2,26,	2,26,	
2,26,	2,26,	2,26,	2,28,	
2,26,	2,29,	2,30,	2,26,	
2,26,	2,31,	2,26,	2,26,	
2,26,	2,26,	2,26,	2,26,	
2,26,	2,32,	48,91,	2,33,	
60,60,	24,60,	75,60,	2,34,	
2,26,	2,35,	2,26,	2,36,	
2,37,	2,26,	2,26,	2,38,	
2,26,	2,26,	2,26,	2,26,	
2,39,	2,40,	2,26,	2,41,	
2,42,	2,43,	2,44,	2,26,	
2,45,	2,46,	2,26,	2,26,	
2,26,	2,47,	2,48,	2,49,	
17,53,	20,56,	17,55,	17,55,	
17,55,	17,55,	17,55,	17,55,	
17,55,	17,55,	17,55,	17,55,	
25,63,	64,60,	77,60,	64,95,	
27,60,	20,57,	23,60,	23,60,	
23,60,	23,60,	23,60,	23,60,	
23,60,	23,60,	23,60,	23,60,	
27,65,	35,60,	37,74,	25,60,	
35,72,	37,60,	25,64,	23,60,	
23,60,	23,60,	23,60,	23,60,	
23,60,	23,60,	23,60,	23,60,	
23,60,	23,60,	23,60,	23,60,	
23,60,	23,60,	23,60,	23,60,	
23,60,	23,60,	23,60,	23,60,	
23,60,	23,60,	23,60,	23,60,	
23,60,	41,60,	70,60,	70,101,	
79,60,	23,60,	41,81,	23,60,	
23,60,	23,60,	23,60,	23,60,	
23,60,	23,60,	23,60,	23,60,	
23,60,	23,60,	23,61,	23,60,	
23,60,	23,60,	23,60,	23,60,	
23,60,	23,60,	23,60,	23,60,	
23,60,	23,60,	23,60,	23,60,	
23,60,	28,66,	29,67,	30,68,	
31,60,	34,60,	43,84,	63,94,	
28,60,	38,75,	43,60,	34,71,	
31,69,	31,70,	30,60,	38,60,	
39,78,	38,76,	43,85,	40,79,	
42,82,	45,87,	38,77,	39,60,	
29,60,	40,60,	44,60,	42,60,	
61,92,	62,93,	42,83,	61,60,	
45,60,	46,89,	40,80,	45,88,	
54,54,	46,60,	65,60,	44,86,	
66,60,	67,98,	65,96,	46,90,	
54,54,	54,0,	66,97,	68,60,	
63,60,	69,60,	71,60,	72,60,	
72,103,	68,99,	73,60,	69,100,	
71,102,	74,60,	62,60,	76,106,	
78,60,	73,104,	76,60,	74,105,	
80,60,	81,110,	76,107,	93,126,	
82,116,	81,111,	81,112,	78,108,	
80,109,	83,60,	88,122,	84,118,	
81,60,	88,60,	81,113,	82,60,	
67,60,	85,60,	83,117,	54,54,	
81,114,	81,115,	84,60,	85,119,	
86,60,	87,60,	89,123,	90,124,	
86,120,	89,60,	90,60,	87,121,	
92,125,	94,127,	95,60,	96,129,	
54,54,	92,60,	97,130,	99,60,	
102,135,	98,131,	95,128,	97,60,	
93,60,	100,133,	96,60,	99,132,	
100,60,	101,60,	101,134,	102,60,	
103,60,	104,137,	105,138,	106,60,	
103,136,	105,60,	108,60,	107,60,	
104,60,	123,155,	111,60,	106,139,	
110,60,	94,60,	54,54,	98,60,	
107,140,	109,60,	110,142,	112,60,	
113,60,	109,141,	111,143,	114,60,	
115,147,	118,60,	116,148,	113,145,	
112,144,	117,60,	119,60,	118,150,	
122,154,	115,60,	116,60,	120,152,	
114,146,	117,149,	121,60,	119,151,	
122,60,	124,60,	120,60,	126,158,	
125,60,	121,153,	125,157,	127,159,	
128,60,	124,156,	129,60,	130,162,	
129,161,	131,163,	128,160,	134,166,	
132,164,	133,60,	130,60,	132,60,	
135,60,	133,165,	136,60,	137,60,	
139,169,	138,60,	134,60,	138,168,	
147,60,	152,60,	140,60,	141,60,	
142,172,	135,167,	151,180,	143,60,	
126,60,	139,60,	140,170,	143,173,	
141,171,	142,60,	127,60,	151,60,	
144,60,	131,60,	144,174,	145,175,	
146,60,	148,177,	145,60,	149,178,	
146,176,	150,179,	149,60,	153,60,	
148,60,	154,60,	155,181,	156,182,	
150,60,	157,60,	158,183,	159,184,	
161,186,	155,60,	156,60,	160,185,	
162,60,	163,187,	165,189,	164,60,	
161,60,	167,60,	166,60,	158,60,	
168,191,	169,192,	160,60,	164,188,	
166,190,	168,60,	170,193,	171,60,	
172,60,	174,197,	169,60,	173,60,	
175,198,	176,199,	181,60,	171,194,	
172,195,	173,196,	174,60,	170,60,	
176,60,	175,60,	178,60,	177,60,	
178,201,	179,202,	180,60,	183,205,	
159,60,	177,200,	184,60,	182,60,	
185,206,	179,60,	180,203,	186,60,	
163,60,	182,204,	187,207,	188,208,	
189,209,	185,60,	188,60,	190,60,	
192,60,	191,211,	193,60,	192,212,	
194,214,	195,60,	193,213,	196,60,	
195,215,	197,60,	200,60,	199,218,	
190,210,	165,60,	191,60,	198,60,	
197,216,	194,60,	198,217,	199,60,	
201,219,	202,220,	187,60,	203,60,	
183,60,	201,60,	204,60,	205,221,	
206,60,	207,60,	208,60,	209,224,	
210,60,	208,223,	202,60,	211,60,	
206,222,	212,60,	212,226,	213,60,	
214,60,	211,225,	213,227,	215,60,	
214,228,	216,230,	205,60,	215,229,	
216,60,	217,60,	217,231,	218,232,	
219,233,	220,60,	221,235,	222,60,	
224,237,	223,60,	218,60,	223,236,	
225,60,	227,60,	226,60,	220,234,	
235,248,	219,60,	226,239,	227,240,	
228,60,	225,238,	229,60,	228,241,	
230,243,	229,242,	231,60,	232,245,	
233,60,	230,60,	231,244,	234,247,	
236,60,	232,60,	233,246,	237,249,	
238,250,	239,60,	240,60,	241,60,	
242,60,	243,60,	234,60,	244,60,	
245,60,	241,252,	240,251,	221,60,	
235,60,	246,60,	247,60,	248,255,	
249,256,	250,257,	251,60,	252,60,	
247,254,	253,260,	246,253,	254,60,	
250,60,	251,258,	255,262,	252,259,	
256,263,	257,60,	254,261,	258,60,	
259,60,	260,266,	261,60,	262,60,	
257,264,	264,60,	265,60,	259,265,	
260,60,	266,60,	267,60,	0,0,	
0,0,	0,0,	0,0,	0,0,	
266,267,	0,0,	248,60,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	255,60,	
0,0};
struct yysvf yysvec[] = {
0,	0,	0,
yycrank+-1,	0,		0,	
yycrank+-94,	yysvec+1,	0,	
yycrank+0,	0,		yyvstop+1,
yycrank+0,	0,		yyvstop+3,
yycrank+0,	0,		yyvstop+6,
yycrank+3,	0,		yyvstop+8,
yycrank+0,	0,		yyvstop+11,
yycrank+2,	0,		yyvstop+14,
yycrank+0,	0,		yyvstop+16,
yycrank+0,	0,		yyvstop+19,
yycrank+0,	0,		yyvstop+22,
yycrank+0,	0,		yyvstop+25,
yycrank+0,	0,		yyvstop+28,
yycrank+3,	0,		yyvstop+31,
yycrank+94,	0,		yyvstop+34,
yycrank+3,	0,		yyvstop+38,
yycrank+174,	0,		yyvstop+41,
yycrank+0,	0,		yyvstop+44,
yycrank+0,	0,		yyvstop+47,
yycrank+176,	0,		yyvstop+50,
yycrank+32,	0,		yyvstop+53,
yycrank+34,	0,		yyvstop+56,
yycrank+190,	0,		yyvstop+59,
yycrank+81,	yysvec+23,	yyvstop+62,
yycrank+143,	yysvec+23,	yyvstop+65,
yycrank+50,	yysvec+23,	yyvstop+68,
yycrank+128,	yysvec+23,	yyvstop+71,
yycrank+212,	yysvec+23,	yyvstop+74,
yycrank+228,	yysvec+23,	yyvstop+77,
yycrank+218,	yysvec+23,	yyvstop+80,
yycrank+208,	yysvec+23,	yyvstop+83,
yycrank+0,	0,		yyvstop+86,
yycrank+0,	0,		yyvstop+89,
yycrank+209,	yysvec+23,	yyvstop+92,
yycrank+141,	yysvec+23,	yyvstop+95,
yycrank+51,	yysvec+23,	yyvstop+98,
yycrank+145,	yysvec+23,	yyvstop+101,
yycrank+219,	yysvec+23,	yyvstop+104,
yycrank+227,	yysvec+23,	yyvstop+107,
yycrank+229,	yysvec+23,	yyvstop+110,
yycrank+173,	yysvec+23,	yyvstop+113,
yycrank+231,	yysvec+23,	yyvstop+116,
yycrank+214,	yysvec+23,	yyvstop+119,
yycrank+230,	yysvec+23,	yyvstop+122,
yycrank+236,	yysvec+23,	yyvstop+125,
yycrank+241,	yysvec+23,	yyvstop+128,
yycrank+0,	0,		yyvstop+131,
yycrank+62,	0,		yyvstop+134,
yycrank+0,	0,		yyvstop+136,
yycrank+0,	0,		yyvstop+139,
yycrank+0,	0,		yyvstop+141,
yycrank+0,	0,		yyvstop+143,
yycrank+0,	yysvec+15,	yyvstop+145,
yycrank+-347,	0,		yyvstop+147,
yycrank+0,	yysvec+17,	yyvstop+149,
yycrank+0,	0,		yyvstop+151,
yycrank+0,	0,		yyvstop+153,
yycrank+0,	0,		yyvstop+155,
yycrank+0,	0,		yyvstop+157,
yycrank+80,	yysvec+23,	yyvstop+159,
yycrank+235,	yysvec+23,	yyvstop+161,
yycrank+262,	yysvec+23,	yyvstop+163,
yycrank+252,	yysvec+23,	yyvstop+165,
yycrank+125,	yysvec+23,	yyvstop+167,
yycrank+242,	yysvec+23,	yyvstop+169,
yycrank+244,	yysvec+23,	yyvstop+171,
yycrank+284,	yysvec+23,	yyvstop+173,
yycrank+251,	yysvec+23,	yyvstop+175,
yycrank+253,	yysvec+23,	yyvstop+177,
yycrank+174,	yysvec+23,	yyvstop+179,
yycrank+254,	yysvec+23,	yyvstop+181,
yycrank+255,	yysvec+23,	yyvstop+183,
yycrank+258,	yysvec+23,	yyvstop+185,
yycrank+261,	yysvec+23,	yyvstop+187,
yycrank+82,	yysvec+23,	yyvstop+189,
yycrank+266,	yysvec+23,	yyvstop+192,
yycrank+126,	yysvec+23,	yyvstop+194,
yycrank+264,	yysvec+23,	yyvstop+197,
yycrank+176,	yysvec+23,	yyvstop+199,
yycrank+268,	yysvec+23,	yyvstop+202,
yycrank+280,	yysvec+23,	yyvstop+204,
yycrank+283,	yysvec+23,	yyvstop+206,
yycrank+277,	yysvec+23,	yyvstop+208,
yycrank+290,	yysvec+23,	yyvstop+210,
yycrank+285,	yysvec+23,	yyvstop+212,
yycrank+292,	yysvec+23,	yyvstop+214,
yycrank+293,	yysvec+23,	yyvstop+216,
yycrank+281,	yysvec+23,	yyvstop+218,
yycrank+297,	yysvec+23,	yyvstop+220,
yycrank+298,	yysvec+23,	yyvstop+222,
yycrank+0,	0,		yyvstop+224,
yycrank+305,	yysvec+23,	yyvstop+226,
yycrank+312,	yysvec+23,	yyvstop+228,
yycrank+333,	yysvec+23,	yyvstop+230,
yycrank+302,	yysvec+23,	yyvstop+232,
yycrank+314,	yysvec+23,	yyvstop+234,
yycrank+311,	yysvec+23,	yyvstop+236,
yycrank+335,	yysvec+23,	yyvstop+238,
yycrank+307,	yysvec+23,	yyvstop+240,
yycrank+316,	yysvec+23,	yyvstop+242,
yycrank+317,	yysvec+23,	yyvstop+244,
yycrank+319,	yysvec+23,	yyvstop+246,
yycrank+320,	yysvec+23,	yyvstop+248,
yycrank+328,	yysvec+23,	yyvstop+250,
yycrank+325,	yysvec+23,	yyvstop+252,
yycrank+323,	yysvec+23,	yyvstop+254,
yycrank+327,	yysvec+23,	yyvstop+256,
yycrank+326,	yysvec+23,	yyvstop+258,
yycrank+337,	yysvec+23,	yyvstop+261,
yycrank+332,	yysvec+23,	yyvstop+263,
yycrank+330,	yysvec+23,	yyvstop+265,
yycrank+339,	yysvec+23,	yyvstop+267,
yycrank+340,	yysvec+23,	yyvstop+269,
yycrank+343,	yysvec+23,	yyvstop+271,
yycrank+353,	yysvec+23,	yyvstop+273,
yycrank+354,	yysvec+23,	yyvstop+275,
yycrank+349,	yysvec+23,	yyvstop+277,
yycrank+345,	yysvec+23,	yyvstop+279,
yycrank+350,	yysvec+23,	yyvstop+281,
yycrank+362,	yysvec+23,	yyvstop+283,
yycrank+358,	yysvec+23,	yyvstop+285,
yycrank+360,	yysvec+23,	yyvstop+287,
yycrank+329,	yysvec+23,	yyvstop+289,
yycrank+361,	yysvec+23,	yyvstop+291,
yycrank+364,	yysvec+23,	yyvstop+293,
yycrank+396,	yysvec+23,	yyvstop+295,
yycrank+402,	yysvec+23,	yyvstop+297,
yycrank+368,	yysvec+23,	yyvstop+299,
yycrank+370,	yysvec+23,	yyvstop+301,
yycrank+378,	yysvec+23,	yyvstop+303,
yycrank+405,	yysvec+23,	yyvstop+305,
yycrank+379,	yysvec+23,	yyvstop+307,
yycrank+377,	yysvec+23,	yyvstop+309,
yycrank+386,	yysvec+23,	yyvstop+311,
yycrank+380,	yysvec+23,	yyvstop+313,
yycrank+382,	yysvec+23,	yyvstop+315,
yycrank+383,	yysvec+23,	yyvstop+318,
yycrank+385,	yysvec+23,	yyvstop+321,
yycrank+397,	yysvec+23,	yyvstop+323,
yycrank+390,	yysvec+23,	yyvstop+325,
yycrank+391,	yysvec+23,	yyvstop+327,
yycrank+401,	yysvec+23,	yyvstop+329,
yycrank+395,	yysvec+23,	yyvstop+331,
yycrank+404,	yysvec+23,	yyvstop+333,
yycrank+410,	yysvec+23,	yyvstop+335,
yycrank+408,	yysvec+23,	yyvstop+337,
yycrank+388,	yysvec+23,	yyvstop+339,
yycrank+416,	yysvec+23,	yyvstop+342,
yycrank+414,	yysvec+23,	yyvstop+344,
yycrank+420,	yysvec+23,	yyvstop+346,
yycrank+403,	yysvec+23,	yyvstop+348,
yycrank+389,	yysvec+23,	yyvstop+350,
yycrank+415,	yysvec+23,	yyvstop+353,
yycrank+417,	yysvec+23,	yyvstop+356,
yycrank+425,	yysvec+23,	yyvstop+359,
yycrank+426,	yysvec+23,	yyvstop+361,
yycrank+421,	yysvec+23,	yyvstop+363,
yycrank+435,	yysvec+23,	yyvstop+366,
yycrank+464,	yysvec+23,	yyvstop+369,
yycrank+438,	yysvec+23,	yyvstop+371,
yycrank+432,	yysvec+23,	yyvstop+373,
yycrank+428,	yysvec+23,	yyvstop+375,
yycrank+472,	yysvec+23,	yyvstop+378,
yycrank+431,	yysvec+23,	yyvstop+380,
yycrank+493,	yysvec+23,	yyvstop+382,
yycrank+434,	yysvec+23,	yyvstop+384,
yycrank+433,	yysvec+23,	yyvstop+386,
yycrank+441,	yysvec+23,	yyvstop+389,
yycrank+446,	yysvec+23,	yyvstop+391,
yycrank+455,	yysvec+23,	yyvstop+393,
yycrank+443,	yysvec+23,	yyvstop+395,
yycrank+444,	yysvec+23,	yyvstop+397,
yycrank+447,	yysvec+23,	yyvstop+399,
yycrank+454,	yysvec+23,	yyvstop+401,
yycrank+457,	yysvec+23,	yyvstop+403,
yycrank+456,	yysvec+23,	yyvstop+405,
yycrank+459,	yysvec+23,	yyvstop+407,
yycrank+458,	yysvec+23,	yyvstop+409,
yycrank+469,	yysvec+23,	yyvstop+411,
yycrank+462,	yysvec+23,	yyvstop+413,
yycrank+450,	yysvec+23,	yyvstop+415,
yycrank+467,	yysvec+23,	yyvstop+418,
yycrank+504,	yysvec+23,	yyvstop+420,
yycrank+466,	yysvec+23,	yyvstop+422,
yycrank+477,	yysvec+23,	yyvstop+425,
yycrank+471,	yysvec+23,	yyvstop+427,
yycrank+502,	yysvec+23,	yyvstop+430,
yycrank+478,	yysvec+23,	yyvstop+432,
yycrank+499,	0,		0,	
yycrank+479,	yysvec+23,	yyvstop+434,
yycrank+494,	yysvec+23,	yyvstop+436,
yycrank+480,	yysvec+23,	yyvstop+438,
yycrank+482,	yysvec+23,	yyvstop+440,
yycrank+497,	yysvec+23,	yyvstop+442,
yycrank+485,	yysvec+23,	yyvstop+444,
yycrank+487,	yysvec+23,	yyvstop+446,
yycrank+489,	yysvec+23,	yyvstop+449,
yycrank+495,	yysvec+23,	yyvstop+451,
yycrank+499,	yysvec+23,	yyvstop+453,
yycrank+490,	yysvec+23,	yyvstop+455,
yycrank+505,	yysvec+23,	yyvstop+458,
yycrank+514,	yysvec+23,	yyvstop+460,
yycrank+503,	yysvec+23,	yyvstop+462,
yycrank+506,	yysvec+23,	yyvstop+465,
yycrank+526,	yysvec+23,	yyvstop+468,
yycrank+508,	yysvec+23,	yyvstop+470,
yycrank+509,	yysvec+23,	yyvstop+472,
yycrank+510,	yysvec+23,	yyvstop+475,
yycrank+507,	0,		0,	
yycrank+512,	yysvec+23,	yyvstop+477,
yycrank+515,	yysvec+23,	yyvstop+480,
yycrank+517,	yysvec+23,	yyvstop+482,
yycrank+519,	yysvec+23,	yyvstop+484,
yycrank+520,	yysvec+23,	yyvstop+486,
yycrank+523,	yysvec+23,	yyvstop+488,
yycrank+528,	yysvec+23,	yyvstop+490,
yycrank+529,	yysvec+23,	yyvstop+492,
yycrank+538,	yysvec+23,	yyvstop+494,
yycrank+545,	yysvec+23,	yyvstop+496,
yycrank+533,	yysvec+23,	yyvstop+498,
yycrank+575,	yysvec+23,	yyvstop+500,
yycrank+535,	yysvec+23,	yyvstop+502,
yycrank+537,	yysvec+23,	yyvstop+505,
yycrank+544,	0,		0,	
yycrank+540,	yysvec+23,	yyvstop+507,
yycrank+542,	yysvec+23,	yyvstop+509,
yycrank+541,	yysvec+23,	yyvstop+511,
yycrank+548,	yysvec+23,	yyvstop+513,
yycrank+550,	yysvec+23,	yyvstop+515,
yycrank+557,	yysvec+23,	yyvstop+517,
yycrank+554,	yysvec+23,	yyvstop+519,
yycrank+561,	yysvec+23,	yyvstop+521,
yycrank+556,	yysvec+23,	yyvstop+523,
yycrank+570,	yysvec+23,	yyvstop+525,
yycrank+576,	yysvec+23,	yyvstop+527,
yycrank+560,	yysvec+23,	yyvstop+529,
yycrank+574,	0,		0,	
yycrank+564,	yysvec+23,	yyvstop+532,
yycrank+565,	yysvec+23,	yyvstop+534,
yycrank+566,	yysvec+23,	yyvstop+537,
yycrank+567,	yysvec+23,	yyvstop+539,
yycrank+568,	yysvec+23,	yyvstop+541,
yycrank+569,	yysvec+23,	yyvstop+544,
yycrank+571,	yysvec+23,	yyvstop+547,
yycrank+572,	yysvec+23,	yyvstop+550,
yycrank+577,	yysvec+23,	yyvstop+553,
yycrank+578,	yysvec+23,	yyvstop+555,
yycrank+614,	yysvec+23,	yyvstop+557,
yycrank+572,	0,		0,	
yycrank+588,	yysvec+23,	yyvstop+559,
yycrank+582,	yysvec+23,	yyvstop+561,
yycrank+583,	yysvec+23,	yyvstop+563,
yycrank+585,	yysvec+23,	yyvstop+565,
yycrank+587,	yysvec+23,	yyvstop+567,
yycrank+631,	yysvec+23,	yyvstop+569,
yycrank+599,	0,		0,	
yycrank+593,	yysvec+23,	yyvstop+571,
yycrank+595,	yysvec+23,	yyvstop+573,
yycrank+596,	yysvec+23,	yyvstop+576,
yycrank+604,	yysvec+23,	yyvstop+578,
yycrank+598,	yysvec+23,	yyvstop+580,
yycrank+599,	yysvec+23,	yyvstop+583,
yycrank+0,	0,		yyvstop+586,
yycrank+601,	yysvec+23,	yyvstop+588,
yycrank+602,	yysvec+23,	yyvstop+591,
yycrank+605,	yysvec+23,	yyvstop+594,
yycrank+606,	yysvec+23,	yyvstop+596,
0,	0,	0};
struct yywork *yytop = yycrank+739;
struct yysvf *yybgin = yysvec+1;
char yymatch[] = {
  0,   1,   1,   1,   1,   1,   1,   1, 
  1,   9,  10,   9,   9,   9,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  9,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
 48,  48,  48,  48,  48,  48,  48,  48, 
 48,  48,   1,   1,   1,   1,   1,   1, 
  1,  65,  65,  65,  65,  65,  65,  65, 
 65,  65,  65,  65,  65,  65,  65,  65, 
 65,  65,  65,  65,  65,  65,  65,  65, 
 65,  65,  65,   1,   1,   1,   1,  95, 
  1,  65,  65,  65,  65,  65,  65,  65, 
 65,  65,  65,  65,  65,  65,  65,  65, 
 65,  65,  65,  65,  65,  65,  65,  65, 
 65,  65,  65,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
0};
char yyextra[] = {
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0};
/*	Copyright (c) 1989 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#pragma ident	"@(#)ncform	6.8	95/02/11 SMI"

int yylineno =1;
# define YYU(x) x
# define NLSTATE yyprevious=YYNEWLINE
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
char yysbuf[YYLMAX];
char *yysptr = yysbuf;
int *yyfnd;
extern struct yysvf *yyestate;
int yyprevious = YYNEWLINE;
#if defined(__cplusplus) || defined(__STDC__)
int yylook(void)
#else
yylook()
#endif
{
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych, yyfirst;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	char *yylastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	yyfirst=1;
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = yybgin;
		if (yyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == yycrank && !yyfirst){  /* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == yycrank)break;
				}
#ifndef __cplusplus
			*yylastch++ = yych = input();
#else
			*yylastch++ = yych = lex_input();
#endif
			if(yylastch > &yytext[YYLMAX]) {
				fprintf(yyout,"Input string too long, limit %d\n",YYLMAX);
				exit(1);
			}
			yyfirst=0;
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"char ");
				allprint(yych);
				putchar('\n');
				}
# endif
			yyr = yyt;
			if ( (int)yyt > (int)yycrank){
				yyt = yyr + yych;
				if (yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					if(lsp > &yylstate[YYLMAX]) {
						fprintf(yyout,"Input string too long, limit %d\n",YYLMAX);
						exit(1);
					}
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if((int)yyt < (int)yycrank) {		/* r < yycrank */
				yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					if(lsp > &yylstate[YYLMAX]) {
						fprintf(yyout,"Input string too long, limit %d\n",YYLMAX);
						exit(1);
					}
					goto contin;
					}
				yyt = yyr + YYU(yymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"try fall back character ");
					allprint(YYU(yymatch[yych]));
					putchar('\n');
					}
# endif
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transition */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					if(lsp > &yylstate[YYLMAX]) {
						fprintf(yyout,"Input string too long, limit %d\n",YYLMAX);
						exit(1);
					}
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank){
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"state %d char ",yystate-yysvec-1);
				allprint(yych);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(yyout,"stopped at %d with ",*(lsp-1)-yysvec-1);
			allprint(yych);
			putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(yyextra[*yyfnd]){		/* must backup */
					while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						unput(*yylastch--);
						}
					}
				yyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"\nmatch ");
					sprint(yytext);
					fprintf(yyout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			unput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(yyin) */)
			{
			yysptr=yysbuf;
			return(0);
			}
#ifndef __cplusplus
		yyprevious = yytext[0] = input();
		if (yyprevious>0)
			output(yyprevious);
#else
		yyprevious = yytext[0] = lex_input();
		if (yyprevious>0)
			lex_output(yyprevious);
#endif
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
#if defined(__cplusplus) || defined(__STDC__)
int yyback(int *p, int m)
#else
yyback(p, m)
	int *p;
#endif
{
	if (p==0) return(0);
	while (*p) {
		if (*p++ == m)
			return(1);
	}
	return(0);
}
	/* the following are only used in the lex library */
#if defined(__cplusplus) || defined(__STDC__)
int yyinput(void)
#else
yyinput()
#endif
{
#ifndef __cplusplus
	return(input());
#else
	return(lex_input());
#endif
	}
#if defined(__cplusplus) || defined(__STDC__)
void yyoutput(int c)
#else
yyoutput(c)
  int c; 
#endif
{
#ifndef __cplusplus
	output(c);
#else
	lex_output(c);
#endif
	}
#if defined(__cplusplus) || defined(__STDC__)
void yyunput(int c)
#else
yyunput(c)
   int c; 
#endif
{
	unput(c);
	}
