#ifndef _parser_x
#define _parser_x

/* This file defines the interface to the CODE parser. Use ONLY what
   is here to interact with the parser.

   To use the parser, call function

   int yyDoParse(char *Code, char *Buf, int DoListing, cAbsTree *&TreeRoot,
                 int MakeTree)

   If the parse succeeds, the function returns 1 and places a pointer
   to the root of the abstract snytax tree into TreeRoot.  If the parse
   fails a value of 0 is returned.  Arguments are defined as follows...

   Code - a string that determines what is to be parsed.  Choices
          include...    (See the start symbol of gram.y)

          "qquc" for a UC node.
          "qqarctopo" for an arc topology spec.
          "qqfuncsig" for a listof function signatures.
          "qqtypedef" for a list of typedefs.
          "qqnsicomp" for a list of statements.

   buf - the string to be parsed.
   DoListing - if true, yyparse produces a listing on stdout
   MakeTree - attempts to build abstract syntax tree if non-zero.

                                                                 */

// parser.h requires
//  #include "../exmodel/exmodel.h"

int yyDoParse(char *Code, char *Buf, int DoListing, cAbsTree *&TreeRoot,
              int MakeTree);

/* If a parse error occurs, these variables tell where */

extern int yycolumn;       /* column of error */
extern int yylinenum;      /* line number of error */

#endif
