/* scanner for CODE */

D [0-9]
L [a-zA-Z]
S [_]

%{

#include <stdio.h>
#include <stdlib.h>
#include "y.tab.h"
#include "../misc/general.h"
#include "../exmodel/abstree.h"
#include "../exmodel/exmodel.h"
#include "parser.h"
#include "scan.h"
#include <string.h>

extern cAbsTree *yylval;     /* Value of token for yacc++ */

static char *cpstr(char *s);
static void count();
#ifndef yyerror
        void yyerror(const char *s);
#endif

#undef lex_input
#undef unput

%}

%%

"%"			{ count(); return '%'; }
"!"			{ count(); return '!'; }
"-"			{ count(); return '-'; }
"["			{ count(); return '['; }
"]"			{ count(); return ']'; }
"<"			{ count(); return '<'; }
">"			{ count(); return '>'; }
"."			{ count(); return '.'; }
","			{ count(); return ','; }

"{"			{ count(); return '{'; }
"}"			{ count(); return '}'; }
";"			{ count(); return ';'; }
"("			{ count(); return '('; }
")"			{ count(); return ')'; }
"*"			{ count(); return '*'; }
"+"			{ count(); return '+'; }
"="			{ count(); return '='; }
":"			{ count(); return ':'; }
"/"			{ count(); return '/'; }

"->"			{ count(); return(CONS); }
"<-"			{ count(); return(PROD); }
"<="			{ count(); return(LE_OP); }
">="			{ count(); return(GE_OP); }
"=="			{ count(); return(EQ_OP); }
"!="			{ count(); return(NE_OP); }
"&&"			{ count(); return(AND_OP); }
"||"			{ count(); return(OR_OP); }

"new"			{ count(); return(NEW); }
"void"			{ count(); return(VOID); }
"if"			{ count(); return(IF); }
"else"			{ count(); return(ELSE); }
"while"			{ count(); return(WHILE); }
"is"			{ count(); return(IS); }
"of"			{ count(); return(OF); }
"shared_vars"		{ count(); return(SHARED_VAR); }
"vars"			{ count(); return(VAR); }
"type"			{ count(); return(TYPE); }
"array"			{ count(); return(ARRAY); }
"comp"			{ count(); return(COMP); }
"init_comp"		{ count(); return(INITCOMP); }
"firing_rules"		{ count(); return(INPUTRULES); }
"routing_rules"		{ count(); return(OUTPUTRULES); }
"input_ports"		{ count(); return(INPUTPORTS); }
"output_ports"		{ count(); return(OUTPUTPORTS); }
"reader"		{ count(); return(READER); }
"writer"		{ count(); return WRITER; }
"struct"		{ count(); return(STRUCT); }
"qqfuncsig"		{ count(); return(QQFUNCSIG); }
"qqarctopo"		{ count(); return(QQARCTOPO); }
"qquc"			{ count(); return(QQUC); }
"qqnsicomp"		{ count(); return(QQNSICOMP); }
"qqtypedef"		{ count(); return(QQTYPEDEF); }
"qqexpr"		{ count(); return(QQEXPR); }
"Partition"		{ count(); return(PARTITION); }
"Merge"		        { count(); return(MERGE); }
"Expand"		{ count(); return(EXPAND); }
"Contract"		{ count(); return(CONTRACT); }
"Strip-Update"		{ count(); return(STRIP_UPDATE); }
"Align"  		{ count(); return(ALIGN); }
"BLOCK"	         	{ count(); return(BLOCK); }
"CYCLIC"		{ count(); return(CYCLIC); }
"BLOCK_CYCLIC"		{ count(); return(BLOCK-CYCLIC); }
"OVERLAP"		{ count(); return(OVERLAP); }
"Summary"		{ count(); return(SUMMARY); }

{D}*\.{D}*		{ count(); 
			  yylval = new cRealConst(atof(yytext));
			  return(REALCONST); }

{D}+			{ count();
			  yylval = new cIntConst(atoi(yytext));
			  return(INTCONST); }

({L}|{S})({L}|{D}|{S})*	{ count();
			  yylval = (cAbsTree *) cpstr(yytext);
			  return(IDENT); }

"//".*			{ count();  /* ignore comments */ }
[ \t\v\n\r\f]		{ count(); }

.			{ count(); return(WRONG); }

%%

static int yyecho = 1;    /* if true produce listing to stdout */
int yycolumn;
int yylinenum;


static void count()
{
   int i;

   for (i = 0; yytext[i] != '\0'; i++)
     if (yytext[i] == '\n') {
       yylinenum += 1;
       yycolumn = 0;
    }
     else if (yytext[i] == '\t')
       yycolumn += 8 - (yycolumn % 8);
     else
       yycolumn++;
   
   if (yyecho) ECHO;

}


#ifndef yyerror
void yyerror (const char *s)
{
   if (yyecho) {
      printf("\n ** At line %d, col %d... %s\n", yylinenum, yycolumn, s);
      fflush(stdout);
   }
}
#endif

yywrap()
{
        return(1);
}

#include <strings.h>

static char *bp;
static char *bufstart;
static char *codebp;
static char *codebufstart;
static int InCodeString;
static char yyCode[32];

// Functions below are to allow the parser to read from this "string"
// consisting of the code string followed by the data.  Weird stuff.

void yyset_input(char *code, char *buf, int DoListing)
{
   extern int yyprevious;

   yycolumn = 0;
   yylinenum = 0;
   yyecho = DoListing;
   InCodeString = 1;

   codebp = strcpy(yyCode, code);
   codebp = strcat(yyCode, "\n");
   codebufstart = yyCode;

   bp = buf;
   bufstart = buf;
#if 0
   NLSTATE;         /* Tell parser it is at beginning of line */
#endif
}

int lex_input()
{
   char ch;

   if (InCodeString) {
      ch = *codebp;
      ++codebp;
      if (*codebp == '\0') {
	 InCodeString = 0;
	 --codebp;
      }
   } else
     if (ch = *bp) ++bp;

   return ch;
}


unput(int ch)
{

   if (ch == '\0') return 0;

   if (InCodeString) {
      --codebp;
      if (*codebp != ch) Die("unput the wrong char in code!\n");
      if (codebp < codebufstart) Die("unput past starting point in code!\n");
   } else {
      if (bp > bufstart) {
	 --bp;
	 if (*bp != ch) Die("unput the wrong char!\n");
      } else
	InCodeString = 1;
   }

   return 1; /* Silence the "no return value" warning */
}



  // Copy string out of yytext into static storage.  This is yet another
  // memory leak since these are just copied into an MString, but there
  // is no easy way to fix it.

static char *cpstr(char *s)
{
   char* strbuf;

   strbuf = new char[strlen(s)+1];

   strcpy(strbuf, s);
   return strbuf;
}
