#include <stdio.h>
#include <stream.h>
#include "../exmodel/abstree.h"
#include "../exmodel/exmodel.h"
#include "../misc/general.h"
#include "parser.h"

FILE *f;
extern FILE *yyin;

char *buf;

static void load_buf()
{
   char fname[32];
   FILE *f;
   char *bp;
   char ch;

   printf("Enter a file name: ");
   scanf("%s", fname);
   if ((f = fopen(fname, "r")) == NULL) {
      printf("Could not open file %s\n", fname);
      exit(1);
   }

   printf("\nreading %s...\n", fname);
   bp = buf;
   while ((ch = getc(f)) != EOF) {
      *bp = ch;
      bp++;
   }

   *bp = 0;

   fclose(f);

}

   
main (int argc, char **argv)
{
   char code[32];
   buf = new char [32000];
   int list;
   cAbsTree *p;

   list = argc > 1;
   DebugLevel = 0;

   cout.setf(ios::showpoint);
   while (1) {
      load_buf();
      printf("Enter parse code: ");
      scanf("%s", code);
      printf("parsing....\n");   
      if (yyDoParse(code, buf, list, p, 1)) {
         printf("\nOK parse\n");
         if (p != 0) {
            p->PrintId(); cout << flush;
            printf("\n xxxxxxxxxxxxxxx list() xxxxxxxxxxxxxxxxxxxxx \n");
            p->List(); cout << flush;
            delete p;  cout << flush;
	 }
      } else
         printf("\nBAD parse\n");
   }
}

