#ifndef _stype_x
#define _stype_x

// stype.h requires
//  #include "../exmodel/object.h"

void InitSTypes();
void FreeSTypes();


class cSType : public cObject {
   friend void InitSTypes();
   friend void FreeSTypes();
 private:
   static cSType *Head; // linked list used to free space
   cSType *Next;
 public:
   cSType();
   virtual ~cSType() {};
   MString TypeName;
};

class cIntSType : public cSType {
 public:
   cIntSType();
   ~cIntSType();

   ClassId IsA() { return IntSType; }
   void PrintId() { cout << "IntSType\n"; }
   void List();
};


class cRealSType : public cSType {
 public:
   cRealSType();
   ~cRealSType();

   ClassId IsA() { return RealSType; }
   void PrintId() { cout << "RealSType\n"; }
   void List();
};


class cCharSType : public cSType {
 public:
   cCharSType();
   ~cCharSType();

   ClassId IsA() { return CharSType; }
   void PrintId() { cout << "CharSType\n"; }
   void List();
};


class cPortSType : public cSType {
 public:
   cPortSType();
   ~cPortSType();

   int IsInputPort;   // 1 if it is and 0 otherwise.
   cSType *BaseType;

   ClassId IsA() { return PortSType; }
   void PrintId() { cout << "PortSType\n"; }
   void List();
};


class cArraySType : public cSType {
 public:
   cArraySType();
   ~cArraySType();

   cSType *BaseType;

   ClassId IsA() { return ArraySType; }
   void PrintId() { cout << "ArraySType\n"; }
   void List();
};


class cStructMemSType : public cObject {
 public:
   cStructMemSType();
   virtual ~cStructMemSType();

   MString Ident;
   cSType *Type;

   ClassId IsA() { return StructMemSType; }
   void PrintId() { cout << "StructMemSType\n"; }
   void List();
};


class cStructSType : public cSType {
 public:
   cStructSType();
   ~cStructSType();

   cObList Members; // list of cStructMemSType

   cStructMemSType *GetMember(MString Name);

   ClassId IsA() { return StructSType; }
   void PrintId() { cout << "StructSType\n"; }
   void List();
};


  // return 1 if s is of one of the class types given by the ...
  // arguments which must be of type ClassId.  Return 0 otherwise.
  // The list must end with a zero.

  //   Example: (void) IsSTypeOneOf(s, IntSType, 0);

int IsSTypeOneOf(cSType *s, ...);

  // Return 1 if two structural types are the same, 0 otherwise.

int AreSTypesEq(cSType *s1, cSType *s2);

  // Return 1 if it is legal to assign FromSType to ToSType or to pass by value
  // FromSType as an actual parameter bound to ToSType as a formal.  Return
  // 0 otherwise.

int CanAssignSTypes(cSType *ToSType, cSType *FromSType);

#endif
