#include <config.h>
#include <stream.h>
#include <stdarg.h>

#include "../misc/general.h"
#include "../exmodel/exmodel.h"
#include "symtab.h"


cSymLink::cSymLink()
{
   Next = 0;

   if (DebugLevel >= 7) {
      cout << "cSymLink created\n";
   }
}


cSymLink::~cSymLink()
{
   delete Entry;

   if (DebugLevel >= 7) {
      cout << "cSymLink destroyed\n";
   }
}



void cSymLink::List()
{
   cout << Ident << " is a ";
   Entry->List();
}


cSymTab::cSymTab(cAbsTree *InitParent)
{
   Parent = InitParent;
   Head = 0;   // Table is initially empty

   if (DebugLevel >= 7) {
      cout << "cSymTab created\n";
   }
}


cSymTab::~cSymTab()
{
   cSymLink *cur, *tmp;

   cur = Head;         // Delete the list
   while (cur != 0) {
      tmp = cur;
      cur = cur->Next;
      delete tmp;
   }

   if (DebugLevel >= 7) {
      cout << "cSymTab destroyed\n";
   }
}


void cSymTab::List()
{
   cSymLink *cur;

   cout << "Symbol Table {\n";
   cur = Head;
   while (cur != 0) {
      cur->List();
      cur = cur->Next;
   }
   cout << "}\n";

}


   // Put an entry into the symbol table; return 1 if successful

int cSymTab::Insert(MString Ident, cSymTabEntry *Entry)
{
   cSymLink *p = new cSymLink;
   cSymLink *cur, *prev;

   p->Ident = Ident;
   p->Entry = Entry;

   if (Head == 0) {
      Head = p;
      return 1;
   }

   cur = Head;
   while (cur != 0) {  // test for ident already declared
      if ((char *) cur->Ident == Ident) return 0;
      prev = cur;
      cur = cur->Next;
   }

   prev->Next = p;
   return 1;
}



  // Get entry from local symbol table.  Return 0 if not found.

cSymTabEntry *cSymTab::Get(MString Ident)
{
   cSymLink *cur;

   cur = Head;

   while (cur != 0) {
      if ((char *) cur->Ident == Ident) return cur->Entry;
      cur = cur->Next;
   }

   return 0;

}



// GetSymbol(MString Ident, cAbstree *Here, ClassId c1, ClassId c2, ..., 0)
// searches symbol tables starting at Here for an entry bound to
// Ident.  Only entries with type matching one of the ClassIds will
// be returned.  If no ClassId's are supplied, any Ident matches.
// Note that a 0 must terminate the list of ClassIds (even if it
// is empty.


cSymTabEntry *GetSymbol(MString Ident, cAbsTree *Here, ...)
{
   va_list ap;
   ClassId c;
   int FoundIt;
   cSymTabEntry *t;

   // Find a symbol table that contains ident, checking parents up
   // the tree.

   FoundIt = 0;
   while (Here != 0 && !FoundIt) {
      if (Here->SymbolTable != 0)
	t = Here->SymbolTable->Get(Ident);
      else
	t = 0;
      if (t == 0)
	Here = Here->Parent;     // Check the parent
      else
	FoundIt = 1;
   }

   if (FoundIt == 0) return 0;     // Ident is not found at all.

   // Ident has been found, but is the entry of a requested type?

   va_start(ap, Here);
   c = va_arg(ap, ClassId);

   if (c == 0) {
      // Empty list says that any type is OK so return it.
      va_end(ap);
      return t;
   }

   while(c != 0) {
      if (t->IsA() == c) {
	 // OK, got a match.  Return it.
	 va_end(ap);
	 return t;
      }
      c = va_arg(ap, ClassId);
   }

   // Did not match one of the requested types
   va_end(ap);
   return 0;
}


void FreeSymTab(cSymTab *s)
{
   delete s;
}


cSymTabEntry *cSymTab::GetNext()
{
   cSymTabEntry *t;

   if (Current != 0) {
      t = Current->Entry;
      Current = Current->Next;
   } else
     t = 0;

   return t;
}
