#ifndef _symtab_x
#define _symtab_x

#include <exmodel/abstree.h>

#include "symtabent.h"

class cSymLink {
 public:
   cSymLink();
   ~cSymLink();
   void List();

   MString Ident;
   cSymTabEntry *Entry;

   cSymLink *Next;
};


class cSymTab : public cObject {
 private:
   cSymLink *Current;
   cSymLink *Head;
 public:
   cSymTab(cAbsTree *InitParent);
   virtual ~cSymTab();

   cAbsTree *Parent;    // AST node that owns this symtab.
   int Insert(MString Ident, cSymTabEntry *Entry);
   cSymTabEntry *Get(MString Ident);

   void ListInit() { Current = Head; }  // Call before GetNext
   cSymTabEntry *GetNext();   // Used to iterate over all entries.  0 at end.

   ClassId IsA() { return SymTab; }
   void PrintId() { cout << "SymTab\n"; }
   void List();
};



// GetSymbol(MString Ident, cAbstree *Here, ClassId c1, ClassId c2, ..., 0)
// searches symbol tables starting at Here for an entry bound to
// Ident.  Only entries with type matching one of the ClassIds will
// be returned.  If no ClassId's are supplied, any Ident matches.
// Note that a 0 must terminate the list of ClassIds (even if it
// is empty.

// Examples:

//    GetSymbol("i", this, SETypeName, 0);  -- to find typenames
//    GetSymbol("i", this, 0);  -- to find any entry.

  cSymTabEntry *GetSymbol(MString Ident, cAbsTree *Here, ...);

  // Delete a SymbolTable.  You will probably want to ignore this since
  // its sole purpose to to get around an #inclde problem is abstree.C,
  // which cannot #include symtab.h

void FreeSymTab(cSymTab *s);

#endif
