#include <config.h>
#include <stream.h>
#include "../misc/general.h"
#include "../exmodel/exmodel.h"

#include "symtabent.h"

cSEFuncArg::cSEFuncArg()
{

   if (DebugLevel >= 7) {
      cout << "cSEFuncArg created\n";
   }
}


cSEFuncArg::~cSEFuncArg()
{

   if (DebugLevel >= 7) {
      cout << "cSEFuncArg destroyed\n";
   }
}


void cSEFuncArg::List()
{
   if (Type != 0) {
      if (IsByValue)
         cout << "value ";
      else
         cout << "reference ";
      Type->List();
   } else 
      Die("Type in cSEFuncArg is zero.");
   
}


cSEFuncName::cSEFuncName()
{
   IsPolyMorphic = 0;
   DontCheckArgs = 0;

   if (DebugLevel >= 7) {
      cout << "cSEFuncName created\n";
   }
}


cSEFuncName::~cSEFuncName()
{

   if (DebugLevel >= 7) {
      cout << "cSEFuncName destroyed\n";
   }
}


void cSEFuncName::List()
{
   cObIterator i;
   cObject *p;
   int FirstInList = 1;

   if (IsPolyMorphic) {
      cout << "special function " << "\n";
      return;
   }

   if (ReturnType == 0)
      cout << "(void) ";
   else {
      cout << "(";
      ReturnType->List();
      cout << ") ";
   }

   cout << "(";
   for (p = i.Init(ArgList); i.MoreLeft(); p = i.Next()) {
      if (FirstInList)
	FirstInList = 0;
      else
	cout << ", ";
      p->List();
   }
   cout << ")\n";

}


cSEVariable::cSEVariable()
{
   Shared = 0;
   if (DebugLevel >= 7) {
      cout << "cSEVariable created\n";
   }
}


cSEVariable::~cSEVariable()
{

   if (DebugLevel >= 7) {
      cout << "cSEVariable destroyed\n";
   }
}


void cSEVariable::List()
{
   if (Type != 0) {
      Type->List();
      cout << "\n";
   } else 
      Die("Type in cSEVariable is zero.");
}


cSETypeName::cSETypeName()
{

   if (DebugLevel >= 7) {
      cout << "cSETypeName created\n";
   }
}


cSETypeName::~cSETypeName()
{

   if (DebugLevel >= 7) {
      cout << "cSETypeName destroyed\n";
   }
}


void cSETypeName::List()
{
   if (Type != 0) {
      Type->List();
      cout << "\n";
   } else 
      Die("Type in cSETypeName is zero.");
}


cSEPortName::cSEPortName()
{

   if (DebugLevel >= 7) {
      cout << "cSEPortName created\n";
   }
}


cSEPortName::~cSEPortName()
{

   if (DebugLevel >= 7) {
      cout << "cSEPortName destroyed\n";
   }
}


void cSEPortName::List()
{
   if (Type != 0) {
      Type->List();
      cout << "\n";
   } else 
      Die("Type in cSEPortName is zero.");
}


cSEIntNode::cSEIntNode()
{

   if (DebugLevel >= 7) {
      cout << "cSEIntNode created\n";
   }
}


cSEIntNode::~cSEIntNode()
{

   if (DebugLevel >= 7) {
      cout << "cSEIntNode destroyed\n";
   }
}


void cSEIntNode::List()
{
   if (Type != 0) {
      if (IsInputNode)
         cout << "Input Node ";
      else 
         cout << "OutPut Node ";

      Type->List();
      cout << "\n";
   } else 
      Die("Type in cSEIntNode is zero.");
}


cSESharedVar::cSESharedVar()
{

   if (DebugLevel >= 7) {
      cout << "cSESharedVar created\n";
   }
}


cSESharedVar::~cSESharedVar()
{

   if (DebugLevel >= 7) {
      cout << "cSESharedVar destroyed\n";
   }
}


void cSESharedVar::List()
{
   if (Type != 0) {
      Type->List();
      cout << "\n";
   } else 
      Die("Type in cSESharedVar is zero.");
}


cSECreP::cSECreP()
{

   if (DebugLevel >= 7) {
      cout << "cSECreP created\n";
   }
}


cSECreP::~cSECreP()
{

   if (DebugLevel >= 7) {
      cout << "cSECreP destroyed\n";
   }
}


void cSECreP::List()
{
   if (Type != 0) {
      Type->List();
      cout << "\n";
   } else 
      Die("Type in cSECreP is zero.");
}


cSEGraph::cSEGraph()
{

   if (DebugLevel >= 7) {
      cout << "cSEGraph created\n";
   }
}


cSEGraph::~cSEGraph()
{

   if (DebugLevel >= 7) {
      cout << "cSEGraph destroyed\n";
   }
}


void cSEGraph::List()
{
   if (Graph != 0) {
      cout << "graph called " << Graph->Name << "\n";
   } else 
      Die("Graph in cSEGraph is null.");
}

