#ifndef _symtabent_x
#define _symtabent_x

// symtabent.h requires
//  #include "../exmodel/exmodel.h"

#include "stype.h"


class cSymTabEntry : public cObject {
 public:
   cSymTabEntry() { GenName = GenSym(); }

   MString GenName;
};


class cSEFuncArg : public cSymTabEntry {
 public:
   cSEFuncArg();
   ~cSEFuncArg();

   cSType *Type;
   int IsByValue;  // 1 => pased by valued else by reference

   ClassId IsA() { return SEFuncArg; }
   void PrintId() { cout << "SEFuncArg\n"; }
   void List();
};


class cSEFuncName : public cSymTabEntry {
 public:
   cSEFuncName();
   ~cSEFuncName();

   int IsPolyMorphic;  // is this a predefined, unfortunate function?
   int DontCheckArgs;

   cSType *ReturnType;  // 0 if void for a procedure
   cObList ArgList;     // List of cSEFuncArg

   ClassId IsA() { return SEFuncName; }
   void PrintId() { cout << "SEFuncName\n"; }
   void List();
};


class cSEVariable : public cSymTabEntry {
 public:
   cSEVariable();
   ~cSEVariable();

   cSType *Type;
   int Shared; // is this a shared variable in a cNSRel Node

   ClassId IsA() { return SEVariable; }
   void PrintId() { cout << "SEVariable\n"; }
   void List();
};


class cSETypeName : public cSymTabEntry {
 public:
   cSETypeName();
   ~cSETypeName();

   cSType *Type;

   MString UserBaseTypeName;  // for "is" & "is array of" names

   ClassId IsA() { return SETypeName; }
   void PrintId() { cout << "SETypeName\n"; }
   void List();
};


class cSEPortName : public cSymTabEntry {
 public:
   cSEPortName();
   ~cSEPortName();

   cSType *Type;
   int IsInputPort;  // 1 => input else ouput port

   ClassId IsA() { return SEPortName; }
   void PrintId() { cout << "SEPortName\n"; }
   void List();
};


class cSEIntNode : public cSymTabEntry {
 public:
   cSEIntNode();
   ~cSEIntNode();

   cSType *Type;
   int IsInputNode;  // 1 => input else ouput node

   ClassId IsA() { return SEIntNode; }
   void PrintId() { cout << "SEIntNode\n"; }
   void List();
};



class cSESharedVar : public cSymTabEntry {
 public:
   cSESharedVar();
   ~cSESharedVar();

   cSType *Type;

   ClassId IsA() { return SESharedVar; }
   void PrintId() { cout << "SESharedVar\n"; }
   void List();
};


class cSECreP : public cSymTabEntry {
 public:
   cSECreP();
   ~cSECreP();

   cSType *Type;

   ClassId IsA() { return SECreP; }
   void PrintId() { cout << "SECreP\n"; }
   void List();
};


class cSEGraph : public cSymTabEntry {
 public:
   cSEGraph();
   ~cSEGraph();

   cGraph *Graph;

   ClassId IsA() { return SEGraph; }
   void PrintId() { cout << "SEGraph\n"; }
   void List();
};


#endif
