/*
  translate.C
  ------------------------------------------------------------------------
  Translation driver routine.
  ------------------------------------------------------------------------
  @(#) $Id: translate.C,v 1.32 1998/05/28 22:51:40 emery Exp $
  ------------------------------------------------------------------------
  AUTHOR/CONTACT:
 
  Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
  Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
  Department of Computer Sciences |             <http://www.cs.utexas.edu>
  University of Texas at Austin   |                <http://www.utexas.edu>
  ========================================================================
*/

#include <config.h>

#include <stream.h>
#include <misc/general.h>
#include <exmodel/abstree.h>
#include <exmodel/exmodel.h>
#include <treebuild/pass.h>
#include <lib/Syntax.h>
#include <symtab/symtab.h>
#include "translate.h"
#include <lib/MsgUI.h>
#include <lib/UidTable.h>
#include <misc/fileutil.h>

// Call one of these before starting translation
//int InitPvm(cProgram *p);
// int InitMpi(cProgram *p);
int InitSerial(cProgram *p);
int InitUnified(cProgram *p);

int StartNodeUID;
int StartGraphUID;

void FixMe(char *s) // need to roll into yyMsg stuff
{
  cerr << s;
};


int Translate(int Option)
{
  InitSTypes();
  GenSymInit(0);

  // Syntax check passed if we get to here.  Pass1 and Pass2 decorate
  // the abstract syntax tree and build the symbol table.

  ProgramRoot->Pass1();
  if (!PassOK) goto done;

  ProgramRoot->Pass2();
  if (!PassOK) goto done;

  ProgramRoot->Pass3();
  if (!PassOK) goto done;

  if (Option == DOLISTING) {
    // Just list the tree, then out of here.
    ProgramRoot->List();
    goto done;
  }

  switch (Option) {
#if 0
  case DOPVM:
    if (InitPvm(ProgramRoot))
      ProgramRoot->Pvm(); 
    break;
#endif
  case DOSERIAL:
    if (InitSerial(ProgramRoot))
      ProgramRoot->Serial(); 
    break;
  case DOUNIFIED:
    if (InitUnified(ProgramRoot))
      ProgramRoot->Unified(); 
    break;
  default:
    Die("No case in Translate\n");
    break;
  }

done:
  FreeSTypes();
  YYUIMessageDisplay();
  return PassOK;
}


MString FindPortName(cExpr *e)
{
  switch (e->IsA()) {
  case Ident:
    return ((cIdent *) e)->PrintName;
  case ArrayIndOp:
    return FindPortName(((cArrayIndOp *) e)->Left);
  default:
    Die("Internal error: Wrong type in FindPortName\n");
  }

  return "";  // Quiet the compiler
}


int FillIndVar(cCursor &c, MString Name, cExpr *e, int ic)
{
  int i;

  switch (e->IsA()) {
  case Ident:
    return ic;
  case ArrayIndOp:
    i = FillIndVar(c, Name, ((cArrayIndOp *) e)->Left, ic);
    c << Name << ".Ind[" << i << "] = "
      <<  ((cArrayIndOp *) e)->Right->Translate()
      << ";\n";
    return i+1;
  default:
    Die("Internal error: Wrong type in FillIndVar\n");
  }

  return 0;  // Quiet the compiler
}


// Finds the arc leaving given node (FromNode) attached to FromPort
// with Name FromName (sometimes a dummy).  Returns the arc, the
// ToNode, and the arc kind.

void FindArc(MString &FromName, cAbsTree *FromNode, cArc **a, ArcKind *k,
	     cAbsTree **ToNode)
{
  cGraph *g;
  cObIterator i;
  cObject *p;
  cArc *at;

  g = (cGraph *) (FromNode->Parent);

  for (p = i.Init(g->Arcs); i.MoreLeft(); p = i.Next()) {
    at = (cArc *) p;
    if (at->FromUID == FromNode->UID) {
      *ToNode = FindUidTable(at->ToUID);

      switch (FromNode->IsA()) {

      case UC:
	switch ((*ToNode)->IsA()) {
	case UC:
	  if ((char *) at->FromPort == FromName) {
	    *a = at;
	    *k = kUC_UC;
	    return;
	  }
	  break;
	case CallNode:
	  if ((char *) at->FromPort == FromName) {
	    *a = at;
	    *k = kUC_Call;
	    return;
	  }
	  break;
	case IntNode:
	  if ((char *) at->FromPort == FromName) {
	    *a = at;
	    *k = kUC_OI;
	    return;
	  }
	  break;
	case NSRel:
	  if ((char *) at->FromPort == FromName) {
	    *a = at;
	    *k = kUC_NS;
	    return;
	  }
	  break;
	default:
	  Die("Internal error: FindArc (UC) lacks to node case.\n");
	  break;
	}
	break;

      case IntNode:
	switch ((*ToNode)->IsA()) {
	case UC:
	  *a = at;
	  *k = kII_UC;
	  return;
	case CallNode:
	  *a = at;
	  *k = kII_Call;
	  return;
	case IntNode:
	  *a = at;
	  *k = kII_OI;
	  return;
	case NSRel:
	  *a = at;
	  *k = kII_NS;
	  return;
	default:
	  Die("Internal error: FindArc (IntNode) lacks to node case.\n");
	  break;
	}
	break;

      case CallNode:
	switch ((*ToNode)->IsA()) {
	case UC:
	  if ((char *) at->FromPort == FromName) {
	    *a = at;
	    *k = kCall_UC;
	    return;
	  }
	  break;
	case CallNode:
	  if ((char *) at->FromPort == FromName) {
	    *a = at;
	    *k = kCall_Call;
	    return;
	  }
	  break;
	case IntNode:
	  if ((char *) at->FromPort == FromName) {
	    *a = at;
	    *k = kCall_OI;
	    return;
	  }
	  break;
	case NSRel:
	  if ((char *) at->FromPort == FromName) {
	    *a = at;
	    *k = kCall_NS;
	    return;
	  }
	  break;
	default:
	  Die("Internal error: FindArc (UC) lacks to node case.\n");
	  break;
	}
	break;

      default:
	Die("Internal error: FindArc lacks from node case.\n");
	break;
      }
    }
  }
 
  Die("Internal error: No match in FindMatchingArc\n");
}
