/*
  translate.h
  ------------------------------------------------------------------------
    
  ------------------------------------------------------------------------
  @(#) $Id: translate.h,v 1.10 1997/01/28 00:00:25 emery Exp $
  ------------------------------------------------------------------------
  AUTHOR/CONTACT:
 
  Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
  Systems Analyst                 @           <mailto:emery@cs.utexas.edu>
  Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
  Department of Computer Sciences |             <http://www.cs.utexas.edu>
  University of Texas at Austin   |                <http://www.utexas.edu>
  ========================================================================
*/

#ifndef _Translate_x
#define _Translate_x

#include "misc/general.h"
#include "exmodel/exmodel.h"
#include "misc/sfile.h"
#include "misc/mstring.h"

enum ArcKind { kUC_UC, kUC_Call, kUC_OI, kUC_NS, kCall_UC, kCall_Call,
		 kCall_OI, kCall_NS, kII_UC, kII_Call, kII_NS, kII_OI};

extern int StartNodeUID;
extern int StartGraphUID;

void FixMe(char *s);

int Translate(int Option);

 // e must be a port expression in an arc input or arc output.
 // FindPortName returns the portname in the expression.

MString FindPortName(cExpr *e);

 // e must be a port expression in an arc input or arc output.
 // Writes a sequence of statements that set a _c2_Index variable
 // according to the port expr.  FillIndVar returns the number of
 // indices **** or -1 which means there are no indices *****

int FillIndVar(cCursor &c, MString Name, cExpr *e, int ic);

  // Finds the arc leaving given node (FromNode) attached to FromPort
  // with Name FromName (sometimes a dummy).  Returns the arc, the
  // ToNode, and the arc kind.

void FindArc(MString &FromName, cAbsTree *FromNode, cArc **a, ArcKind *k,
	     cAbsTree **ToNode);

#endif
