//   - buildstab
//   - setting parent pointers
//   - populating the symbol table

#include <stream.h>
#include "../misc/general.h"
#include "../exmodel/abstree.h"
#include "../exmodel/exmodel.h"
#include "../exmodel/object.h"
#include "../symtab/stype.h"
#include "../symtab/symtab.h"

#include "pass.h"

int PassOK;

void cIdent::BuildSymTab()
{
}


void cIntConst::BuildSymTab()
{
}


void cRealConst::BuildSymTab()
{
}


void cStateFuncCall::BuildSymTab()
{
   cObIterator i;
   cObject *p;

   if (!PassOK) return;                 // Pass aborted

   for (p = i.Init(Args); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->BuildSymTab();
   }
}


void cFuncCallOp::BuildSymTab()
{
   cObIterator i;
   cObject *p;

   if (!PassOK) return;                 // Pass aborted

   for (p = i.Init(Args); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->BuildSymTab();
   }
}


void cNotOp::BuildSymTab()
{
   if (!PassOK) return;                 // Pass aborted

   ((cAbsTree *) Left)->Parent = this;
   ((cAbsTree *) Left)->BuildSymTab();
}


void cUnaryMinusOp::BuildSymTab()
{
   if (!PassOK) return;                 // Pass aborted

   ((cAbsTree *) Left)->Parent = this;
   ((cAbsTree *) Left)->BuildSymTab();
}


void cOrOp::BuildSymTab()
{
   if (!PassOK) return;                 // Pass aborted

   ((cAbsTree *) Left)->Parent = this;
   ((cAbsTree *) Left)->BuildSymTab();

   ((cAbsTree *) Right)->Parent = this;
   ((cAbsTree *) Right)->BuildSymTab();
}


void cAndOp::BuildSymTab()
{
   if (!PassOK) return;                 // Pass aborted

   ((cAbsTree *) Left)->Parent = this;
   ((cAbsTree *) Left)->BuildSymTab();

   ((cAbsTree *) Right)->Parent = this;
   ((cAbsTree *) Right)->BuildSymTab();
}


void cNEOp::BuildSymTab()
{
   if (!PassOK) return;                 // Pass aborted

   ((cAbsTree *) Left)->Parent = this;
   ((cAbsTree *) Left)->BuildSymTab();

   ((cAbsTree *) Right)->Parent = this;
   ((cAbsTree *) Right)->BuildSymTab();
}


void cEqOp::BuildSymTab()
{
   if (!PassOK) return;                 // Pass aborted

   ((cAbsTree *) Left)->Parent = this;
   ((cAbsTree *) Left)->BuildSymTab();

   ((cAbsTree *) Right)->Parent = this;
   ((cAbsTree *) Right)->BuildSymTab();
}


void cGEOp::BuildSymTab()
{
   if (!PassOK) return;                 // Pass aborted

   ((cAbsTree *) Left)->Parent = this;
   ((cAbsTree *) Left)->BuildSymTab();

   ((cAbsTree *) Right)->Parent = this;
   ((cAbsTree *) Right)->BuildSymTab();
}


void cLEOp::BuildSymTab()
{
   if (!PassOK) return;                 // Pass aborted

   ((cAbsTree *) Left)->Parent = this;
   ((cAbsTree *) Left)->BuildSymTab();

   ((cAbsTree *) Right)->Parent = this;
   ((cAbsTree *) Right)->BuildSymTab();
}


void cLTOp::BuildSymTab()
{
   if (!PassOK) return;                 // Pass aborted

   ((cAbsTree *) Left)->Parent = this;
   ((cAbsTree *) Left)->BuildSymTab();

   ((cAbsTree *) Right)->Parent = this;
   ((cAbsTree *) Right)->BuildSymTab();
}


void cGTOp::BuildSymTab()
{
   if (!PassOK) return;                 // Pass aborted

   ((cAbsTree *) Left)->Parent = this;
   ((cAbsTree *) Left)->BuildSymTab();

   ((cAbsTree *) Right)->Parent = this;
   ((cAbsTree *) Right)->BuildSymTab();
}


void cMinusOp::BuildSymTab()
{
   if (!PassOK) return;                 // Pass aborted

   ((cAbsTree *) Left)->Parent = this;
   ((cAbsTree *) Left)->BuildSymTab();

   ((cAbsTree *) Right)->Parent = this;
   ((cAbsTree *) Right)->BuildSymTab();
}


void cPlusOp::BuildSymTab()
{
   if (!PassOK) return;                 // Pass aborted

   ((cAbsTree *) Left)->Parent = this;
   ((cAbsTree *) Left)->BuildSymTab();

   ((cAbsTree *) Right)->Parent = this;
   ((cAbsTree *) Right)->BuildSymTab();
}


void cModOp::BuildSymTab()
{
   if (!PassOK) return;                 // Pass aborted

   ((cAbsTree *) Left)->Parent = this;
   ((cAbsTree *) Left)->BuildSymTab();

   ((cAbsTree *) Right)->Parent = this;
   ((cAbsTree *) Right)->BuildSymTab();
}


void cDivOp::BuildSymTab()
{
   if (!PassOK) return;                 // Pass aborted

   ((cAbsTree *) Left)->Parent = this;
   ((cAbsTree *) Left)->BuildSymTab();

   ((cAbsTree *) Right)->Parent = this;
   ((cAbsTree *) Right)->BuildSymTab();
}


void cMultOp::BuildSymTab()
{
   if (!PassOK) return;                 // Pass aborted

   ((cAbsTree *) Left)->Parent = this;
   ((cAbsTree *) Left)->BuildSymTab();

   ((cAbsTree *) Right)->Parent = this;
   ((cAbsTree *) Right)->BuildSymTab();
}


void cSelectOp::BuildSymTab()
{
   if (!PassOK) return;                 // Pass aborted

   ((cAbsTree *) Left)->Parent = this;
   ((cAbsTree *) Left)->BuildSymTab();

   ((cAbsTree *) Right)->Parent = this;
   ((cAbsTree *) Right)->BuildSymTab();
}


void cArrayIndOp::BuildSymTab()
{
   if (!PassOK) return;                 // Pass aborted

   ((cAbsTree *) Left)->Parent = this;
   ((cAbsTree *) Left)->BuildSymTab();

   ((cAbsTree *) Right)->Parent = this;
   ((cAbsTree *) Right)->BuildSymTab();
}


void cFuncArgSpec::BuildSymTab()
{
   if (!PassOK) return;                 // Pass aborted

   ((cAbsTree *) TypeName)->Parent = this;
   ((cAbsTree *) TypeName)->BuildSymTab();

   ((cAbsTree *) ArgName)->Parent = this;
   ((cAbsTree *) ArgName)->BuildSymTab();
}


void cFuncSig::BuildSymTab()
{
   cObIterator i;
   cObject *p;

   if (!PassOK) return;                 // Pass aborted

   ((cAbsTree *) FuncName)->Parent = this;
   ((cAbsTree *) FuncName)->BuildSymTab();

   if (ReturnType != 0) {
      ((cAbsTree *) ReturnType)->Parent = this;
      ((cAbsTree *) ReturnType)->BuildSymTab();
   }

   for (p = i.Init(Args); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->BuildSymTab();
   }
}


void cArc::BuildSymTab()
{
   cObIterator i;
   cObject *p;

   if (!PassOK) return;                 // Pass aborted

   ((cAbsTree *) FromPort)->Parent = this;
   ((cAbsTree *) FromPort)->BuildSymTab();

   ((cAbsTree *) ToPort)->Parent = this;
   ((cAbsTree *) ToPort)->BuildSymTab();

   for (p = i.Init(CallVarList); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->BuildSymTab();
   }

   for (p = i.Init(NodeVarList); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->BuildSymTab();
   }

   for (p = i.Init(PortVarList); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->BuildSymTab();
   }

   for (p = i.Init(CallExprList); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->BuildSymTab();
   }

   for (p = i.Init(NodeExprList); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->BuildSymTab();
   }

   for (p = i.Init(PortExprList); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->BuildSymTab();
   }
}


void cNamedType::BuildSymTab()
{
   ((cAbsTree *) TypeName)->Parent = this;
   ((cAbsTree *) TypeName)->BuildSymTab();
}


void cArrayType::BuildSymTab()
{
   ((cAbsTree *) BaseType)->Parent = this;
   ((cAbsTree *) BaseType)->BuildSymTab();
}


void cStructMem::BuildSymTab()
{
   ((cAbsTree *) Type)->Parent = this;
   ((cAbsTree *) Type)->BuildSymTab();

   ((cAbsTree *) Name)->Parent = this;
   ((cAbsTree *) Name)->BuildSymTab();
}


void cStructType::BuildSymTab()
{
   cObIterator i;
   cObject *p;

   if (!PassOK) return;                 // Pass aborted

   for (p = i.Init(Members); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->BuildSymTab();
   }
}


void cTypeDef::BuildSymTab()
{
   if (!PassOK) return;                 // Pass aborted

   ((cAbsTree *) Type)->Parent = this;
   ((cAbsTree *) Type)->BuildSymTab();

   ((cAbsTree *) Name)->Parent = this;
   ((cAbsTree *) Name)->BuildSymTab();
}


void cCallStmt::BuildSymTab()
{
   cObIterator i;
   cObject *p;

   if (!PassOK) return;                 // Pass aborted

   ((cAbsTree *) FuncName)->Parent = this;
   ((cAbsTree *) FuncName)->BuildSymTab();

   for (p = i.Init(Args); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->BuildSymTab();
   }
}


void cWhileStmt::BuildSymTab()
{
   if (!PassOK) return;                 // Pass aborted

   ((cAbsTree *) Cond)->Parent = this;
   ((cAbsTree *) Cond)->BuildSymTab();

   ((cAbsTree *) Body)->Parent = this;
   ((cAbsTree *) Body)->BuildSymTab();
}


void cBlockStmt::BuildSymTab()
{
   cObIterator i;
   cObject *p;

   if (!PassOK) return;                 // Pass aborted

   for (p = i.Init(StmtList); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->BuildSymTab();
   }
}


void cIfStmt::BuildSymTab()
{
   if (!PassOK) return;                 // Pass aborted

   ((cAbsTree *) Cond)->Parent = this;
   ((cAbsTree *) Cond)->BuildSymTab();

   ((cAbsTree *) IfPart)->Parent = this;
   ((cAbsTree *) IfPart)->BuildSymTab();

   if (ElsePart != 0) {
      ((cAbsTree *) ElsePart)->Parent = this;
      ((cAbsTree *) ElsePart)->BuildSymTab();
   }
}


void cAssignStmt::BuildSymTab()
{
   if (!PassOK) return;                 // Pass aborted

   ((cAbsTree *) LHS)->Parent = this;
   ((cAbsTree *) LHS)->BuildSymTab();

   ((cAbsTree *) RHS)->Parent = this;
   ((cAbsTree *) RHS)->BuildSymTab();
}


void cNullStmt::BuildSymTab()
{
}


void cArraySize::BuildSymTab()
{
   if (!PassOK) return;                 // Pass aborted

   ((cAbsTree *) SizeSpec)->Parent = this;
   ((cAbsTree *) SizeSpec)->BuildSymTab();
}


void cVarDecl::BuildSymTab()
{
   cObIterator i;
   cObject *p;

   if (!PassOK) return;                 // Pass aborted

   ((cAbsTree *) VarName)->Parent = this;
   ((cAbsTree *) VarName)->BuildSymTab();

   ((cAbsTree *) TypeName)->Parent = this;
   ((cAbsTree *) TypeName)->BuildSymTab();

   for (p = i.Init(ArraySizes); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->BuildSymTab();
   }
}


void cNSRel::BuildSymTab()
{
   cObIterator i;
   cObject *p;

   if (!PassOK) return;                 // Pass aborted

   if (InitComp != 0) {
      ((cAbsTree *) InitComp)->Parent = this;
      ((cAbsTree *) InitComp)->BuildSymTab();
   }

   for (p = i.Init(FuncSigs); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->BuildSymTab();
   }

   for (p = i.Init(SharedVars); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->BuildSymTab();
   }

   for (p = i.Init(LocalVars); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->BuildSymTab();
   }
}


void cReplSpec::BuildSymTab()
{
   if (!PassOK) return;                 // Pass aborted

   ((cAbsTree *) IndVar)->Parent = this;
   ((cAbsTree *) IndVar)->BuildSymTab();

   ((cAbsTree *) Bound)->Parent = this;
   ((cAbsTree *) Bound)->BuildSymTab();
}


void cGuard::BuildSymTab()
{
   if (!PassOK) return;                 // Pass aborted

   ((cAbsTree *) Cond)->Parent = this;
   ((cAbsTree *) Cond)->BuildSymTab();
}


void cReplGuard::BuildSymTab()
{
   cObIterator i;
   cObject *p;

   if (!PassOK) return;                 // Pass aborted

   ((cAbsTree *) Cond)->Parent = this;
   ((cAbsTree *) Cond)->BuildSymTab();

   if (ReplCond != 0) {
      ((cAbsTree *) ReplCond)->Parent = this;
      ((cAbsTree *) ReplCond)->BuildSymTab();
   }

   for (p = i.Init(Repls); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->BuildSymTab();
   }
}


void cBinding::BuildSymTab()
{
   if (!PassOK) return;                 // Pass aborted

   ((cAbsTree *) Bind)->Parent = this;
   ((cAbsTree *) Bind)->BuildSymTab();
}


void cReplBinding::BuildSymTab()
{
   cObIterator i;
   cObject *p;

   if (!PassOK) return;                 // Pass aborted

   ((cAbsTree *) Bind)->Parent = this;
   ((cAbsTree *) Bind)->BuildSymTab();

   if (ReplCond != 0) {
      ((cAbsTree *) ReplCond)->Parent = this;
      ((cAbsTree *) ReplCond)->BuildSymTab();
   }

   for (p = i.Init(Repls); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->BuildSymTab();
   }
}


void cRule::BuildSymTab()
{
   cObIterator i;
   cObject *p;

   if (!PassOK) return;                 // Pass aborted

   for (p = i.Init(Guards); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->BuildSymTab();
   }

   for (p = i.Init(Binds); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->BuildSymTab();
   }
}


void cReplRule::BuildSymTab()
{
   cObIterator i;
   cObject *p;

   if (!PassOK) return;                 // Pass aborted

   for (p = i.Init(Guards); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->BuildSymTab();
   }

   for (p = i.Init(Binds); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->BuildSymTab();
   }

   if (ReplCond != 0) {
      ((cAbsTree *) ReplCond)->Parent = this;
      ((cAbsTree *) ReplCond)->BuildSymTab();
   }

   for (p = i.Init(Repls); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->BuildSymTab();
   }
}


void cPortSpec::BuildSymTab()
{
   if (!PassOK) return;                 // Pass aborted

   ((cAbsTree *) TypeName)->Parent = this;
   ((cAbsTree *) TypeName)->BuildSymTab();

   ((cAbsTree *) PortName)->Parent = this;
   ((cAbsTree *) PortName)->BuildSymTab();
}


void cNSPortSpec::BuildSymTab()
{
   if (!PassOK) return;                 // Pass aborted

   ((cAbsTree *) TypeName)->Parent = this;
   ((cAbsTree *) TypeName)->BuildSymTab();

   ((cAbsTree *) PortName)->Parent = this;
   ((cAbsTree *) PortName)->BuildSymTab();
}


void cUC::BuildSymTab()
{
   cObIterator i;
   cObject *p;

   if (!PassOK) return;                 // Pass aborted

   if (InitComp != 0) {
      ((cAbsTree *) InitComp)->Parent = this;
      ((cAbsTree *) InitComp)->BuildSymTab();
   }

   if (Comp != 0) {
      ((cAbsTree *) Comp)->Parent = this;
      ((cAbsTree *) Comp)->BuildSymTab();
   }

   for (p = i.Init(FuncSigs); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->BuildSymTab();
   }

   for (p = i.Init(InputPorts); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->BuildSymTab();
   }

   for (p = i.Init(OutputPorts); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->BuildSymTab();
   }

   for (p = i.Init(NSPorts); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->BuildSymTab();
   }

   for (p = i.Init(LocalVars); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->BuildSymTab();
   }

   for (p = i.Init(InRules); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->BuildSymTab();
   }

   for (p = i.Init(OutRules); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->BuildSymTab();
   }
}


void cIntNode::BuildSymTab()
{
}


void cCrepNode::BuildSymTab()
{
}


void cCallNode::BuildSymTab()
{
}


void cGraph::BuildSymTab()
{
   cObIterator i;
   cObject *p;

   if (!PassOK) return;                 // Pass aborted

   for (p = i.Init(FuncSigs); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->BuildSymTab();
   }

   for (p = i.Init(Types); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->BuildSymTab();
   }

   for (p = i.Init(IntNodes); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->BuildSymTab();
   }

   for (p = i.Init(CrepNodes); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->BuildSymTab();
   }

   for (p = i.Init(UCNodes); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->BuildSymTab();
   }

   for (p = i.Init(CallNodes); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->BuildSymTab();
   }

   for (p = i.Init(NSRelNodes); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->BuildSymTab();
   }

   for (p = i.Init(Arcs); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->BuildSymTab();
   }
}


void cProgram::BuildSymTab()
{
   cObIterator i;
   cObject *p;
   cSETypeName *NewEntry;

   PassOK = 1;   // OK at start
   SymbolTable = new cSymTab;

   // Add built-in types to global symbol table
   NewEntry = new cSETypeName;
   NewEntry->Type = new cIntSType;
   if (!SymbolTable->Insert("int", NewEntry)) Die("int already declared!\n");

   NewEntry = new cSETypeName;
   NewEntry->Type = new cRealSType;
   if (!SymbolTable->Insert("real", NewEntry)) Die("real already declared!\n");

   NewEntry = new cSETypeName;
   NewEntry->Type = new cCharSType;
   if (!SymbolTable->Insert("char", NewEntry)) Die("char already declared!\n");
   
   for (p = i.Init(Types); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->BuildSymTab();
   }

   for (p = i.Init(FuncSigs); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->BuildSymTab();
   }

   for (p = i.Init(Graphs); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->BuildSymTab();
   }
}

