#include <config.h>
#include <stream.h>
#include <ctype.h>
#include <misc/general.h>
#include <exmodel/abstree.h>
#include <exmodel/exmodel.h>
#include <symtab/symtab.h>
#include <symtab/symtabent.h>

#include "pass.h"
#include <lib/MsgUI.h>


static int LegalIdent(MString S)
{
   int i;

   if (S.length() > 0 && isalpha(S[0])) {
      for (i = 1; i < S.length(); i++) {
         if (!isalnum(S[i]) && S[i] != '_')
            return 0;
      }
      return 1;
   } else 
      return 0;
}


//void cIdent::MakeSTEntry(cSymTab *SymTab)
//{
//}
//
//
//void cIntConst::MakeSTEntry(cSymTab *SymTab)
//{
//}
//
//
//void cRealConst::MakeSTEntry(cSymTab *SymTab)
//{
//}
//
//
//void cStateFuncCall::MakeSTEntry(cSymTab *SymTab)
//{
//}
//
//
//void cFuncCallOp::MakeSTEntry(cSymTab *SymTab)
//{
//}
//
//
//void cNotOp::MakeSTEntry(cSymTab *SymTab)
//{
//}
//
//
//void cUnaryMinusOp::MakeSTEntry(cSymTab *SymTab)
//{
//}
//
//
//void cOrOp::MakeSTEntry(cSymTab *SymTab)
//{
//}
//
//
//void cAndOp::MakeSTEntry(cSymTab *SymTab)
//{
//}
//
//
//void cNEOp::MakeSTEntry(cSymTab *SymTab)
//{
// }
//
//
//void cEqOp::MakeSTEntry(cSymTab *SymTab)
//{
//}
//
//
//void cGEOp::MakeSTEntry(cSymTab *SymTab)
//{
//}
//
//
//void cLEOp::MakeSTEntry(cSymTab *SymTab)
//{
//}
//
//
//void cLTOp::MakeSTEntry(cSymTab *SymTab)
//{
//}
//
//
//void cGTOp::MakeSTEntry(cSymTab *SymTab)
//{
//}
//
//
//void cMinusOp::MakeSTEntry(cSymTab *SymTab)
//{
//}
//
//
//void cPlusOp::MakeSTEntry(cSymTab *SymTab)
//{
//}
//
//
//void cModOp::MakeSTEntry(cSymTab *SymTab)
//{
//}
//
//
//void cDivOp::MakeSTEntry(cSymTab *SymTab)
//{
//}
//
//
//void cMultOp::MakeSTEntry(cSymTab *SymTab)
//{
//}
//
//
//void cSelectOp::MakeSTEntry(cSymTab *SymTab)
//{
//}
//
//
//void cArrayIndOp::MakeSTEntry(cSymTab *SymTab)
//{
//}
//
//
//void cFuncArgSpec::MakeSTEntry(cSymTab *SymTab)
//{
//}


void cFuncSig::MakeSTEntry(cSymTab *SymTab) //cIdent ReturnType& FuncName& Args
{
   cObIterator i;
   cObject *Object;
   cFuncArgSpec *ASTArg;
   cSEFuncArg *STEArg;
   cSETypeName *SETypeName;
   int passed;

   cSEFuncName *SEFuncName = new cSEFuncName; // returntype & arglist
   SEFuncName->IsPolyMorphic = 0;
   SEFuncName->DontCheckArgs = DontCheckArgs;

   if (ReturnType == MString("")) { // return type void?
      SEFuncName->ReturnType = 0;
   } else {
      SETypeName = (cSETypeName *) GetSymbol(ReturnType, this, ::SETypeName, 0);
      if (SETypeName != 0)
         SEFuncName->ReturnType = SETypeName->Type;
      else {
         delete SEFuncName;
         YYUIMessage(UID, ErrorLevel, "(In cFuncSig) "
                 "Function \"%s\"'s return type, \"%s\" is undefined.\n", 
                 (char *)FuncName, (char *)ReturnType);
         longjmp(PassEnv, 1);
      }
   }
   if (!DontCheckArgs) {
      for (Object = (cObject *)i.Init(Args); i.MoreLeft(); Object = (cObject *)i.Next()) {
         ASTArg = (cFuncArgSpec *)Object;
         SETypeName = (cSETypeName *) 
           GetSymbol(ASTArg->TypeName, this, ::SETypeName, 0);
         if (SETypeName != 0) {
            STEArg = new cSEFuncArg; 
            STEArg->Type = SETypeName->Type;
            STEArg->IsByValue = 1 - ASTArg->Reference;
            (SEFuncName->ArgList).Append(STEArg);
         } else {
            delete SEFuncName;
            YYUIMessage(UID, ErrorLevel, "(In cFuncSig) "
              "Function \"%s\"'s argument \"%s\"'s type, \"%s\", is undefined.\n", 
              (char *)FuncName, (char *)ASTArg->ArgName, 
              (char *)ASTArg->TypeName);  
            longjmp(PassEnv, 1);
         }
      }
   } 
   passed = SymTab->Insert(FuncName, SEFuncName);
   if (passed == 0) {
      delete SEFuncName;
      YYUIMessage(UID, ErrorLevel, "(In cFuncSig) Function \"%s\"'s identifier is "
        "already defined.\n", (char *)FuncName);  
      longjmp(PassEnv, 1);
   }
}


//void cArc::MakeSTEntry(cSymTab *SymTab)
//{
//}
//
//
//void cNamedType::MakeSTEntry(cSymTab *SymTab)
//{
//}
//
//
//void cArrayType::MakeSTEntry(cSymTab *SymTab)
//{
//}
//
//
//void cStructMem::MakeSTEntry(cSymTab *SymTab)
//{
//}
//
//
//void cStructType::MakeSTEntry(cSymTab *SymTab)
//{
//}


void cTypeDef::MakeSTEntry(cSymTab *SymTab)
// start with : cTypeDef : Name, cAbsTree *Type
// need to create : cSETypeName : cSType *Type
{
   cSETypeName *SETypeName = new cSETypeName;
   int passed;
   ClassId CId;

   // i) Name Type (type foo is bar;) => get bar's cStype via GetSymbol
   // ii) Array Type (type foo is array of bar) => create cSType entry 
   // iii) Struct Type (type foo is struct {int i; real j};) => 
   //    create cSType entry

   CId = Type->IsA();

   switch (CId) {
   case NamedType:
   {
      cNamedType *NamedType = (cNamedType *)Type; 
      cSETypeName *SETypeName = (cSETypeName *)
        GetSymbol(NamedType->TypeName, this, ::SETypeName, 0);

      if (SETypeName != 0) {
         cSETypeName *newSETypeName = new cSETypeName;
         newSETypeName->Type = SETypeName->Type;
         newSETypeName->UserBaseTypeName = NamedType->TypeName;
         int passed = SymTab->Insert(Name, newSETypeName);

         if (passed == 0) {
            YYUIMessage(UID, ErrorLevel, "(In cTypeDef) Type \"%s\"'s identifier is "
              "already defined.\n", (char *)Name);  
            longjmp(PassEnv, 1);
         }
      } else {
         YYUIMessage(UID, ErrorLevel, "(In cTypeDef,) Base Type \"%s\" is undefined.\n",
           (char *)NamedType->TypeName);  
         longjmp(PassEnv, 1);
      }
   }
      break;
   case ArrayType:
   {
      cArrayType *ArrayType = (cArrayType *)Type;
      cSETypeName *SETypeName = (cSETypeName *)
        GetSymbol(ArrayType->BaseType, this, ::SETypeName, 0);

      if (SETypeName != 0) {
         cArraySType *ArraySType = new cArraySType;
         ArraySType->BaseType = SETypeName->Type;
         ArraySType->TypeName = Name;

         cSETypeName *newSETypeName = new cSETypeName;
         newSETypeName->Type = ArraySType;
         newSETypeName->UserBaseTypeName = ArrayType->BaseType;
         int passed = SymTab->Insert(Name, newSETypeName);

         if (passed == 0) {
            YYUIMessage(UID, ErrorLevel, "(In cTypeDef) Type \"%s\"'s identifier is "
              "already defined.\n", (char *)Name);  
            longjmp(PassEnv, 1);
          }
      } else {
         YYUIMessage(UID, ErrorLevel, "(In cTypeDef) Base type \"%s\" of array \"%s\""
            " is undefined.\n", (char *)ArrayType->BaseType, (char *)Name);  
         longjmp(PassEnv, 1);
      }
   }
      break;
   case StructType:
   {
      cObIterator i;
      cObject *Object;

      cStructSType *StructSType = new cStructSType;
      cStructType *StructType = (cStructType *)Type;

      for (Object = i.Init(StructType->Members); i.MoreLeft(); Object = i.Next()) {
         cStructMem *StructMem = (cStructMem *)Object;

         cSETypeName *SETypeName = (cSETypeName *)
           GetSymbol(StructMem->Type, this, ::SETypeName, 0);
         if (SETypeName != 0) {
            cStructMemSType *StructMemSType = new cStructMemSType;
            StructMemSType->Ident = StructMem->Name;
            StructMemSType->Type = SETypeName->Type;
            (StructSType->Members).Insert(StructMemSType);
         } else {
            YYUIMessage(UID, ErrorLevel, "(In cTypeDef) : Type \"%s\" in Struct"
              " \"%s\" is undefined.\n", (char *)StructMem->Type, (char *)Name);  
            longjmp(PassEnv, 1);
         }
      }
      StructSType->TypeName = Name;

      cSETypeName *newSETypeName = new cSETypeName;
      newSETypeName->Type = StructSType;
      //for (Object = i.Init(StructType->Members); i.MoreLeft(); Object = i.Next()) {
      //   cStructMem *StructMem = (cStructMem *)Object;
      //   newSETypeName->AuxStructInfo.AddMember(StructMem->Name, StructMem->Type);
      //}
      int passed = SymTab->Insert(Name, newSETypeName);

      if (passed == 0) {
         YYUIMessage(UID, ErrorLevel, "(In cTypeDef) Struct \"%s\"'s identifier is "
           "already defined.\n", (char *)Name);  
         longjmp(PassEnv, 1);
       }      
   }
      break;
   default:
      Die("I've fallen in cTypeDef::MakeSTEntry and I can't get up.\n"); 
   }


   //SETypeName = (cSETypeName *) GetSymbol(ReturnType, this, ::SETypeName, 0);

   passed = SymTab->Insert(Name, SETypeName);
}


//void cCallStmt::MakeSTEntry(cSymTab *SymTab)
//{
//
//
//void cWhileStmt::MakeSTEntry(cSymTab *SymTab)
//{
//}
//
//
//void cBlockStmt::MakeSTEntry(cSymTab *SymTab)
//{
//}
//
//
//void cIfStmt::MakeSTEntry(cSymTab *SymTab)
//{
//}
//
//
//void cAssignStmt::MakeSTEntry(cSymTab *SymTab)
//{
//}
//
//
//void cNullStmt::MakeSTEntry(cSymTab *SymTab)
//{
//}
//
//
//void cArraySize::MakeSTEntry(cSymTab *SymTab)
//{
//}


void cVarDecl::MakeSTEntry(cSymTab *SymTab)
{
   cSETypeName *SETypeName = (cSETypeName *)GetSymbol(TypeName, this, ::SETypeName, 0);
   if (SETypeName != 0) { 
      cSEVariable *SEVariable = new cSEVariable;
      SEVariable->Type = SETypeName->Type;

      int passed = SymTab->Insert(VarName, SEVariable);
      if (passed == 0) {
         delete SEVariable;
         YYUIMessage(UID, ErrorLevel, "(In  cVarDecl) Variable \"%s\"'s identifier is "
           "already defined.\n", (char *)VarName);  
         longjmp(PassEnv, 1);
       }
   } else {
      YYUIMessage(UID, ErrorLevel, "(In  cVarDecl) Type \"%s\" is undefined"
        ".\n", (char *)TypeName);  
      longjmp(PassEnv, 1);
   }
}


//void cNSRel::MakeSTEntry(cSymTab *SymTab)
//{
//}


void cReplSpec::MakeSTEntry(cSymTab *SymTab)
{
   cSETypeName *SETypeName = (cSETypeName *)GetSymbol("int", this, ::SETypeName, 0);
   if (SETypeName != 0) { 
      cSEVariable *SEVariable = new cSEVariable;
      SEVariable->Type = SETypeName->Type;

      int passed = SymTab->Insert(IndVar, SEVariable);
      if (passed == 0) {
         delete SEVariable;
         YYUIMessage(UID, ErrorLevel, "(In  cReplSpec) Index variable  \"%s\"'s identifier is "
           "already defined.\n", (char *)IndVar);  
         longjmp(PassEnv, 1);
       }
   } else {
      YYUIMessage(UID, ErrorLevel, "(In  cReplSpec) Identifier int is "
        "undefined.\n"); 
      // could be a DIE instead 
      longjmp(PassEnv, 1);
   }
}


//void cGuard::MakeSTEntry(cSymTab *SymTab)
//{
//}
//
//
//void cReplGuard::MakeSTEntry(cSymTab *SymTab)
//{
//}
//
//
//void cBinding::MakeSTEntry(cSymTab *SymTab)
//{
//}
//
//
//void cReplBinding::MakeSTEntry(cSymTab *SymTab)
//{
//}
//
//
//void cRule::MakeSTEntry(cSymTab *SymTab)
//{
//}
//
//
//void cReplRule::MakeSTEntry(cSymTab *SymTab)
//{
//}


void cPortSpec::MakeSTEntry(cSymTab *SymTab)
{
   cSETypeName *SETypeName = (cSETypeName *)
     GetSymbol(TypeName, this, ::SETypeName, 0);
   cPortSType *NewSPort = new cPortSType;

   if (SETypeName != 0) { 
      cSEPortName *SEPortName = new cSEPortName;
      NewSPort->BaseType = SETypeName->Type;
      SEPortName->Type = NewSPort;
      SEPortName->IsInputPort = IsInputPort;
      NewSPort->IsInputPort = IsInputPort;

      int passed = SymTab->Insert(PortName, SEPortName);
      if (passed == 0) {
         delete SEPortName;
         YYUIMessage(UID, ErrorLevel, "(In  cCrepNode) Port \"%s\"'s identifier is "
           "already defined.\n", (char *)PortName);  
         longjmp(PassEnv, 1);
       }
   } else {
      YYUIMessage(UID, ErrorLevel, "(In  cCrepNode) Type \"%s\" is undefined"
        ".\n", (char *)TypeName);  
      longjmp(PassEnv, 1);
   }
}


void cNSPortSpec::MakeSTEntry(cSymTab *SymTab)
{
   cSETypeName *SETypeName = (cSETypeName *)
     GetSymbol(TypeName, this, ::SETypeName, 0);
   if (SETypeName != 0) { 
      cSESharedVar *SESharedVar = new cSESharedVar;
      SESharedVar->Type = SETypeName->Type;

      int passed = SymTab->Insert(PortName, SESharedVar);
      if (passed == 0) {
         delete SESharedVar;
         YYUIMessage(UID, ErrorLevel, "(In  cNSPortSpec) Port \"%s\"'s identifier is "
           "already defined.\n", (char *)PortName);  
         longjmp(PassEnv, 1);
       }
   } else {
      YYUIMessage(UID, ErrorLevel, "(In  cNSPortSpec) Type \"%s\" is "
        "undefined.\n", (char *)TypeName);  
      longjmp(PassEnv, 1);
   }
}


//void cUC::MakeSTEntry(cSymTab *SymTab)
//{
//}


void cIntNode::MakeSTEntry(cSymTab *SymTab)
{
   // Name and Type are not parsed and can not be guaranteed to be legal identifiers
   if (LegalIdent(Name) == 0) {
      YYUIMessage(UID, ErrorLevel, "Interface Node name \"%s\" is not a legal identifier.\n",
        (char *)Name);
      longjmp(PassEnv, 1);
   }
   if (LegalIdent(Type) == 0) {
      YYUIMessage(UID, ErrorLevel, "Type, \"%s\", for Interface Node \"%s\" is not a legal "
        "identifier.\n", (char *)Type, (char *)Name);
      longjmp(PassEnv, 1);
   }

   cSETypeName *SETypeName = (cSETypeName *)GetSymbol(Type, this, ::SETypeName, 0);
   if (SETypeName != 0) { 
      cSEIntNode *SEIntNode = new cSEIntNode;
      SEIntNode->Type = SETypeName->Type;
      SEIntNode->IsInputNode = InParam;
      
      int passed = SymTab->Insert(Name, SEIntNode);
      if (passed == 0) {
         delete SEIntNode;
         YYUIMessage(UID, ErrorLevel, "(In  cIntNode) Interface Node \"%s\"'s identifier is "
           "already defined.\n", (char *)Name);  
         longjmp(PassEnv, 1);
       }
   } else {
      YYUIMessage(UID, ErrorLevel, "(In  cIntNode) Type \"%s\" is undefined"
        ".\n", (char *)Type);  
      longjmp(PassEnv, 1);
   }
}


void cCrepNode::MakeSTEntry(cSymTab *SymTab)
{
   // Name and Type are not parsed and can not be guaranteed to be legal identifiers
   if (LegalIdent(Name) == 0) {
      YYUIMessage(UID, ErrorLevel, "Interface Node name \"%s\" is not a legal identifier.\n",
        (char *)Name);
      longjmp(PassEnv, 1);
   }
   if (LegalIdent(Type) == 0) {
      YYUIMessage(UID, ErrorLevel, "Type, \"%s\", for Interface Node \"%s\" is not a legal "
        "identifier.\n", (char *)Type, (char *)Name);
      longjmp(PassEnv, 1);
   }

   cSETypeName *SETypeName = (cSETypeName *)GetSymbol(Type, this, ::SETypeName, 0);
   if (SETypeName != 0) { 
      cSECreP *SECreP = new cSECreP;
      SECreP->Type = SETypeName->Type;

      int passed = SymTab->Insert(Name, SECreP);
      if (passed == 0) {
         delete SECreP;
         YYUIMessage(UID, ErrorLevel, "(In  cCrepNode) Creation Parameter \"%s\"'s identifier is "
           "already defined.\n", (char *)Name);  
         longjmp(PassEnv, 1);
       }
   } else {
      YYUIMessage(UID, ErrorLevel, "(In  cCrepNode) Type \"%s\" is undefined"
        ".\n", (char *)Type);  
      longjmp(PassEnv, 1);
   }
}


//void cCallNode::MakeSTEntry(cSymTab *SymTab)
//{
//}


void cGraph::MakeSTEntry(cSymTab *SymTab)
{
   int passed;
   cSEGraph *g = new cSEGraph;

   g->Graph = this;
   passed = SymTab->Insert(Name, g);

   if (!passed) {
      delete g;
      YYUIMessage(UID, ErrorLevel, "(In  cGraph) Graph \"%s\"'s identifier is already defined"
        ".\n", (char *)Name);  
      longjmp(PassEnv, 1);
   }
}


//void cProgram::MakeSTEntry(cSymTab *SymTab)
//{
//}
