#include <config.h>
//   - Pass1	
//   - setting parent pointers
//   - populating the symbol table
//   - make idents in expression exist in the symbol table

#include <stream.h>
#include <setjmp.h>

#include <misc/general.h>
#include <exmodel/abstree.h>
#include <exmodel/exmodel.h>
#include <exmodel/object.h>
#include <symtab/stype.h>
#include <symtab/symtab.h>
#include <lib/MsgUI.h>

#include "pass.h"

int PassOK;

jmp_buf PassEnv;  // for setjmp and longjump from here & MakeSTEntry


  // Put NodeIndex and GraphIndex into symbol table

static void AddGraphAndNode(cSymTab *st)
{
   cSEVariable *PredefinedVarEntry;
   cArraySType *IntArraySType = new cArraySType;
      
   IntArraySType->BaseType = new cIntSType;

   PredefinedVarEntry = new cSEVariable;
   PredefinedVarEntry->Type = IntArraySType;
   if (!st->Insert("NodeIndex", PredefinedVarEntry)) 
     Die("identifier NodeIndex already declared!\n");

   PredefinedVarEntry = new cSEVariable;
   PredefinedVarEntry->Type = IntArraySType;
   if (!st->Insert("GraphIndex", PredefinedVarEntry)) 
     Die("identifier GraphIndex already declared!\n");
}


void cIdent::Pass1()
{
   IsLHS = 1;
}


void cIntConst::Pass1()
{
   IsLHS = 0;
}


void cRealConst::Pass1()
{
   IsLHS = 0;
}


void cNewExpr::Pass1()
{
   if (!PassOK) return;

   IsLHS = 0;

   if (Sizes != 0) {
      Sizes->Parent = this;
      Sizes->Pass1();
   }
}


void cFuncCallOp::Pass1()
{
   cObIterator i;
   cObject *p;

   if (!PassOK) return;                 // Pass aborted

   IsLHS = 0;

   for (p = i.Init(Args); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->Pass1();
   }
}


void cNotOp::Pass1()
{

   if (!PassOK) return;                 // Pass aborted

   IsLHS = 0;

   if (Left == 0) Die("Internal Error: NULL Left in cNotOp::Pass1");

   ((cAbsTree *) Left)->Parent = this;
   ((cAbsTree *) Left)->Pass1();
}


void cUnaryMinusOp::Pass1()
{
   if (!PassOK) return;                 // Pass aborted

   IsLHS = 0;

   if (Left == 0) Die("Internal Error: NULL Left in cUnaryMinusOp::Pass1");

   ((cAbsTree *) Left)->Parent = this;
   ((cAbsTree *) Left)->Pass1();
}


void cOrOp::Pass1()
{
   if (!PassOK) return;                 // Pass aborted

   IsLHS = 0;

   if (Left == 0) Die("Internal Error: NULL Left in cOrOp::Pass1");
   if (Right == 0) Die("Internal Error: NULL Right in cOrOp::Pass1");

   ((cAbsTree *) Left)->Parent = this;
   ((cAbsTree *) Left)->Pass1();

   ((cAbsTree *) Right)->Parent = this;
   ((cAbsTree *) Right)->Pass1();
}


void cAndOp::Pass1()
{
   if (!PassOK) return;                 // Pass aborted

   IsLHS = 0;

   if (Left == 0) Die("Internal Error: NULL Left in cAndOp::Pass1");
   if (Right == 0) Die("Internal Error: NULL Right in cAndOp::Pass1");

   ((cAbsTree *) Left)->Parent = this;
   ((cAbsTree *) Left)->Pass1();

   ((cAbsTree *) Right)->Parent = this;
   ((cAbsTree *) Right)->Pass1();
}


void cNEOp::Pass1()
{
   if (!PassOK) return;                 // Pass aborted

   IsLHS = 0;

   if (Left == 0) Die("Internal Error: NULL Left in cNEOp::Pass1");
   if (Right == 0) Die("Internal Error: NULL Right in cNEOp::Pass1");

   ((cAbsTree *) Left)->Parent = this;
   ((cAbsTree *) Left)->Pass1();

   ((cAbsTree *) Right)->Parent = this;
   ((cAbsTree *) Right)->Pass1();
}


void cEqOp::Pass1()
{
   if (!PassOK) return;                 // Pass aborted

   IsLHS = 0;

   if (Left == 0) Die("Internal Error: NULL Left in cEqOp::Pass1");
   if (Right == 0) Die("Internal Error: NULL Right in cEqOp::Pass1");

   ((cAbsTree *) Left)->Parent = this;
   ((cAbsTree *) Left)->Pass1();

   ((cAbsTree *) Right)->Parent = this;
   ((cAbsTree *) Right)->Pass1();
}


void cGEOp::Pass1()
{
   if (!PassOK) return;                 // Pass aborted

   IsLHS = 0;

   if (Left == 0) Die("Internal Error: NULL Left in cGEOp::Pass1");
   if (Right == 0) Die("Internal Error: NULL Right in cGEOp::Pass1");

   ((cAbsTree *) Left)->Parent = this;
   ((cAbsTree *) Left)->Pass1();

   ((cAbsTree *) Right)->Parent = this;
   ((cAbsTree *) Right)->Pass1();
}


void cLEOp::Pass1()
{
   if (!PassOK) return;                 // Pass aborted

   IsLHS = 0;

   if (Left == 0) Die("Internal Error: NULL Left in cLEOp::Pass1");
   if (Right == 0) Die("Internal Error: NULL Right in cLEOp::Pass1");

   ((cAbsTree *) Left)->Parent = this;
   ((cAbsTree *) Left)->Pass1();

   ((cAbsTree *) Right)->Parent = this;
   ((cAbsTree *) Right)->Pass1();
}


void cLTOp::Pass1()
{
   if (!PassOK) return;                 // Pass aborted

   IsLHS = 0;

   if (Left == 0) Die("Internal Error: NULL Left in cLTOp::Pass1");
   if (Right == 0) Die("Internal Error: NULL Right in cLTOp::Pass1");

   ((cAbsTree *) Left)->Parent = this;
   ((cAbsTree *) Left)->Pass1();

   ((cAbsTree *) Right)->Parent = this;
   ((cAbsTree *) Right)->Pass1();
}


void cGTOp::Pass1()
{
   if (!PassOK) return;                 // Pass aborted

   IsLHS = 0;

   if (Left == 0) Die("Internal Error: NULL Left in cGTOp::Pass1");
   if (Right == 0) Die("Internal Error: NULL Right in cGTOp::Pass1");

   ((cAbsTree *) Left)->Parent = this;
   ((cAbsTree *) Left)->Pass1();

   ((cAbsTree *) Right)->Parent = this;
   ((cAbsTree *) Right)->Pass1();
}


void cMinusOp::Pass1()
{
   if (!PassOK) return;                 // Pass aborted

   IsLHS = 0;

   if (Left == 0) Die("Internal Error: NULL Left in cMinusOp::Pass1");
   if (Right == 0) Die("Internal Error: NULL Right in cMinusOp::Pass1");

   ((cAbsTree *) Left)->Parent = this;
   ((cAbsTree *) Left)->Pass1();

   ((cAbsTree *) Right)->Parent = this;
   ((cAbsTree *) Right)->Pass1();
}


void cPlusOp::Pass1()
{
   if (!PassOK) return;                 // Pass aborted

   IsLHS = 0;

   if (Left == 0) Die("Internal Error: NULL Left in cPlusOp::Pass1");
   if (Right == 0) Die("Internal Error: NULL Right in cPlusOp::Pass1");

   ((cAbsTree *) Left)->Parent = this;
   ((cAbsTree *) Left)->Pass1();

   ((cAbsTree *) Right)->Parent = this;
   ((cAbsTree *) Right)->Pass1();
}


void cModOp::Pass1()
{
   if (!PassOK) return;                 // Pass aborted

   IsLHS = 0;

   if (Left == 0) Die("Internal Error: NULL Left in cModOp::Pass1");
   if (Right == 0) Die("Internal Error: NULL Right in cModOp::Pass1");

   ((cAbsTree *) Left)->Parent = this;
   ((cAbsTree *) Left)->Pass1();

   ((cAbsTree *) Right)->Parent = this;
   ((cAbsTree *) Right)->Pass1();
}


void cDivOp::Pass1()
{
   if (!PassOK) return;                 // Pass aborted

   IsLHS = 0;

   if (Left == 0) Die("Internal Error: NULL Left in cDivOp::Pass1");
   if (Right == 0) Die("Internal Error: NULL Right in cDivOp::Pass1");

   ((cAbsTree *) Left)->Parent = this;
   ((cAbsTree *) Left)->Pass1();

   ((cAbsTree *) Right)->Parent = this;
   ((cAbsTree *) Right)->Pass1();
}


void cMultOp::Pass1()
{
   if (!PassOK) return;                 // Pass aborted

   IsLHS = 0;

   if (Left == 0) Die("Internal Error: NULL Left in cMultOp::Pass1");
   if (Right == 0) Die("Internal Error: NULL Right in cMultOp::Pass1");

   ((cAbsTree *) Left)->Parent = this;
   ((cAbsTree *) Left)->Pass1();

   ((cAbsTree *) Right)->Parent = this;
   ((cAbsTree *) Right)->Pass1();
}


void cSelectOp::Pass1()
{
   if (!PassOK) return;                 // Pass aborted

   if (Left == 0) Die("Internal Error: NULL Left in cSelectOp::Pass1");

   ((cAbsTree *) Left)->Parent = this;
   ((cAbsTree *) Left)->Pass1();

   IsLHS = Left->IsLHS;
}


void cArrayIndOp::Pass1()
{
   if (!PassOK) return;                 // Pass aborted

   if (Left == 0) Die("Internal Error: NULL Left in cArrayIndOp::Pass1");
   if (Right == 0) Die("Internal Error: NULL Right in cArrayIndOp::Pass1");

   ((cAbsTree *) Left)->Parent = this;
   ((cAbsTree *) Left)->Pass1();

   ((cAbsTree *) Right)->Parent = this;
   ((cAbsTree *) Right)->Pass1();

   IsLHS = Left->IsLHS;
}



void cFuncArgSpec::Pass1()
{
   if (!PassOK) return;                 // Pass aborted
}


void cFuncSig::Pass1()
{
   cObIterator i;
   cObject *p;

   if (!PassOK) return;                 // Pass aborted

   for (p = i.Init(Args); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->Pass1();
   }
}


void cArc::Pass1()
{
   cObIterator i;
   cObject *p;

   if (!PassOK) return;                 // Pass aborted

   SymbolTable = new cSymTab(this);

   for (p = i.Init(CallVarList); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->Pass1();
      ((cAbsTree *) p) ->MakeSTEntry(SymbolTable);
   }

   for (p = i.Init(NodeVarList); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->Pass1();
      ((cAbsTree *) p) ->MakeSTEntry(SymbolTable);
   }

   for (p = i.Init(PortVarList); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->Pass1();
      ((cAbsTree *) p) ->MakeSTEntry(SymbolTable);
   }

   for (p = i.Init(CallExprList); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->Pass1();
   }

   for (p = i.Init(NodeExprList); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->Pass1();
   }

   for (p = i.Init(PortExprList); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->Pass1();
   }

   if (ArcType == 1)
     ToPort = FromPort;
}


void cPartArc::Pass1()
{
}


void cMergeArc::Pass1()
{
}


void cExpandArc::Pass1()
{
}


void cContractArc::Pass1()
{
}


void cStrip_UpdateArc::Pass1()
{
}


void cAlignArc::Pass1()
{
}



void cNamedType::Pass1()
{
}


void cArrayType::Pass1()
{
}


void cStructMem::Pass1()
{
}


void cStructType::Pass1()
{
   cObIterator i;
   cObject *p;

   if (!PassOK) return;                 // Pass aborted

   for (p = i.Init(Members); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->Pass1();
   }
}


void cTypeDef::Pass1()
{
   if (!PassOK) return;                 // Pass aborted

   if (Type == 0) Die("Internal Error: NULL Type in cTypeDef::Pass1");

   ((cAbsTree *) Type)->Parent = this;
   ((cAbsTree *) Type)->Pass1();  // this is a problem
}


void cCallStmt::Pass1()
{
   cObIterator i;
   cObject *p;

   if (!PassOK) return;                 // Pass aborted

   for (p = i.Init(Args); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->Pass1();
   }
}


void cWhileStmt::Pass1()
{
   if (!PassOK) return;                 // Pass aborted

   if (Cond == 0) Die("Internal Error: NULL Cond in cWhileStmt::Pass1");
   if (Body == 0) Die("Internal Error: NULL Body in cWhileStmt::Pass1");

   ((cAbsTree *) Cond)->Parent = this;
   ((cAbsTree *) Cond)->Pass1();

   ((cAbsTree *) Body)->Parent = this;
   ((cAbsTree *) Body)->Pass1();
}


void cBlockStmt::Pass1()
{
   cObIterator i;
   cObject *p;

   if (!PassOK) return;                 // Pass aborted

   for (p = i.Init(StmtList); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->Pass1();
   }
}


void cIfStmt::Pass1()
{
   if (!PassOK) return;                 // Pass aborted

   if (Cond == 0) Die("Internal Error: NULL Cond in cIfStmt::Pass1");
   if (IfPart == 0) Die("Internal Error: NULL IfPart in cIfStmt::Pass1");

   ((cAbsTree *) Cond)->Parent = this;
   ((cAbsTree *) Cond)->Pass1();

   ((cAbsTree *) IfPart)->Parent = this;
   ((cAbsTree *) IfPart)->Pass1();

   if (ElsePart != 0) {
      ((cAbsTree *) ElsePart)->Parent = this;
      ((cAbsTree *) ElsePart)->Pass1();
   }
}


void cAssignStmt::Pass1()
{
   if (!PassOK) return;                 // Pass aborted

   if (LHS == 0) Die("Internal Error: NULL LHS in cAssignStmt::Pass1");
   if (RHS == 0) Die("Internal Error: NULL RHS in cAssignStmt::Pass1");

   ((cAbsTree *) LHS)->Parent = this;
   ((cAbsTree *) LHS)->Pass1();

   ((cAbsTree *) RHS)->Parent = this;
   ((cAbsTree *) RHS)->Pass1();
}


void cNullStmt::Pass1()
{
}


void cSizeSpec::Pass1()
{
   cObIterator i;
   cObject *p;

   if (!PassOK) return;                 // Pass aborted

   for (p = i.Init(ArrayBounds); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->Pass1();
   }

   for (p = i.Init(MemberSizes); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->Pass1();
   }
}


void cMemSize::Pass1()
{
   if (!PassOK) return;

   if (Sizes == 0) Die("Internal Error: NULL Sizes in cMemSize::Pass1");

   Sizes->Parent = this;
   Sizes->Pass1();
}


void cVarDecl::Pass1()
{
   if (!PassOK) return;                 // Pass aborted

   if (Sizes != 0) {
      Sizes->Parent = this;
      Sizes->Pass1();
   }
}


void cNSRel::Pass1()
{
   cObIterator i;
   cObject *p;

   SymbolTable = new cSymTab(this);
   AddGraphAndNode(SymbolTable);

   if (!PassOK) return;                 // Pass aborted

   if (InitComp != 0) {
      ((cAbsTree *) InitComp)->Parent = this;
      ((cAbsTree *) InitComp)->Pass1();
   }

   for (p = i.Init(FuncSigs); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->MakeSTEntry(SymbolTable);
      ((cAbsTree *) p)->Pass1();
   }

   for (p = i.Init(SharedVars); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->MakeSTEntry(SymbolTable);
      {  
         // Peter Newton made me do this ; its his fault
         // this is way Peter chose to differentiate Variable symbol table entries
         // between SharedVars and LocalVars
         cSEVariable *SEVariable = (cSEVariable *) SymbolTable->Get(((cVarDecl *)p)->VarName);
         SEVariable->Shared = 1;
      } 
      ((cAbsTree *) p)->Pass1();
   }

   for (p = i.Init(LocalVars); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->MakeSTEntry(SymbolTable);
      ((cAbsTree *) p)->Pass1();
   }
}


void cReplSpec::Pass1()
{
   if (!PassOK) return;                 // Pass aborted

   if (Bound == 0) Die("Internal Error: NULL Bound in cReplSpec::Pass1");

   ((cAbsTree *) Bound)->Parent = this;
   ((cAbsTree *) Bound)->Pass1();
}


void cGuard::Pass1()
{
   cObIterator i;
   cObject *p;

   if (!PassOK) return;                 // Pass aborted

   if (Cond == 0) Die("Internal Error: NULL Cond in cGuard::Pass1");

   if (!Repls.Empty()) SymbolTable = new cSymTab(this);

   Cond->Parent = this;
   Cond->Pass1();

   if (ReplCond != 0) {
      ReplCond->Parent = this;
      ReplCond->Pass1();
   }

   for (p = i.Init(Repls); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->MakeSTEntry(SymbolTable);
      ((cAbsTree *) p)->Pass1();
   }
}


void cArcInput::Pass1()
{
   cObIterator i;
   cObject *p;

   if (!PassOK) return;                 // Pass aborted

   if (PortExpr == 0) Die("Internal Error: NULL PortExpr in cArcInput::Pass1");
   if (VarExpr == 0) Die("Internal Error: NULL VarExpr in cArcInput::Pass1");

   if (!Repls.Empty()) SymbolTable = new cSymTab(this);

   PortExpr->Parent = this;
   PortExpr->Pass1();

   VarExpr->Parent = this;
   VarExpr->Pass1();

   if (ReplCond != 0) {
      ReplCond->Parent = this;
      ReplCond->Pass1();
   }

   for (p = i.Init(Repls); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->MakeSTEntry(SymbolTable);
      ((cAbsTree *) p)->Pass1();
   }
}


void cBinding::Pass1()
{
   cObIterator i;
   cObject *p;

   if (!PassOK) return;                 // Pass aborted

   if (Bind == 0) Die("Internal Error: NULL Bind in cBinding::Pass1");

   if (!Repls.Empty()) SymbolTable = new cSymTab(this);

   Bind->Parent = this;
   Bind->Pass1();

   if (ReplCond != 0) {
      ((cAbsTree *) ReplCond)->Parent = this;
      ((cAbsTree *) ReplCond)->Pass1();
   }

   for (p = i.Init(Repls); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->MakeSTEntry(SymbolTable);
      ((cAbsTree *) p)->Pass1();
   }
}


void cArcOutput::Pass1()
{
   cObIterator i;
   cObject *p;

   if (!PassOK) return;                 // Pass aborted

   if (PortExpr == 0) Die("Internal Error:  Null PortExpr in ArcOutput::Pass1");
   if (ValueExpr == 0) Die("Internal Error:  Null ValueExpr in ArcOutput::Pass1");

   if (!Repls.Empty()) SymbolTable = new cSymTab(this);

   PortExpr->Parent = this;
   PortExpr->Pass1();

   ValueExpr->Parent = this;
   ValueExpr->Pass1();

   if (ReplCond != 0) {
      ReplCond->Parent = this;
      ReplCond->Pass1();
   }

   for (p = i.Init(Repls); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->MakeSTEntry(SymbolTable);
      ((cAbsTree *) p)->Pass1();
   }
}


void cRule::Pass1()
{
   cObIterator i;
   cObject *p;

   if (!PassOK) return;                 // Pass aborted

   if (!Repls.Empty()) SymbolTable = new cSymTab(this);

   for (p = i.Init(Guards); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->Pass1();
   }

   for (p = i.Init(Binds); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->Pass1();
   }

   if (ReplCond != 0) {
      ReplCond->Parent = this;
      ReplCond->Pass1();
   }

   for (p = i.Init(Repls); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->MakeSTEntry(SymbolTable);
      ((cAbsTree *) p)->Pass1();
   }
}


void cPortSpec::Pass1()
{
   if (!PassOK) return;                 // Pass aborted
}


void cNSPortSpec::Pass1()
{
   if (!PassOK) return;                 // Pass aborted
}


void cUC::Pass1()
{
   cObIterator i;
   cObject *p;

   SymbolTable = new cSymTab(this);
   AddGraphAndNode(SymbolTable);

   if (!PassOK) return;                 // Pass aborted

   if (InitComp != 0) {
      ((cAbsTree *) InitComp)->Parent = this;
      ((cAbsTree *) InitComp)->Pass1();
   }

   if (Comp != 0) {
      ((cAbsTree *) Comp)->Parent = this;
      ((cAbsTree *) Comp)->Pass1();
   }

   for (p = i.Init(FuncSigs); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->MakeSTEntry(SymbolTable);
      ((cAbsTree *) p)->Pass1();
   }

   for (p = i.Init(InputPorts); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cPortSpec *) p)->IsInputPort = 1;
      ((cAbsTree *) p)->MakeSTEntry(SymbolTable);
      ((cAbsTree *) p)->Pass1();
   }

   for (p = i.Init(OutputPorts); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cPortSpec *) p)->IsInputPort = 0;
      ((cAbsTree *) p)->MakeSTEntry(SymbolTable);
      ((cAbsTree *) p)->Pass1();
   }

   for (p = i.Init(NSPorts); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->MakeSTEntry(SymbolTable);
      ((cAbsTree *) p)->Pass1();
   }

   for (p = i.Init(LocalVars); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->MakeSTEntry(SymbolTable);
      ((cAbsTree *) p)->Pass1();
   }

   for (p = i.Init(InRules); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->Pass1();
   }

   for (p = i.Init(OutRules); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->Pass1();
   }
}


void cIntNode::Pass1()
{
}


void cCrepNode::Pass1()
{
}


void cCallNode::Pass1()
{
}


void cGraph::Pass1()
{
   cObIterator i;
   cObject *p;

   SymbolTable = new cSymTab(this);

   if (!PassOK) return;                 // Pass aborted

   for (p = i.Init(Types); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->MakeSTEntry(SymbolTable);
      ((cAbsTree *) p)->Pass1();
   }

   for (p = i.Init(FuncSigs); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->MakeSTEntry(SymbolTable);
      ((cAbsTree *) p)->Pass1();
   }

   for (p = i.Init(IntNodes); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->MakeSTEntry(SymbolTable);
      ((cAbsTree *) p)->Pass1();
   }

   for (p = i.Init(CrepNodes); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->MakeSTEntry(SymbolTable);
      ((cAbsTree *) p)->Pass1();
   }

   for (p = i.Init(UCNodes); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->Pass1();
   }

   for (p = i.Init(CallNodes); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->Pass1();
   }

   for (p = i.Init(NSRelNodes); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->Pass1();
   }

   for (p = i.Init(Arcs); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->Pass1();
   }
}


void AddGloballyPredefinedSymbols(cSymTab * SymbolTable)
{
   cSETypeName *PredefinedTypeEntry;
   cSEVariable *PredefinedVarEntry;
   cSEFuncName *PredefinedFuncEntry;

   PredefinedTypeEntry = new cSETypeName;
   PredefinedTypeEntry->Type = new cIntSType;
   PredefinedTypeEntry->Type->TypeName = "int";
   if (!SymbolTable->Insert("int", PredefinedTypeEntry)) 
      Die("int already declared!\n");

   PredefinedVarEntry = new cSEVariable;
   PredefinedVarEntry->Type = PredefinedTypeEntry->Type;
   if (!SymbolTable->Insert("TRUE", PredefinedVarEntry)) 
      Die("identifier TRUE already declared!\n");

   PredefinedVarEntry = new cSEVariable;
   PredefinedVarEntry->Type = PredefinedTypeEntry->Type;
   if (!SymbolTable->Insert("FALSE", PredefinedVarEntry)) 
      Die("identifier FALSE already declared!\n");

   PredefinedTypeEntry = new cSETypeName;
   PredefinedTypeEntry->Type = new cRealSType;
   PredefinedTypeEntry->Type->TypeName = "real";
   if (!SymbolTable->Insert("real", PredefinedTypeEntry)) 
      Die("real already declared!\n");

   PredefinedTypeEntry = new cSETypeName;
   PredefinedTypeEntry->Type = new cCharSType;
   PredefinedTypeEntry->Type->TypeName = "char";
   if (!SymbolTable->Insert("char", PredefinedTypeEntry)) 
      Die("char already declared!\n");

   PredefinedFuncEntry = new cSEFuncName;
   PredefinedFuncEntry->IsPolyMorphic = 1;
   PredefinedFuncEntry->DontCheckArgs = 0;
   PredefinedFuncEntry->ReturnType = new cIntSType;
   if (!SymbolTable->Insert("size", PredefinedFuncEntry))
      Die("predefined function size already declared!\n");

   PredefinedFuncEntry = new cSEFuncName;
   PredefinedFuncEntry->IsPolyMorphic = 1;
   PredefinedFuncEntry->DontCheckArgs = 0;
   PredefinedFuncEntry->ReturnType = 0; // filled in during type propagation
   if (!SymbolTable->Insert("copy", PredefinedFuncEntry))
      Die("predefined function copy already declared!\n");

   PredefinedFuncEntry = new cSEFuncName;
   PredefinedFuncEntry->IsPolyMorphic = 1;
   PredefinedFuncEntry->DontCheckArgs = 0;
   PredefinedFuncEntry->ReturnType = 0; 
   if (!SymbolTable->Insert("free", PredefinedFuncEntry))
      Die("predefined function free already declared!\n");

}

void cProgram::Pass1()
{
   cObIterator i;
   cObject *p;

   PassOK = 1;   // OK at start
   SymbolTable = new cSymTab(this);

   if (setjmp(PassEnv)) {
      PassOK = 0;
      return;
   }

   // Add built-in types to global symbol table
   AddGloballyPredefinedSymbols(SymbolTable);
   
   for (p = i.Init(Types); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->MakeSTEntry(SymbolTable);
      ((cAbsTree *) p)->Pass1();
   }

   for (p = i.Init(FuncSigs); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->MakeSTEntry(SymbolTable);
      ((cAbsTree *) p)->Pass1();
   }

   for (p = i.Init(Graphs); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->Parent = this;
      ((cAbsTree *) p)->MakeSTEntry(SymbolTable);
      ((cAbsTree *) p)->Pass1();
   }
}

