#include <config.h>
// pass3 performs the following tasks

// inter-graph semantic errors

#include <setjmp.h>
#include <stream.h>
#include <ctype.h>
#include <misc/general.h>
#include <exmodel/abstree.h>
#include <exmodel/exmodel.h>
#include <symtab/symtab.h>
#include <lib/UidTable.h>
#include <lib/MsgUI.h>
#include <lib/Syntax.h>
#include "pass.h"

void
TrackDownNSRelNode(cArc *Arc, cUC *RefUC, cNSPortSpec *RefNSPortSpec) 
{
   cObIterator i, j, k;
   cObject *p, *q, *r;

   cAbsTree *FromNode = FindUidTable(Arc->FromUID);
   ClassId FromClassId = FromNode->IsA();
   cAbsTree *ToNode = FindUidTable(Arc->ToUID);
   ClassId ToClassId = ToNode->IsA();

   Arc->ConnectsNSRel = 1;

   switch (ToClassId) {
   case ::NSRel:
      return;
   case ::CallNode:
   { 
      cSymTabEntry *SymTabEntry; 
      cCallNode *ToCallNode = (cCallNode *)ToNode;
      cSEGraph *SEGraph = (cSEGraph *) GetSymbol(ToCallNode->CalledGraph, Arc, ::SEGraph, 0);

      if (FromClassId == IntNode) SymTabEntry = SEGraph->Graph->SymbolTable->Get(Arc->FromPort);
      else                        SymTabEntry = SEGraph->Graph->SymbolTable->Get(Arc->ToPort);

      if (SymTabEntry->IsA() == ::SEIntNode) { // could have been a Creation Parameter
         for (p = i.Init(SEGraph->Graph->Arcs); i.MoreLeft(); p = i.Next()) {
            cArc *NextArc = (cArc *)p;
            if ((char *) NextArc->FromPort == Arc->ToPort) {
               TrackDownNSRelNode(NextArc, RefUC, RefNSPortSpec);
            }
         }
         return;
      } else {
         YYUIMessage(RefUC->UID, ErrorLevel, "Shared variable \"%s\" in UC \"%s\" was bound to be "
            "a creation parameter and not a name sharing relation node.\n",
            (char *)RefNSPortSpec->PortName, (char *)RefUC->Name);
         longjmp(PassEnv, 1);
      }
   }
   case ::IntNode: 
   {  //has to be output interface node
      cIntNode *ToIntNode = (cIntNode *)ToNode;
      cGraph *CalledGraph = (cGraph *)ToNode->Parent;

      for (p = i.Init(ProgramRoot->Graphs); i.MoreLeft(); p = i.Next()) {
         cGraph *CallingGraph = (cGraph *)p;

         for (q = j.Init(CallingGraph->CallNodes); j.MoreLeft(); q = j.Next()) {
            cCallNode *CallNode = (cCallNode *)q;

            if ((char *) CallNode->CalledGraph == CalledGraph->Name) {

               for (r = k.Init(CallingGraph->Arcs); k.MoreLeft(); r = k.Next()) {
                  cArc *NextArc = (cArc *)r;

                  if (NextArc->FromUID == CallNode->UID) {
                     if ((char *) NextArc->FromPort == ToIntNode->Name) {
                        TrackDownNSRelNode(NextArc, RefUC, RefNSPortSpec);
                     }
                  }
               }
            }
         }
      }
      return;
   }
   case ::UC:
      YYUIMessage(RefUC->UID, ErrorLevel, "Shared variable \"%s\" in UC \"%s\" was bound to be "
         "another UC and not a name sharing relation node.\n",
         (char *)RefNSPortSpec->PortName, (char *)RefUC->Name);
      longjmp(PassEnv, 1);
   default:
      Die("That which can not happen has in TrackDownNSRelNode (Pass3.)");
   }
   Die("That which can not happen has in TrackDownNSRelNode (Pass3.)");
}

void
cUC::Pass3() 
{
   cObIterator i, j;
   cObject *p, *q;

   // make sure all UC node with shared variables connect to NSRel nodes
   for (p = i.Init(NSPorts); i.MoreLeft(); p = i.Next()) {
      cNSPortSpec *NSPortSpec = (cNSPortSpec *)p;

      cGraph *Graph = (cGraph *)Parent;
      for (q = j.Init(Graph->Arcs); j.MoreLeft(); q = j.Next()) {
         cArc *Arc = (cArc *)q;
         if (Arc->FromUID == UID && (char *) Arc->FromPort == NSPortSpec->PortName) {
            TrackDownNSRelNode(Arc, this, NSPortSpec);
         }
      }
   }
}


void
cGraph::Pass3()
{
   cObIterator i;
   cObject *p;

   for (p = i.Init(UCNodes); i.MoreLeft(); p = i.Next()) {
      cUC *ThisUC = (cUC *)p;
      ThisUC->Pass3();
   }
}


void
cProgram::Pass3()
{
   cObIterator i;
   cObject *p;

   for (p = i.Init(Graphs); i.MoreLeft(); p = i.Next()) {
      cGraph *ThisGraph = (cGraph *)p;
      ThisGraph->Pass3();
   }
}
