#include <config.h>
// TreeWalk

//   TreeWalk is never really called.  This file is used as a template
//   for creating new passes.  It is compiled to force us to keep it
//   roughly up to date.

#include <stream.h>
#include "../misc/general.h"
#include "../exmodel/abstree.h"
#include "../exmodel/exmodel.h"
#include "pass.h"

void cIdent::TreeWalk()
{
}


void cIntConst::TreeWalk()
{
}


void cRealConst::TreeWalk()
{
}


void cNewExpr::TreeWalk()
{
   if (Sizes != 0) Sizes->TreeWalk();
}


void cFuncCallOp::TreeWalk()
{
   cObIterator i;
   cObject *p;


   for (p = i.Init(Args); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->TreeWalk();
   }
}


void cNotOp::TreeWalk()
{
   Left->TreeWalk();
}


void cUnaryMinusOp::TreeWalk()
{
   Left->TreeWalk();
}


void cOrOp::TreeWalk()
{

   Left->TreeWalk();
   Right->TreeWalk();
}


void cAndOp::TreeWalk()
{
   Left->TreeWalk();
   Right->TreeWalk();
}


void cNEOp::TreeWalk()
{


   Left->TreeWalk();
   Right->TreeWalk();
}


void cEqOp::TreeWalk()
{


   Left->TreeWalk();
   Right->TreeWalk();
}


void cGEOp::TreeWalk()
{


   Left->TreeWalk();
   Right->TreeWalk();
}


void cLEOp::TreeWalk()
{


   Left->TreeWalk();
   Right->TreeWalk();
}


void cLTOp::TreeWalk()
{


   Left->TreeWalk();
   Right->TreeWalk();
}


void cGTOp::TreeWalk()
{


   Left->TreeWalk();
   Right->TreeWalk();
}


void cMinusOp::TreeWalk()
{


   Left->TreeWalk();
   Right->TreeWalk();
}


void cPlusOp::TreeWalk()
{


   Left->TreeWalk();
   Right->TreeWalk();
}


void cModOp::TreeWalk()
{


   Left->TreeWalk();
   Right->TreeWalk();
}


void cDivOp::TreeWalk()
{


   Left->TreeWalk();
   Right->TreeWalk();
}


void cMultOp::TreeWalk()
{


   Left->TreeWalk();
   Right->TreeWalk();
}


void cSelectOp::TreeWalk()
{


   Left->TreeWalk();
}


void cArrayIndOp::TreeWalk()
{
   Left->TreeWalk();
   Right->TreeWalk();
}


void cFuncArgSpec::TreeWalk()
{
}


void cFuncSig::TreeWalk()
{
   cObIterator i;
   cObject *p;

   for (p = i.Init(Args); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->TreeWalk();
   }
}


void cArc::TreeWalk()
{
   cObIterator i;
   cObject *p;

   for (p = i.Init(CallVarList); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->TreeWalk();
   }

   for (p = i.Init(NodeVarList); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->TreeWalk();
   }

   for (p = i.Init(PortVarList); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->TreeWalk();
   }

   for (p = i.Init(CallExprList); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->TreeWalk();
   }

   for (p = i.Init(NodeExprList); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->TreeWalk();
   }

   for (p = i.Init(PortExprList); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->TreeWalk();
   }
}


void cPartArc::TreeWalk()
{
}


void cMergeArc::TreeWalk()
{
}

 
void cExpandArc::TreeWalk()
{
}


void cContractArc::TreeWalk()
{
}


void cStrip_UpdateArc::TreeWalk()
{
}


void cAlignArc::TreeWalk()
{
}


void cNamedType::TreeWalk()
{
}


void cArrayType::TreeWalk()
{
}


void cStructMem::TreeWalk()
{
}


void cStructType::TreeWalk()
{
   cObIterator i;
   cObject *p;


   for (p = i.Init(Members); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->TreeWalk();
   }
}


void cTypeDef::TreeWalk()
{
   Type->TreeWalk();
}


void cCallStmt::TreeWalk()
{
   cObIterator i;
   cObject *p;

   for (p = i.Init(Args); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->TreeWalk();
   }
}


void cWhileStmt::TreeWalk()
{

   Cond->TreeWalk();
   Body->TreeWalk();
}


void cBlockStmt::TreeWalk()
{
   cObIterator i;
   cObject *p;

   for (p = i.Init(StmtList); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->TreeWalk();
   }
}


void cIfStmt::TreeWalk()
{

   Cond->TreeWalk();
   IfPart->TreeWalk();

   if (ElsePart != 0) {
      ElsePart->TreeWalk();
   }
}


void cAssignStmt::TreeWalk()
{


   LHS->TreeWalk();
   RHS->TreeWalk();
}


void cNullStmt::TreeWalk()
{
}


void cSizeSpec::TreeWalk()
{
   cObIterator i;
   cObject *p;

   for (p = i.Init(ArrayBounds); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->TreeWalk();
   }

   for (p = i.Init(MemberSizes); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->TreeWalk();
   }
}


void cMemSize::TreeWalk()
{

   Sizes->TreeWalk();
}


void cVarDecl::TreeWalk()
{

   if (Sizes != 0) Sizes->TreeWalk();
}


void cNSRel::TreeWalk()
{
   cObIterator i;
   cObject *p;

   if (InitComp != 0) {
      InitComp->TreeWalk();
   }

   for (p = i.Init(FuncSigs); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->TreeWalk();
   }

   for (p = i.Init(SharedVars); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->TreeWalk();
   }

   for (p = i.Init(LocalVars); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->TreeWalk();
   }
}


void cReplSpec::TreeWalk()
{
   Bound->TreeWalk();
}


void cGuard::TreeWalk()
{
   cObIterator i;
   cObject *p;


   Cond->TreeWalk();

   if (ReplCond != 0) {
      ReplCond->TreeWalk();
   }

   for (p = i.Init(Repls); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->TreeWalk();
   }
}


void cArcInput::TreeWalk()
{
   cObIterator i;
   cObject *p;

   PortExpr->TreeWalk();
   VarExpr->TreeWalk();

   if (ReplCond != 0) {
      ReplCond->TreeWalk();
   }

   for (p = i.Init(Repls); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->TreeWalk();
   }
}


void cBinding::TreeWalk()
{
   cObIterator i;
   cObject *p;

   Bind->TreeWalk();

   if (ReplCond != 0) {
      ReplCond->TreeWalk();
   }

   for (p = i.Init(Repls); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->TreeWalk();
   }
}


void cArcOutput::TreeWalk()
{
   cObIterator i;
   cObject *p;

   PortExpr->TreeWalk();
   ValueExpr->TreeWalk();

   if (ReplCond != 0) {
      ReplCond->TreeWalk();
   }

   for (p = i.Init(Repls); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->TreeWalk();
   }
}


void cRule::TreeWalk()
{
   cObIterator i;
   cObject *p;


   for (p = i.Init(Guards); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->TreeWalk();
   }

   for (p = i.Init(Binds); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->TreeWalk();
   }

   if (ReplCond != 0) {
      ReplCond->TreeWalk();
   }

   for (p = i.Init(Repls); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->TreeWalk();
   }
}


void cPortSpec::TreeWalk()
{
}


void cNSPortSpec::TreeWalk()
{
}


void cUC::TreeWalk()
{
   cObIterator i;
   cObject *p;


   if (InitComp != 0) {
      InitComp->TreeWalk();
   }

   if (Comp != 0) {
      Comp->TreeWalk();
   }

   for (p = i.Init(FuncSigs); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->TreeWalk();
   }

   for (p = i.Init(InputPorts); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->TreeWalk();
   }

   for (p = i.Init(OutputPorts); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->TreeWalk();
   }

   for (p = i.Init(NSPorts); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->TreeWalk();
   }

   for (p = i.Init(LocalVars); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->TreeWalk();
   }

   for (p = i.Init(InRules); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->TreeWalk();
   }

   for (p = i.Init(OutRules); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->TreeWalk();
   }
}


void cIntNode::TreeWalk()
{
}


void cCrepNode::TreeWalk()
{
}


void cCallNode::TreeWalk()
{
}


void cGraph::TreeWalk()
{
   cObIterator i;
   cObject *p;


   for (p = i.Init(FuncSigs); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->TreeWalk();
   }

   for (p = i.Init(Types); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->TreeWalk();
   }

   for (p = i.Init(IntNodes); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->TreeWalk();
   }

   for (p = i.Init(CrepNodes); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->TreeWalk();
   }

   for (p = i.Init(UCNodes); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->TreeWalk();
   }

   for (p = i.Init(CallNodes); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->TreeWalk();
   }

   for (p = i.Init(NSRelNodes); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->TreeWalk();
   }

   for (p = i.Init(Arcs); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->TreeWalk();
   }
}


void cProgram::TreeWalk()
{
   cObIterator i;
   cObject *p;

   PassOK = 1;   // OK at start

   if (setjmp(PassEnv)) {
      PassOK = 0;
      return;
   }

   for (p = i.Init(FuncSigs); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->TreeWalk();
   }

   for (p = i.Init(Types); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->TreeWalk();
   }

   for (p = i.Init(Graphs); i.MoreLeft(); p = i.Next()) {
      ((cAbsTree *) p)->TreeWalk();
   }
}

