/*

thread.C

This set of routines is designed to emulate the FastThreads package
(used in the Sequent Symmetry implementation) on a Cray platform with
POSIX threads (in UNICOS 9.0).

By providing this emulation, we will be able to use the sequent backend
almost as-is, as we will be "plugging-in" the only architecture dependent
bit (the Cray is also a shared-memory architecture).

Although the FastThreads package provides barriers, conditions, etc.,
CODE only uses locks and threads, so those are the only ones implemented
here.


===
Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
Systems Analyst                 @          <mailto: emery@cs.utexas.edu>
Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
Department of Computer Sciences |             <http://www.cs.utexas.edu>
University of Texas at Austin   |                <http://www.utexas.edu>

*/


#include "crayFastThreads.h"
#include "c2_misc.h"           /* for _c2_shmalloc() */


/*
   NOTE: due to shortcomings in UNICOS, it is not possible to completely
         emulate FastThreads (which allows multiple arguments).
	 However, since CODE (conveniently) only uses one-argument
	 procedure arguments in ThreadStart calls, this is not
	 a problem.
*/

inline Thread *ThreadStart (void (*procedureToRun)(),
			    int willJoin, 
			    char *name,
			    int numberOfArguments,
			    void *arg1)
{
  Thread *thread;
  int result;

  thread = (Thread *) _c2_shmalloc(sizeof(Thread));

  result = pthread_create (thread, NULL, procedureToRun, 1, arg1);

  return thread;
}


inline void ThreadJoin (Thread *thread) {
  int result;
  
  result = pthread_join (*thread, NULL);
}



inline void LockInit (Lock *lock, char *name) {
  pthread_mutex_attr_init (lock, MUTEX_FAST_NP);
}

inline void LockAcquire (Lock *lock) {
  pthread_mutex_attr_lock (lock);
}

inline void LockRelease (Lock *lock) {
  pthread_mutex_attr_unlock (lock);
}

inline void LockDispose (Lock *lock) {
  pthread_mutex_attr_destroy (lock);
}

inline void ProgramDone () {}
