/*

thread.h

This set of routines is designed to emulate the FastThreads package
(used in the Sequent Symmetry implementation) on a Cray platform with
POSIX threads (in UNICOS 9.0).

By providing this emulation, we will be able to use the sequent backend
almost as-is, as we will be "plugging-in" the only architecture dependent
bit (the Cray is also a shared-memory architecture).

Although the FastThreads package provides barriers, conditions, etc.,
CODE only uses locks and threads, so those are the only ones implemented
here.


===
Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
Systems Analyst                 @          <mailto: emery@cs.utexas.edu>
Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
Department of Computer Sciences |             <http://www.cs.utexas.edu>
University of Texas at Austin   |                <http://www.utexas.edu>

*/


#ifndef _craythreads_x
#define _craythreads_x

#include <pthread.h>


/* define thread routines */

typedef pthread_t Thread;

Thread *ThreadStart (void (*procedureToRun)(),
		     int willJoin, 
		     char *name,
		     int numberOfArguments,
		     void *arg1);

void ThreadJoin (Thread *thread);


/* define lock routines */

typedef pthread_mutex_t Lock;

void LockInit (Lock *lock,
	       char *name);

void LockAcquire (Lock *lock);

void LockRelease (Lock *lock);

void LockDispose (Lock *lock);


void ProgramDone ();

#endif
