'\"
'\" Copyright (c) 1995 DSC Technologies Corporation
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" @(#) promptdialog.n 1.21 94/12/17 16:04:44
'/" 
.so man.macros
.HS promptdialog iwid
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
promptdialog \- Create and manipulate a prompt dialog widget
.SH SYNOPSIS
\fBpromptdialog\fI \fIpathName \fR?\fIoptions\fR?
.SH "INHERITANCE"
itk::Toplevel <- dialogshell <- dialog <- promptdialog
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBbackground\fR	\fBborderWidth\fR	\fBcursor\fR	\fBexportSelection\fR
\fBforeground\fR	\fBhighlightColor\fR	\fBhighlightThickness\fR	\fBinsertBackground\fR
\fBinsertBorderWidth\fR	\fBinsertOffTime\fR	\fBinsertOnTime\fR	\fBinsertWidth\fR
\fBjustify\fR	\fBrelief\fR	\fBselectBackground\fR	\fBselectBorderWidth\fR
\fBselectForeground\fR \fBtextVariable\fR
.fi
.LP
See the "options" manual entry for details on the standard options.
.SH "ASSOCIATED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBshow\fR	\fBstate\fR	\fBwidth\fR
.fi
.LP
See the "entry" widget manual entry for details on the above 
associated options.
.LP
.nf
.ta 4c 8c 12c
\fBchildSitePos\fR	\fBfixed\fR	\fBinvalid\fR	\fBtextBackground\fR
\fBtextFont\fR	\fBvalidate\fR
.fi
.LP
See the "entryfield" widget manual entry for details on the above
associated options.
.LP
.nf
.ta 4c 8c 12c
\fBlabelBitmap\fR	\fBlabelFont\fR	\fBlabelImage\fR	\fBlabelMargin\fR
o\fBlabelPos\fR	\fBlabelText\fR	
.fi
.LP
See the "labeledwidget" widget manual entry for details on the above
associated options.
.SH "INHERITED OPTIONS"
..LP
.nf
.ta 4c 8c 12c
\fBbuttonBoxPadX\fR	\fBbuttonBoxPadY\fR	\fBbuttonBoxPos\fR	\fBmodality\fR
\fBpadX\fR	\fBpadY\fR	\fBseparator\fR	\fBthickness\fR
\fBtitle\fR
.fi
.LP
See the "dialogshell" widget manual entry for details on the above
inherited options.
.LP
.BE

.SH DESCRIPTION
.PP
The \fBpromptdialog\fR command creates a prompt dialog similar to the 
OSF/Motif standard prompt dialog composite widget.  The promptdialog 
is derived from the dialog class and is composed of a EntryField 
with commands to manipulate the dialog buttons.

.SH "METHODS"
.PP
The \fBpromptdialog\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for promptdialog widgets:
.SH "ASSOCIATED METHODS"
.LP
.nf
.ta 4c 8c 12c
\fBdelete\fR	\fBget\fR	\fBicursor\fR	\fBindex\fR
\fBinsert\fR	\fBscan\fR	\fBselection\fR	\fBxview\fR
.fi
.LP
See the "entry" widget manual entry for details on the above
associated methods.
.LP
.nf
.ta 4c 8c 12c
\fBclear\fR
.fi
.LP
See the "entryfield" widget manual entry for details on the above
associated methods.
.SH "INHERITED METHODS"
.LP
.nf
.ta 4c 8c 12c
\fBadd\fR	\fBbuttonconfigure\fR	\fBdefault\fR	\fBhide\fR
\fBinvoke\fR	\fBshow\fR	
.fi
.LP
See the "buttonbox" widget manual entry for details on the above
inherited methods.
.LP
.nf
.ta 4c 8c 12c
\fBactivate\fR	\fBcenter\fR	\fBchildsite\fR	\fBdeactivate\fR
.fi
.LP
See the "dialogshell" widget manual entry for details on the above
inherited methods.

.SH "WIDGET-SPECIFIC METHODS"
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBpromptdialog\fR
command.
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBpromptdialog\fR
command.

.SH "COMPONENTS"
.LP
.nf
Name:	\fBef\fR
Class:	\fBEntryfield\fR
.fi
.IP
The ef component is the entry field for user input in the prompt dialog.  See 
the "entryfield" widget manual entry for details on the ef component item.
.fi

.SH EXAMPLE
.DS
 option add *textBackground white

 promptdialog .pd -modality global -title Password -labeltext Password: -show *
 .pd buttonconfigure OK -command {.pd deactivate 1}
 .pd hide Apply
 .pd buttonconfigure Cancel -command {.pd deactivate 0}
 .pd hide Help

 if {[.pd activate]} {
     puts "Password entered: [.pd get]"
 } else {
     puts "Password prompt cancelled"
 }
.DE
.SH AUTHOR
Mark L. Ulferts
.SH KEYWORDS
promptdialog, dialog, widget
