# SListBox.tcl --
#
#	This file implements Scrolled Listbox widgets
#
# Copyright (c) 1996, Expert Interface Technologies
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#


# ToDo:
# -anchor (none)
#

tixWidgetClass tixScrolledListBox {
    -classname TixScrolledListBox
    -superclass tixScrolledWidget
    -method {
    }
    -flag {
	-anchor -browsecmd -command -state
    }
    -static {
	-anchor
    }
    -configspec {
	{-anchor anchor Anchor w}
	{-browsecmd browseCmd BrowseCmd {}}
	{-command command Command {}}
	{-state state State normal}
	{-takefocus takeFocus TakeFocus 1 tixVerifyBoolean}
    }
    -default {
	{.scrollbar			auto}
	{*borderWidth			1}
	{*listbox.highlightBackground	#d9d9d9}
	{*listbox.relief		sunken}
	{*listbox.background		#c3c3c3}
	{*listbox.takeFocus		1}
	{*Scrollbar.background		#d9d9d9}
	{*Scrollbar.troughColor		#c3c3c3}
	{*Scrollbar.takeFocus		0}
	{*Scrollbar.relief		sunken}
	{*Scrollbar.width		15}
    }
}

proc tixScrolledListBox::InitWidgetRec {w} {
    upvar #0 $w data

    tixChainMethod $w InitWidgetRec

    set data(x-first) 0
    set data(x-last)  1
    set data(y-first) 0
    set data(y-last)  1
}

proc tixScrolledListBox::ConstructWidget {w} {
    upvar #0 $w data

    tixChainMethod $w ConstructWidget

    set data(w:listbox) \
	[listbox $w.listbox]
    set data(w:hsb) \
	[scrollbar $w.hsb -orient horizontal]
    set data(w:vsb) \
	[scrollbar $w.vsb -orient vertical ]

    set data(pw:client) $data(w:listbox)
}

proc tixScrolledListBox::SetBindings {w} {
    upvar #0 $w data

    tixChainMethod $w SetBindings

    $data(w:listbox) config \
	-xscrollcommand "tixScrolledListBox::XView $w"\
	-yscrollcommand "tixScrolledListBox::YView $w"

    $data(w:hsb) config -command "$data(w:listbox) xview"
    $data(w:vsb) config -command "$data(w:listbox) yview"

    bind $w <Configure> "+tixScrolledListBox::Configure $w"
    bind $w <FocusIn> "focus $data(w:listbox)"

    bindtags $data(w:listbox) \
    "$data(w:listbox) TixListboxState Listbox TixListbox [winfo toplevel $data(w:listbox)] all"
    tixSetMegaWidget $data(w:listbox) $w
}

tixBind TixListboxState <1> {
    if {[set [tixGetMegaWidget %W](-state)] == "disabled"} {
	break
    }
}
tixBind TixListbox      <1> {
    if [tixGetBoolean -nocomplain [%W cget -takefocus]] {
	focus %W
    }
    tixScrolledListBox::Browse [tixGetMegaWidget %W] <1> %x %y %X %Y
}

tixBind TixListboxState <B1-Motion> {
    if {[set [tixGetMegaWidget %W](-state)] == "disabled"} {
	break
    }
}
tixBind TixListbox      <B1-Motion> {
    tixScrolledListBox::Browse [tixGetMegaWidget %W] <B1-Motion> %x %y %X %Y
}

tixBind TixListboxState <Up> {
    if {[set [tixGetMegaWidget %W](-state)] == "disabled"} {
	break
    }
}
tixBind TixListbox      <Up> {
    tixScrolledListBox::Browse [tixGetMegaWidget %W] <Up> {} {} {} {}
}

tixBind TixListboxState <Down> {
    if {[set [tixGetMegaWidget %W](-state)] == "disabled"} {
	break
    }
}
tixBind TixListbox      <Down> {
    tixScrolledListBox::Browse [tixGetMegaWidget %W] <Down> {} {} {} {}
}

tixBind TixListboxState <Return> {
    if {[set [tixGetMegaWidget %W](-state)] == "disabled"} {
	break
    }
}
tixBind TixListbox      <Return> {
    tixScrolledListBox::Invoke [tixGetMegaWidget %W]
}


tixBind TixListboxState <Double-1> {
    if {[set [tixGetMegaWidget %W](-state)] == "disabled"} {
	break
    }
}
tixBind TixListbox      <Double-1> {
    if {[%W cget -selectmode] == "browse"} {
	tixScrolledListBox::Invoke [tixGetMegaWidget %W]
    }
}

tixBind TixListboxState <ButtonRelease-1> {
    if {[set [tixGetMegaWidget %W](-state)] == "disabled"} {
	break
    }
}
tixBind TixListbox      <ButtonRelease-1> {
 tixScrolledListBox::Browse [tixGetMegaWidget %W] <ButtonRelease-1> %x %y %X %Y

    if {[%W cget -selectmode] != "browse"} {
	tixScrolledListBox::Invoke [tixGetMegaWidget %W]
    }
}

proc tixScrolledListBox::Browse {w event x y X Y} {
    upvar #0 $w data

    set bind(specs) {%x %y %X %Y}
    set bind(%x)    $x
    set bind(%y)    $y
    set bind(%X)    $X
    set bind(%Y)    $Y

    if {$data(-browsecmd) != {}} {
	tixEvalCmdBinding $w $data(-browsecmd) bind {}
    }
#    update idletasks
}

#----------------------------------------------------------------------
#
#		option configs
#----------------------------------------------------------------------
proc tixScrolledListBox::config-takefocus {w value} {
    upvar #0 $w data
  
    $data(w:listbox) config -takefocus $value
}	


#----------------------------------------------------------------------
#
#		Widget commands
#----------------------------------------------------------------------


#----------------------------------------------------------------------
#
#		Private Methods
#----------------------------------------------------------------------
proc tixScrolledListBox::XView {w first last} {
    upvar #0 $w data

    set data(x-first) $first
    set data(x-last) $last

    $data(w:hsb) set $first $last
    tixWidgetDoWhenIdle tixScrolledWidget::Configure $w


}

proc tixScrolledListBox::YView {w first last} {
    upvar #0 $w data

    set data(y-first) $first
    set data(y-last) $last

    $data(w:vsb) set $first $last
    tixWidgetDoWhenIdle tixScrolledWidget::Configure $w

    # Somehow an update here must be used to advoid osscilation
    #
    update idletasks
}

#
# tixScrolledListBox::Invoke --
#
#	The user has invoked the listbox by pressing either the <Returh>
# key or double-clicking. Call the user-supplied -command function.
#
# For both -browsecmd and -command, it is the responsibility of the
# user-supplied function to determine the current selection of the listbox
# 
proc tixScrolledListBox::Invoke {w} {
    upvar #0 $w data

    if {$data(-command) != ""} {
	eval $data(-command)
    }
}

#----------------------------------------------------------------------
# virtual functions to query the client window's scroll requirement
#----------------------------------------------------------------------
proc tixScrolledListBox::GeometryInfo {w mW mH} {
    upvar #0 $w data

    return [list \
	[list $data(x-first) $data(x-last)]\
	[list $data(y-first) $data(y-last)]]
}

proc tixScrolledListBox::Configure {w} {
    upvar #0 $w data

    tixWidgetDoWhenIdle tixScrolledListBox::TrickScrollbar $w

    if {$data(-anchor) == "e"} {
	$data(w:listbox) xview 100000
    }
}

# This procedure is necessary because listbox does not call x,y scroll command
# when its size is changed
#
proc tixScrolledListBox::TrickScrollbar {w} {
    upvar #0 $w data

    if [$data(w:listbox) select include 0] {
	set inc 1
    } else {
	set inc 0
    }

    $data(w:listbox) select set 0
    if {!$inc} {
	$data(w:listbox) select clear 0
    }
}
