/* c2_workers.h */

#ifndef _C2_WORKERS_
#define _C2_WORKERS_

extern shared int _c2_Terminated;  /* 1 iff term node has fired */

  /* Initial worker manager-- call this first with address of start node */
void _c2_RunWorkers( /* _c2_NodeBase *InitNode */ );

  /* Add a NodeTask to the list to be run */
void _c2_EnQueue( /* _c2_NodeBase *Node */ );

  /* Signal end to computation */
void _c2_StopAll();

  /* Stop computation after error */
void _c2_KillComp( /* int Reason */ );


         /* AbEnd reasons */

#define _c2_CREPTWICE 1
#define _c2_RMFROMEMPTY 2

         /* Node queue states */

#define _c2_IDLE 1       /* Node is not running, and does not need to */
#define _c2_ONQUEUE 2    /* Node is queued to run, but has not started */
#define _c2_RUNNING 3    /* Node is running */
#define _c2_NEEDSRUN 4   /* Node needs to be queued to run again */

#ifdef _C2_DBGR_
#define _c2_ONDBGQ 5     /* node is stopped and on the debug Q */

/* Instead of running the workers, run the debugger first */
void _c2_RunDebugger(/*_c2_NodeBase *InitNode, int argc, char **argv */);

/* empty the queue for a new run */
void _c2_emptyRdyQ();

/* to handle sigsegv that can not be handled in sequent */
void _c2_ChldHndler();

/* Kill all the workers on exit from the debugger */
void _c2_KillWorkers();

/* handle the interrupt in c2dbgamin.c */

void _c2_inthandler();


#endif





#endif
