/* Data structure offsets */

#define Thread_sp		0
#define Thread_func		4
#define Thread_id_top	8
#define Thread_id_limit	12

#define IdEntry_id		0
#define IdEntry_pc		4
#define IdSize			8

#define pP_sp			0
#define pP_fp			4
#define pP_seed			8
#define pP_thread		12

#define SpinLock_lock	0
#define SpinLock_p		4

#define Graph_calleeID	0
#define Graph_callerID	4
#define Graph_num		8

#define 	OffPCTableBits	0xfffffff0

/* Stack offsets */

#define IdleLoop_Arg1	4

#define ReturnPC		4

/* Special bits in the ID word, representing the state of the computation.
 * Assumes no synch pointers >= 512Meg
 */

#define NoID			0
#define StateOffset		0x20000000
#define BusyState		0
#define SpinState		0x20000000
#define BlockedState	0x40000000
#define ReadyState		0x60000000
#define OverheadState	0x80000000

#define StateMask		0x60000000
#define StateOffMask	0x9fffffff
#define OverheadOffMask	0x7fffffff
#define AllStateMask	0xe0000000
#define AllOffMask		0x1fffffff

