/* The external interface to my thread package:
 *
 * The data structures
 * the routines (and macros)
*/

#ifndef ThreadArgs
#define ThreadArgs 		12
#endif

/* Several internal data structures, needed by Thread */

typedef struct id_stack {
	struct id_stack_entry *top;
	struct id_stack_entry *limit;	 /* DONT MOVE */
	struct id_stack_entry *base;
	} IdStack;

typedef struct spin_lock {
	int l;			 			/* slock_t is somewhat hard to predict */
	struct synch_profile *p; 	/* needed by profiling */
	unsigned int type;
	} SpinLock;

/* Subtract space for overhead */
#define StackSize	((0x4000 - 4)/ sizeof(int))
typedef struct stack
	{
	unsigned int type;
	int space[StackSize];
	struct stack *next;
	} Stack;


/* The basic thread data structure */ 

/* fields of Thread.join.status */
#define NOJOIN			0
#define JOIN			1
#define CALLEE_DONE		2
#define CALLER_READY	3

typedef struct thread
	{
	int *sp;			/* DO NOT MOVE -- see asmdefs.h */
	void (*func)();		/* DO NOT MOVE */
	IdStack idStack;	/* DO NOT MOVE */
	struct synch_profile *p;
	unsigned int type;
	struct thread *nextBunch;
	struct thread *next;
#ifndef PRESTO
	struct {
		int status;
		SpinLock lock;
		struct thread *waiter;
		} join;
	Stack *stack;
	int numargs;
	int arglist[ThreadArgs];
#endif
	} Thread;

/* Exported */

Thread *ThreadStart();
void ThreadMultiStart(), ThreadJoin();
#define ThreadExit()	THREAD_EXIT()

void ProgramDone();

extern shared int numProcessors;

/* Imported */
int Main();

