/*

fsynch.C

This set of routines is designed to emulate the FastThreads package
(used in the Sequent Symmetry implementation) on a Sparc platform
with Solaris threads.

By providing this emulation, we will be able to use the sequent backend
almost as-is, as we will be "plugging-in" the only architecture dependent
bit.

Although the FastThreads package provides barriers, conditions, etc.,
CODE only uses locks and threads, so those are the only ones implemented
here.


===
Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
Systems Analyst                 @          <mailto: emery@cs.utexas.edu>
Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
Department of Computer Sciences |             <http://www.cs.utexas.edu>
University of Texas at Austin   |                <http://www.utexas.edu>

*/

#include "fthread.h"
#include "fsynch.h"

#include <stdio.h>


void LockInit (Lock *lock, ...) {
  pthread_mutex_init(lock, MUTEX_FAST_NP);
}

/*

void LockAcquire (Lock *lock) {
  mutex_lock(lock);
}

void LockRelease (Lock *lock) {
  mutex_unlock(lock);
}

*/
