/*

fthread.c

This set of routines is designed to emulate the FastThreads package
(used in the Sequent Symmetry implementation) on a Cray platform
with POSIX threads.

By providing this emulation, we will be able to use the sequent backend
almost as-is, as we will be "plugging-in" the only architecture dependent
bit.

Although the FastThreads package provides barriers, conditions, etc.,
CODE only uses locks and threads, so those are the only ones implemented
here.


===
Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
Systems Analyst                 @          <mailto: emery@cs.utexas.edu>
Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
Department of Computer Sciences |             <http://www.cs.utexas.edu>
University of Texas at Austin   |                <http://www.utexas.edu>

*/

#include "fthread.h"

/*
   NOTE: due to shortcomings in UNICOS, it is not possible to completely
         emulate FastThreads (which allows multiple arguments).
	 However, since CODE (conveniently) only uses one-argument
	 procedure arguments in ThreadStart calls, this is not
	 a problem.
*/

#define _REENTRANT

#include <stdio.h>
#include <limits.h>

Thread *ThreadStart (void (*procedureToRun)(),
		     int willJoin, 
		     char *name,
		     int numberOfArguments,
		     int *arg1)
{
  Thread *thread;
  pthread_attr_t attr;
  int result;

  pthread_attr_init(&attr);
  pthread_attr_setdetachstate (&attr, PTHREAD_CREATE_JOINABLE);

  thread = (Thread *) malloc(sizeof(Thread));
  result = pthread_create (thread, &attr, (void *(*)(void*))procedureToRun, (void *) arg1);

  if (result) {
    printf("Error %d received.\n", result);
    exit(1);
  }

  return thread;
}


void ThreadJoin (Thread *thread) {
  pthread_join (*thread, NULL);
}

void ProgramDone () {}
