#include "c2_misc.h"


int _c2_nhost;
int _c2_narch;
struct pvmhostinfo **_c2_hostp; 

int _c2_tids[MaxPvmTasks];

char *_c2_cwd; /* Current working directory */
int _c2_mytid; /* My pvm task id */
int _c2_me;    /* My index in the list of pvm tasks */ 
int _c2_Terminated; /* Signal for global terminate */

_c2_GraphBase *MainGraph;
unsigned _c2_totalloc;


char *_c2_shmalloc(size)
   int size;
{
   char *tmp;

   tmp = (char *) malloc(size);
   if (tmp == 0) {
      fprintf(stderr, "Error: malloc failed\n");
      fflush(stderr);
   }

   return tmp;
}

void _c2_shfree(ptr)
char *ptr;
{

}

/* Test if two _c2_Indexes are equal */


int _c2_EqIndex(i1, i2)
   _c2_Index *i1; 
   _c2_Index *i2;
{
   register int i;

   if (i1->NumInd != i2->NumInd) return 0;

   for (i = 0; i < i1->NumInd; i++)
     if (i1->Ind[i] != i2->Ind[i]) return 0;

   return 1;
}

int _c2_PvmTaskMap(UID)
int UID;
{ 
   if (UID == 0)
    return 0;
   else
    return (UID % _c2_nhost);
} 

int _c2_MapToPvmTask(_c2_gr, _c2_gi, _c2_ni, UID, GUID)
_c2_GraphBase *_c2_gr;
_c2_Index *_c2_gi;
_c2_Index *_c2_ni;
int UID;
int GUID;
{
  int sum;
  int index;

  sum = _c2_PvmPathSum(_c2_gr->Path);

  for (index = 0; index < _c2_gi->NumInd; index++)
   sum += _c2_gi->Ind[index];
  for (index = 0; index < _c2_ni->NumInd; index++)
   sum += _c2_ni->Ind[index];
  sum += UID;
  if (UID != GUID) sum += GUID;
  return (sum % _c2_nhost);
}




int _c2_PvmPathSum(String)
char *String;
{
  int i = 0;
  int tempsum = 0;
  int len;
  int flag = 1;
  
  len = strlen(String);
  
  while ((i < len) && flag )
  {
    tempsum += atoi(String+i);
    while ((i < len) && isdigit(String[i]))
          i++;
    if (i >= len) flag = 0;
    else
    while (String[i] == '[')
    {  i++;
       tempsum += atoi(String+i);
       while(String[i] != ']') i++;
       i++;
    }
    i++;
  }
  return tempsum;
}

_c2_NodeBase *_c2_PathName_Decode(Path)
   char *Path;
{
   _c2_GraphBase *_c2_gr;
   _c2_NodeBase *_c2_TmpNode;
   _c2_Index Index;
   int id = 0;
   int len = 0;
   int i = 0;
   char *Pos;

   len = strlen(Path);
   Pos = strchr(Path, '/');
   Index.NumInd = 0;
   _c2_gr = MainGraph;
   while (i < len) {
      id = atoi(Path+i);
      while ((i < len) && isdigit(Path[i])) i++;

      while (Path[i] == '[') {
         i++;
         Index.Ind[Index.NumInd] = atoi(Path+i);
         Index.NumInd += 1;
         while(Path[i] != ']') i++;
         i++;
      }

      if (Path[i] == '/') {
         if ((Path+i) != Pos)
            _c2_gr = (_c2_GraphBase *) _c2_GetAddr( _c2_gr, id, &Index);
         Index.NumInd = 0;
         i++;
      } else {
        _c2_TmpNode = (_c2_NodeBase *) _c2_GetAddr(_c2_gr, id, &Index);
      }
   }
 
   return _c2_TmpNode;
}

_c2_GraphBase *_c2_GPathName_Decode(Path)
   char *Path;
{
   _c2_GraphBase *_c2_gr;
   _c2_Index Index;
   int id = 0;
   int len = 0;
   int i = 0;
   char *Pos;

   len = strlen(Path);
   Pos = strchr(Path, '/');
   Index.NumInd = 0;
   _c2_gr = MainGraph;
   while (i < len) {
      id = atoi(Path+i);
      while ((i < len) && isdigit(Path[i])) i++;

      while (Path[i] == '[') {
         i++;
         Index.Ind[Index.NumInd] = atoi(Path+i);
         Index.NumInd += 1;
         while(Path[i] != ']') i++;
         i++;
      }

      if ((Pos != NULL) && ((Path+i) != Pos))
         _c2_gr = (_c2_GraphBase *) _c2_GetAddr( _c2_gr, id, &Index);
      Index.NumInd = 0;
      i++;
   }
 
   return _c2_gr;
}
